<?php 
	require_once 'smis-framework/smis/template/ModulTemplate.php';

	class SetReturObatStatus extends ModulTemplate {
		private $db;
		private $dbslug;
		private $entity;
		private $unit;
		
		public function __construct($db, $dbslug, $entity="", $unit=""){
			$this->db=$db;
			$this->dbslug=$dbslug;
			$this->entity=$entity;
			$this->unit=$unit;
		}
		
		public function initialize(){
			$entity=$this->entity==""?"":"_".$this->entity;
			$response_package = new ResponsePackage();
			if (isset($_POST['command']) && $_POST['command'] == "push_save") {
				$id['id'] = $_POST['id'];
				$data['status'] = $_POST['status'];
				$retur_obat_dbtable = new DBTable($this->db, "smis_".$this->dbslug."_retur_obat".$entity);
				$retur_obat_dbtable->update($data, $id);
				if ($_POST['status'] == "dikembalikan") {
					$retur_obat_row = $retur_obat_dbtable->select($id);
					$stok_obat_dbtable = new DBTable($this->db, "smis_".$this->dbslug."_stok_obat".$entity);
					$stok_obat_row = $stok_obat_dbtable->select($retur_obat_row->id_stok_obat);
					$stok_data = array();
					$stok_data['sisa'] = $stok_obat_row->sisa + $retur_obat_row->jumlah;
					$stok_data['autonomous'] = "[".getSettings($this->db, "smis_autonomous_id", "")."]";
			        $stok_data['duplicate'] = 0;
			        $stok_data['time_updated'] = date("Y-m-d H:i:s");
			        $stok_data['origin_updated'] = getSettings($this->db, "smis_autonomous_id", "");
					$stok_id['id'] = $retur_obat_row->id_stok_obat;
					$stok_obat_dbtable->update($stok_data, $stok_id);
					//logging riwayat stok:
					$riwayat_dbtable = new DBTable($this->db, "smis_".$this->dbslug."_riwayat_stok_obat".$entity);
					$data_riwayat = array();
					$data_riwayat['tanggal'] = date("Y-m-d");
					$data_riwayat['id_stok_obat'] = $retur_obat_row->id_stok_obat;
					$data_riwayat['jumlah_masuk'] = $retur_obat_row->jumlah;
					$data_riwayat['sisa'] = $stok_obat_row->sisa - $retur_obat_row->jumlah;
					$data_riwayat['keterangan'] = "Pembatalan Retur Stok ke " . ArrayAdapter::format("unslug", "gudang_farmasi");
					$data_riwayat['nama_user'] = $_POST['username'];
					$data_riwayat['autonomous'] = "[".getSettings($this->db, "smis_autonomous_id", "")."]";
			        $data_riwayat['duplicate'] = 0;
			        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
			        $data_riwayat['origin_updated'] = getSettings($this->db, "smis_autonomous_id", "");
			        $data_riwayat['origin'] = getSettings($this->db, "smis_autonomous_id", "");
					$riwayat_dbtable->insert($data_riwayat);
					$id_riwayat = $riwayat_dbtable->get_inserted_id();

					$data_riwayat = array();
					$data_riwayat['origin_id'] = $id_riwayat;
					$data_riwayat_id = array();
					$data_riwayat_id['id'] = $id_riwayat;
					$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
					//logging kartu stok:
					$kartu_stok_dbtable = new DBTable($this->db, "smis_".$this->dbslug."_kartu_stok_obat".$entity);
					$sisa_row = $this->db->get_row("
						SELECT SUM(a.sisa) AS 'sisa'
						FROM " . "smis_".$this->dbslug."_stok_obat".$entity . " a LEFT JOIN " . "smis_".$this->dbslug."_obat_masuk".$entity . " b ON a.id_obat_masuk = b.id
						WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $stok_obat_row->id_obat . "' AND a.satuan = '" . $stok_obat_row->satuan . "' AND a.konversi = '1' AND b.prop NOT LIKE 'del' AND b.status = 'sudah'
					");
					$kartu_stok_data = array(
						"f_id"				=> $id['id'],
						"no_bon"			=> $id['id'],
						"unit"				=> "Retur Obat : " . ArrayAdapter::format("unslug", "gudang_farmasi") . ", Pembatalan",
						"id_obat"			=> $stok_obat_row->id_obat,
						"kode_obat"			=> $stok_obat_row->kode_obat,
						"nama_obat"			=> $stok_obat_row->nama_obat,
						"nama_jenis_obat"	=> $stok_obat_row->nama_jenis_obat,
						"tanggal"			=> date("Y-m-d"),
						"tanggal_transaksi"	=> date("Y-m-d"),
						"masuk"				=> $retur_obat_row->jumlah,
						"keluar"			=> 0,
						"sisa"				=> $sisa_row->sisa
					);
					$kartu_stok_dbtable->insert($kartu_stok_data);
					$id_kartu_stok = $kartu_stok_dbtable->get_inserted_id();

					$kartu_stok_data = array();
					$kartu_stok_data['origin_id'] = $id_kartu_stok;
					$kartu_stok_data_id = array();
					$kartu_stok_data_id['id'] = $id_kartu_stok;
					$kartu_stok_dbtable->update($kartu_stok_data, $kartu_stok_data_id);
				}
				$response_package->setStatus(ResponsePackage::$STATUS_OK);
			} else {
				$response_package->setStatus(ResponsePackage::$STATUS_FAIL);
			}
			echo json_encode($response_package->getPackage());
		}
	}
?>