<?php 
	require_once 'smis-framework/smis/template/ModulTemplate.php';

	class PushObat extends ModulTemplate {
		private $db;
		private $dbslug;
		private $entity;
		private $unit;
		private $tbl_stok_obat;
		private $tbl_obat_masuk;
		private $tbl_riwayat;
		private $tbl_kartu_stok;
		
		public function __construct($db, $dbslug, $entity="", $unit=""){
			$this->db=$db;
			$this->dbslug=$dbslug;
			$this->entity=$entity;
			$entity=$this->entity==""?"":"_".$this->entity;
			$this->tbl_stok_obat="smis_".$this->dbslug."_stok_obat".$entity;
			$this->tbl_obat_masuk="smis_".$this->dbslug."_obat_masuk".$entity;
			$this->tbl_riwayat="smis_".$this->dbslug."_riwayat_stok_obat".$entity;
			$this->tbl_kartu_stok="smis_".$this->dbslug."_kartu_stok_obat".$entity;
			$this->unit=$unit;
		}
		
		public function initialize(){
			$response_package = new ResponsePackage();
			if (isset($_POST['command'])) {
				if ($_POST['command'] == "push_save") {
					$obat_masuk_dbtable = new DBTable($this->db,$this->tbl_obat_masuk);
					$id=array();
					$id['f_id']=$_POST['id_obat_keluar'];
					$id['unit']=$_POST['unit'];
					$obat_masuk_row = $obat_masuk_dbtable->select($id);
					if ($obat_masuk_row == null) {
						//do insert:
						$obat_masuk_data = array();
						$obat_masuk_data['f_id'] = $_POST['id_obat_keluar'];
						$obat_masuk_data['tanggal'] = $_POST['tanggal'];
						$obat_masuk_data['unit'] = $_POST['unit'];
						$obat_masuk_data['status'] = $_POST['status'];
						$obat_masuk_data['keterangan'] = $_POST['keterangan'];
						$obat_masuk_data['autonomous'] = "[" . getSettings($this->db, "smis_autonomous_id", "") . "]";
						$obat_masuk_data['duplicate'] = 0;
						$obat_masuk_data['time_updated'] = date("Y-m-d H:i:s");
						$obat_masuk_data['origin_updated'] = getSettings($this->db, "smis_autonomous_id", "");
						$obat_masuk_dbtable->insert($obat_masuk_data);
						$obat_masuk_id = $obat_masuk_dbtable->get_inserted_id();

						$obat_masuk_data = array();
						$obat_masuk_data['origin_id'] = $obat_masuk_id;
						$obat_masuk_data_id = array();
						$obat_masuk_data_id['id'] = array();
						$obat_masuk_dbtable->update($obat_masuk_data, $obat_masuk_data_id);

						$obat_masuk_detail = json_decode($_POST['detail'], true);
						$stok_obat_dbtable = new DBTable($this->db,$this->tbl_stok_obat);
						$riwayat_dbtable = new DBTable($this->db,$this->tbl_riwayat);
						$kartu_stok_dbtable = new DBTable($this->db,$this->tbl_kartu_stok);
						foreach($obat_masuk_detail as $stok_obat) {
							$stok_obat_data = array();
							$stok_obat_data['f_id'] = $stok_obat['id_stok_obat_keluar'];
							$stok_obat_data['id_obat_masuk'] = $obat_masuk_id;
							$stok_obat_data['kode_obat'] = $stok_obat['kode_obat'];
							$stok_obat_data['id_obat'] = $stok_obat['id_obat'];
							$stok_obat_data['nama_obat'] = $stok_obat['nama_obat'];
							$stok_obat_data['nama_jenis_obat'] = $stok_obat['nama_jenis_obat'];
							$stok_obat_data['formularium'] = $stok_obat['formularium'];
							$stok_obat_data['generik'] = $stok_obat['generik'];
							$stok_obat_data['berlogo'] = $stok_obat['berlogo'];
							$stok_obat_data['label'] = $stok_obat['label'];
							$stok_obat_data['id_vendor'] = $stok_obat['id_vendor'];
							$stok_obat_data['nama_vendor'] = $stok_obat['nama_vendor'];
							$stok_obat_data['jumlah'] = $stok_obat['jumlah'];
							$stok_obat_data['sisa'] = $stok_obat['jumlah'];
							$stok_obat_data['satuan'] = $stok_obat['satuan'];
							$stok_obat_data['konversi'] = $stok_obat['konversi'];
							$stok_obat_data['satuan_konversi'] = $stok_obat['satuan_konversi'];
							$stok_obat_data['hna'] = $stok_obat['hna'];
							$stok_obat_data['produsen'] = $stok_obat['produsen'];
							$stok_obat_data['tanggal_exp'] = $stok_obat['tanggal_exp'];
							$stok_obat_data['no_batch'] = $stok_obat['no_batch'];
							$stok_obat_data['autonomous'] = "[" . getSettings($this->db, "smis_autonomous_id", "") . "]";
							$stok_obat_data['duplicate'] = 0;
							$stok_obat_data['time_updated'] = date("Y-m-d H:i:s");
							$stok_obat_data['origin_updated'] = getSettings($this->db, "smis_autonomous_id", "");
							$stok_obat_dbtable->insert($stok_obat_data);
							$stok_obat_id = $stok_obat_dbtable->get_inserted_id();

							$stok_obat_data = array();
							$stok_obat_data['origin_id'] = $stok_obat_id;
							$stok_obat_data_id = array();
							$stok_obat_data_id['id'] = $stok_obat_id;
							$stok_obat_dbtable->update($stok_obat_data, $stok_obat_id);

							if ($_POST['status'] == "sudah") {
								$data_riwayat = array();
								$data_riwayat['tanggal'] = date("Y-m-d");
								$data_riwayat['id_stok_obat'] = $stok_obat_id;
								$data_riwayat['jumlah_masuk'] = $stok_obat['jumlah'];
								$data_riwayat['sisa'] = $stok_obat['jumlah'];
								$data_riwayat['keterangan'] = "Stok Masuk dari " . ArrayAdapter::format("unslug", $_POST['unit']);
								global $user;
								$data_riwayat['nama_user'] = $user->getName();
								$data_riwayat['duplicate'] = 0;
								$data_riwayat['time_updated'] = date("Y-m-d H:i:s");
								$riwayat_dbtable->insert($data_riwayat);
								$id_riwayat = $riwayat_dbtable->get_inserted_id();

								$data_riwayat = array();
								$data_riwayat['origin_id'] = $id_riwayat;
								$data_riwayat_id = array();
								$data_riwayat_id['id'] = $id_riwayat;
								$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
								
								$sisa_row = $this->db->get_row("
									SELECT 
										SUM(a.sisa) AS 'sisa'
									FROM 
										" . $this->tbl_stok_obat . " a 
											LEFT JOIN " . $this->tbl_obat_masuk . " b ON a.id_obat_masuk = b.id
									WHERE 
										a.prop NOT LIKE 'del' 
											AND a.id_obat = '" . $stok_obat['id_obat'] . "' 
											AND b.prop NOT LIKE 'del' 
											AND b.status = 'sudah'
								");
								$kartu_stok_data = array(
									"f_id"				=> $obat_masuk_id,
									"no_bon"			=> $_POST['id_obat_keluar'],
									"unit"				=> "Mutasi Obat : " . ArrayAdapter::format("unslug", $_POST['unit']),
									"id_obat"			=> $stok_obat['id_obat'],
									"kode_obat"			=> $stok_obat['kode_obat'],
									"nama_obat"			=> $stok_obat['nama_obat'],
									"nama_jenis_obat"	=> $stok_obat['nama_jenis_obat'],
									"tanggal"			=> date("Y-m-d"),
									"tanggal_transaksi"	=> date("Y-m-d"),
									"masuk"				=> $stok_obat['jumlah'],
									"keluar"			=> 0,
									"sisa"				=> $sisa_row->sisa
								);
								$kartu_stok_dbtable->insert($kartu_stok_data);
								$kartu_stok_id = $kartu_stok_dbtable->get_inserted_id();

								$kartu_stok_data = array();
								$kartu_stok_data['origin_id'] = $kartu_stok_id;
								$kartu_stok_data_id = array();
								$kartu_stok_data_id['id'] = $kartu_stok_id;
								$kartu_stok_dbtable->update($kartu_stok_data, $kartu_stok_data_id);
							}
						}
						//notify:
						global $notification;
						$key=md5($this->unit." ".$obat_masuk_id);
						$msg="Obat Masuk di <strong>".ArrayAdapter::format("unslug", $this->unit)."</strong> dari <strong>GUDANG FARMASI</strong>";
						$notification->addNotification("Obat Masuk", $key, $msg, $this->unit,"boi");
					} else {
						//do update:
						$obat_masuk_data = array();
						$obat_masuk_id['id'] = $obat_masuk_row->id;
						$obat_masuk_data['status'] = $_POST['status'];
						$obat_masuk_data['keterangan'] = $_POST['keterangan'];
						$obat_masuk_data['autonomous'] = "[" . getSettings($this->db, "smis_autonomous_id", "") . "]";
						$obat_masuk_data['duplicate'] = 0;
						$obat_masuk_data['time_updated'] = date("Y-m-d H:i:s");
						$obat_masuk_dbtable->update($obat_masuk_data, $obat_masuk_id);
						$obat_masuk_detail = json_decode($_POST['detail'], true);
						$stok_obat_dbtable = new DBTable($this->db,$this->tbl_stok_obat);
						foreach($obat_masuk_detail as $stok_obat) {
							$ids=array();
							$ids['f_id']=$stok_obat['id_stok_obat_keluar'];
							$ids['id_obat_masuk']=$obat_masuk_row->id;
							$stok_obat_row = $stok_obat_dbtable->select($ids);
							if ($stok_obat_row == null) {
								//do insert if f_id not exist:
								$stok_obat_data = array();
								$stok_obat_data['f_id'] = $stok_obat['id_stok_obat_keluar'];
								$stok_obat_data['id_obat_masuk'] = $obat_masuk_row->id;
								$stok_obat_data['kode_obat'] = $stok_obat['kode_obat'];
								$stok_obat_data['id_obat'] = $stok_obat['id_obat'];
								$stok_obat_data['nama_obat'] = $stok_obat['nama_obat'];
								$stok_obat_data['nama_jenis_obat'] = $stok_obat['nama_jenis_obat'];
								$stok_obat_data['label'] = $stok_obat['label'];
								$stok_obat_data['id_vendor'] = $stok_obat['id_vendor'];
								$stok_obat_data['nama_vendor'] = $stok_obat['nama_vendor'];
								$stok_obat_data['jumlah'] = $stok_obat['jumlah'];
								$stok_obat_data['sisa'] = $stok_obat['jumlah'];
								$stok_obat_data['satuan'] = $stok_obat['satuan'];
								$stok_obat_data['konversi'] = $stok_obat['konversi'];
								$stok_obat_data['satuan_konversi'] = $stok_obat['satuan_konversi'];
								$stok_obat_data['hna'] = $stok_obat['hna'];
								$stok_obat_data['produsen'] = $stok_obat['produsen'];
								$stok_obat_data['tanggal_exp'] = $stok_obat['tanggal_exp'];
								$stok_obat_data['no_batch'] = $stok_obat['no_batch'];
								$stok_obat_data['autonomous'] = "[" . getSettings($this->db, "smis_autonomous_id", "") . "]";
								$stok_obat_data['duplicate'] = 0;
								$stok_obat_data['time_updated'] = date("Y-m-d H:i:s");
								$stok_obat_data['origin_updated'] = getSettings($this->db, "smis_autonomous_id", "");
								$stok_obat_dbtable->insert($stok_obat_data);
								$stok_obat_id = $stok_obat_dbtable->get_inserted_id();

								$stok_obat_data = array();
								$stok_obat_data['origin_id'] = $stok_obat_id;
								$stok_obat_data_id = array();
								$stok_obat_data_id['id'] = $stok_obat_id;
								$stok_obat_dbtable->update($stok_obat_data, $stok_obat_id);								
							} else {
								//do update or delete if f_id exist:
								$stok_obat_id['id'] = $stok_obat_row->id;
								$stok_obat_data = array();
								$stok_obat_data['jumlah'] = $stok_obat['jumlah'];
								$stok_obat_data['sisa'] = $stok_obat['jumlah'];
								$stok_obat_data['prop'] = $stok_obat['prop'];
								$stok_obat_data['autonomous'] = "[" . getSettings($this->db, "smis_autonomous_id", "") . "]";
								$stok_obat_data['duplicate'] = 0;
								$stok_obat_data['time_updated'] = date("Y-m-d H:i:s");
								$stok_obat_dbtable->update($stok_obat_data, $stok_obat_id);
							}
						}
					}
					$response_package->setStatus(ResponsePackage::$STATUS_OK);
				} else if ($_POST['command'] == "push_delete") {
					$obat_masuk_dbtable = new DBTable($this->db,$this->tbl_obat_masuk);
					$id=array();
					$id['f_id']=$_POST['id_obat_keluar'];
					$id['unit']=$_POST['unit'];
					$obat_masuk_row = $obat_masuk_dbtable->select($id);
					if ($obat_masuk_row != null) {
						$obat_masuk_id['id'] = $obat_masuk_row->id;
						$obat_masuk_data['prop'] = "del";
						$obat_masuk_data['autonomous'] = "[" . getSettings($this->db, "smis_autonomous_id", "") . "]";
						$obat_masuk_data['duplicate'] = 0;
						$obat_masuk_data['time_updated'] = date("Y-m-d H:i:s");
						$obat_masuk_dbtable->update($obat_masuk_data, $obat_masuk_id);
					}
					$response_package->setStatus(ResponsePackage::$STATUS_OK);
				} else {
					$response_package->setStatus(ResponsePackage::$STATUS_FAIL);
				}
			} else {
				$response_package->setStatus(ResponsePackage::$STATUS_FAIL);
			}
			echo json_encode($response_package->getPackage());
		}	
	}
?>