<?php 
	require_once("smis-base/smis-include-duplicate.php");

	class PenggunaanObatDBResponder extends DuplicateResponder {
		private $tbl_penggunaan;
		private $tbl_stok;
		private $tbl_riwayat_stok;
		private $tbl_obat_masuk;
		private $tbl_kartu_stok;
		
		public function __construct($dbtable, $uitable, $adapter,$tbl_penggunaan,$tbl_stok,$tbl_riwayat_stok,$tbl_obat_masuk,$tbl_kartu_stok){
			parent::__construct($dbtable, $uitable, $adapter);
			$this->tbl_penggunaan=$tbl_penggunaan;
			$this->tbl_stok=$tbl_stok;
			$this->tbl_riwayat_stok=$tbl_riwayat_stok;
			$this->tbl_obat_masuk=$tbl_obat_masuk;
			$this->tbl_kartu_stok=$tbl_kartu_stok;
		}
		
		public function save() {
			$data = $this->postToArray();
			//do insert here:
			$result = $this->dbtable->insert($data);
			$id['id'] = $this->dbtable->get_inserted_id();
			$success['type'] = "insert";
			$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), $this->tbl_stok);
			$stok_obat_row = $stok_obat_dbtable->select($data['id_stok_obat']);
			$stok_data = array();
			$stok_data['sisa'] = $stok_obat_row->sisa - $data['jumlah'];
			$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
	        $stok_data['duplicate'] = 0;
	        $stok_data['time_updated'] = date("Y-m-d H:i:s");
	        $stok_data['origin_updated'] = $this->getAutonomous();
			$stok_id['id'] = $data['id_stok_obat'];
			$stok_obat_dbtable->update($stok_data, $stok_id);
			//logging riwayat stok:
			$riwayat_dbtable = new DBTable($this->dbtable->get_db(), $this->tbl_riwayat_stok);
			$data_riwayat = array();
			$data_riwayat['tanggal'] = date("Y-m-d");
			$data_riwayat['id_stok_obat'] = $data['id_stok_obat'];
			$data_riwayat['jumlah_keluar'] = $data['jumlah'];
			$data_riwayat['sisa'] = $stok_obat_row->sisa - $data['jumlah'];
			$keterangan = $data['keterangan'];
			if ($keterangan == "")
				$keterangan = "-";
			$data_riwayat['keterangan'] = "Stok Digunakan: " . $keterangan;
			global $user;
			$data_riwayat['nama_user'] = $user->getName();
			$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
	        $data_riwayat['duplicate'] = 0;
	        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
	        $data_riwayat['origin_updated'] = $this->getAutonomous();
	        $data_riwayat['origin'] = $this->getAutonomous();
			$riwayat_dbtable->insert($data_riwayat);
			//logging kartu stok:
			$kartu_stok_dbtable = new DBTable($this->dbtable->get_db(), $this->tbl_kartu_stok);
			$sisa_row = $this->dbtable->get_row("
				SELECT SUM(a.sisa) AS 'sisa'
				FROM " . $this->tbl_stok . " a LEFT JOIN " . $this->tbl_obat_masuk . " b ON a.id_obat_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $stok_obat_row->id_obat . "' AND a.satuan = '" . $stok_obat_row->satuan . "' AND a.konversi = '1' AND b.prop NOT LIKE 'del' AND b.status = 'sudah'
			");
			$kartu_stok_data = array(
				"f_id"				=> $id['id'],
				"no_bon"			=> $id['id'],
				"unit"				=> "Penggunaan Obat : " . $keterangan,
				"id_obat"			=> $stok_obat_row->id_obat,
				"kode_obat"			=> $stok_obat_row->kode_obat,
				"nama_obat"			=> $stok_obat_row->nama_obat,
				"nama_jenis_obat"	=> $stok_obat_row->nama_jenis_obat,
				"tanggal"			=> date("Y-m-d"),
				"tanggal_transaksi"	=> date("Y-m-d"),
				"masuk"				=> 0,
				"keluar"			=> $data['jumlah'],
				"sisa"				=> $sisa_row->sisa
			);
			$kartu_stok_dbtable->insert($kartu_stok_data);
			$success['id'] = $id['id'];
			$success['success'] = 1;
			if ($result === false) $success['success'] = 0;
			return $success;
		}
		
		public function edit() {
			$id = $_POST['id'];
			$data = $this->dbtable->get_row("
							SELECT ".$this->tbl_penggunaan.".*, ".$this->tbl_stok.".nama_obat, ".$this->tbl_stok.".nama_jenis_obat, ".$this->tbl_stok.".satuan, ".$this->tbl_stok.".tanggal_exp
							FROM ".$this->tbl_penggunaan." LEFT JOIN ".$this->tbl_stok." ON ".$this->tbl_penggunaan.".id_stok_obat = ".$this->tbl_stok.".id
							WHERE ".$this->tbl_penggunaan.".prop NOT LIKE 'del' AND ".$this->tbl_penggunaan.".id = '" . $id . "'
						");
			return $data;
		}
		
		public function delete() {
			$id['id'] = $_POST['id'];
			if ($this->dbtable->isRealDelete()) {
				$result = $this->dbtable->delete(null,$id);
			} else {
				$data['prop'] = "del";
				$result = $this->dbtable->update($data, $id);
			}
			$penggunaan_obat_row = $this->dbtable->select($id['id']);
			$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), $this->tbl_stok);
			$stok_obat_row = $stok_obat_dbtable->select($penggunaan_obat_row->id_stok_obat );
			$stok_data = array();
			$stok_data['sisa'] = $stok_obat_row->sisa + $penggunaan_obat_row->jumlah;
			$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
			$stok_data['duplicate'] = 0;
			$stok_data['time_updated'] = date("Y-m-d H:i:s");
			$stok_data['origin_updated'] = $this->getAutonomous();
			$stok_id['id'] = $penggunaan_obat_row->id_stok_obat;
			$stok_obat_dbtable->update($stok_data, $stok_id);
			//logging riwayat stok:
			$riwayat_dbtable = new DBTable($this->dbtable->get_db(), $this->tbl_riwayat_stok);
			$data_riwayat = array();
			$data_riwayat['tanggal'] = date("Y-m-d");
			$data_riwayat['id_stok_obat'] = $penggunaan_obat_row->id_stok_obat;
			$data_riwayat['jumlah_masuk'] = $penggunaan_obat_row->jumlah;
			$data_riwayat['sisa'] = $stok_obat_row->sisa + $penggunaan_obat_row->jumlah;
			$data_riwayat['keterangan'] = "Stok Batal Digunakan";
			global $user;
			$data_riwayat['nama_user'] = $user->getName();
			$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
	        $data_riwayat['duplicate'] = 0;
	        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
	        $data_riwayat['origin_updated'] = $this->getAutonomous();
	        $data_riwayat['origin'] = $this->getAutonomous();
			$riwayat_dbtable->insert($data_riwayat);
			//logging kartu stok:
			$kartu_stok_dbtable = new DBTable($this->dbtable->get_db(), $this->tbl_kartu_stok);
			$sisa_row = $this->dbtable->get_row("
				SELECT SUM(a.sisa) AS 'sisa'
				FROM " . $this->tbl_stok . " a LEFT JOIN " . $this->tbl_obat_masuk . " b ON a.id_obat_masuk = b.id
				WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $stok_obat_row->id_obat . "' AND a.satuan = '" . $stok_obat_row->satuan . "' AND a.konversi = '1' AND b.prop NOT LIKE 'del' AND b.status = 'sudah'
			");
			$kartu_stok_data = array(
				"f_id"				=> $id['id'],
				"no_bon"			=> $id['id'],
				"unit"				=> "Retur Obat : " . ArrayAdapter::format("unslug", "gudang_farmasi") . ", Pembatalan",
				"id_obat"			=> $stok_obat_row->id_obat,
				"kode_obat"			=> $stok_obat_row->kode_obat,
				"nama_obat"			=> $stok_obat_row->nama_obat,
				"nama_jenis_obat"	=> $stok_obat_row->nama_jenis_obat,
				"tanggal"			=> date("Y-m-d"),
				"tanggal_transaksi"	=> date("Y-m-d"),
				"masuk"				=> $penggunaan_obat_row->jumlah,
				"keluar"			=> 0,
				"sisa"				=> $sisa_row->sisa
			);
			$kartu_stok_dbtable->insert($kartu_stok_data);
			$success['success'] = 1;
			$success['id'] = $_POST['id'];
			if ($result === 'false') $success['success'] = 0;
			return $success;
		}
	}
?>