<?php 
	require_once("smis-base/smis-include-duplicate.php");

	class ObatMasukDBResponder extends DuplicateResponder {
		private $dbstok;
		private $dbriwayat_stok;
		private $dbkartu_stok;

		public function __construct($dbtable, $uitable, $adapter, $dbstok, $dbriwayat_stok, $dbkartu_stok){
			parent::__construct($dbtable, $uitable, $adapter);
			$this->dbstok = $dbstok;
			$this->dbriwayat_stok = $dbriwayat_stok;
			$this->dbkartu_stok = $dbkartu_stok;
		}
		
		public function save() {
			$header_data = array();
			$header_data['status'] = $_POST['status'];
			$header_data['keterangan'] = $_POST['keterangan'];
			$header_data['autonomous'] = "[".$this->getAutonomous()."]";
	        $header_data['duplicate'] = 0;
	        $header_data['time_updated'] = date("Y-m-d H:i:s");
	        $header_data['origin_updated'] = $this->getAutonomous();
			$id['id'] = $_POST['id'];
			$result = $this->dbtable->update($header_data, $id);
			if ($_POST['status'] == "sudah") {
				//logging riwayat stok:
				$stok_rows = $this->dbtable->get_result("
					SELECT " . $this->dbstok . ".*, " . $this->dbtable->getName() . ".unit
					FROM " . $this->dbstok . " LEFT JOIN " . $this->dbtable->getName() . " ON " . $this->dbstok . ".id_obat_masuk = " . $this->dbtable->getName() . ".id
					WHERE " . $this->dbstok . ".id_obat_masuk = '" . $id['id'] . "'
				");
				$riwayat_dbtable = new DBTable($this->dbtable->get_db(), $this->dbriwayat_stok);
				foreach($stok_rows as $sr) {
					$data_riwayat = array();
					$data_riwayat['tanggal'] = date("Y-m-d");
					$data_riwayat['id_stok_obat'] = $sr->id;
					$data_riwayat['jumlah_masuk'] = $sr->jumlah;
					$data_riwayat['sisa'] = $sr->sisa;
					$data_riwayat['keterangan'] = "Stok Masuk dari " . ArrayAdapter::format("unslug", $sr->unit);
					global $user;
					$data_riwayat['nama_user'] = $user->getName();
					$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
			        $data_riwayat['duplicate'] = 0;
			        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
			        $data_riwayat['origin_updated'] = $this->getAutonomous();
			        $data_riwayat['origin'] = $this->getAutonomous();
					$riwayat_dbtable->insert($data_riwayat);
					$id_riwayat = $riwayat_dbtable->get_inserted_id();

					$data_riwayat = array();
					$data_riwayat['origin_id'] = $id_riwayat;
					$data_riwayat_id = array();
					$data_riwayat_id['id'] = $id_riwayat;
					$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
				}
				//logging kartu stok:
				$header_row = $this->dbtable->get_row("
					SELECT *
					FROM " . $this->dbtable->getName() . "
					WHERE id = '" . $_POST['id'] . "'
				");
				$detail_rows = $this->dbtable->get_result("
					SELECT id_obat, kode_obat, nama_obat, nama_jenis_obat, SUM(jumlah) AS 'jumlah', satuan
					FROM " . $this->dbstok . "
					WHERE id_obat_masuk = '" . $_POST['id'] . "' AND prop NOT LIKE 'del'
					GROUP BY id_obat
				");
				$kartu_stok_dbtable = new DBTable($this->dbtable->get_db(), $this->dbkartu_stok);
				foreach ($detail_rows as $dr) {
					$sisa_row = $this->dbtable->get_row("
						SELECT SUM(a.sisa) AS 'sisa'
						FROM " . $this->dbstok . " a LEFT JOIN " . $this->dbtable->getName() . " b ON a.id_obat_masuk = b.id
						WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $dr->id_obat . "' AND a.satuan = '" . $dr->satuan . "' AND a.konversi = '1' AND b.prop NOT LIKE 'del' AND b.status = 'sudah'
					");
					$kartu_stok_data = array(
						"f_id"				=> $header_row->id,
						"no_bon"			=> $header_row->f_id,
						"unit"				=> "Mutasi Obat : " . ArrayAdapter::format("unslug", $header_row->unit),
						"id_obat"			=> $dr->id_obat,
						"kode_obat"			=> $dr->kode_obat,
						"nama_obat"			=> $dr->nama_obat,
						"nama_jenis_obat"	=> $dr->nama_jenis_obat,
						"tanggal"			=> date("Y-m-d"),
						"tanggal_transaksi"	=> date("Y-m-d"),
						"masuk"				=> $dr->jumlah,
						"keluar"			=> 0,
						"sisa"				=> $sisa_row->sisa
					);
					$exist_row = $kartu_stok_dbtable->get_row("
						SELECT COUNT(*) AS 'jumlah'
						FROM " . $this->dbkartu_stok . "
						WHERE f_id = '" . $header_row->id . "' AND no_bon = '" . $header_row->f_id . "' AND id_obat = '" . $dr->id_obat . "' AND kode_obat = '" . $dr->kode_obat . "' AND nama_obat = '" . $dr->nama_obat . "' AND tanggal = '" . date("Y-m-d") . "' AND masuk = '" . $dr->jumlah . "' AND keluar = '0' AND sisa = '" . $sisa_row->sisa . "' AND prop NOT LIKE 'del'
					");
					if ($exist_row != null && $exist_row->jumlah == 0) {
						$kartu_stok_dbtable->insert($kartu_stok_data);
						$kartu_stok_id = $kartu_stok_dbtable->get_inserted_id();

						$kartu_stok_data = array();
						$kartu_stok_data['origin_id'] = $kartu_stok_id;
						$kartu_stok_data_id = array();
						$kartu_stok_data_id['id'] = $kartu_stok_id;
						$kartu_stok_dbtable->update($kartu_stok_data, $kartu_stok_data_id);
					}
				}
			}
			$success['type'] = "update";
			$success['id'] = $id['id'];
			$success['success'] = 1;
			if ($result === false) $success['success'] = 0;
			return $success;
		}
		public function edit() {
			$id = $_POST['id'];
			$header_row = $this->dbtable->select($id);
			if ($header_row->tanggal == "0000-00-00" || $header_row->tanggal == null)
				$header_row->tanggal = "-";
			$data['header'] = $header_row;
			$qv="
				SELECT id_obat, nama_obat, nama_jenis_obat, label, 
				SUM(jumlah) AS 'jumlah', satuan, konversi, satuan_konversi, tanggal_exp, no_batch
				FROM ". $this->dbstok;
			$detail_dbtable = new DBTable($this->dbtable->get_db(), $this->dbstok);
			$detail_dbtable->setPreferredQuery(true, $qv, "");
			$detail_dbtable->setUseWhereForView(true);
			$detail_dbtable->setShowAll(true);
			$detail_dbtable->addCustomKriteria("id_obat_masuk", "= '" . $id . "'");
			$detail_dbtable->setGroupBy(true, "id_obat, satuan, konversi, satuan_konversi");
			$view=$detail_dbtable->getQueryView("", "0");
			$data['detail'] = $detail_dbtable->get_result($view['query']);
			return $data;
		}
	}
?>