<?php 
	require_once 'smis-framework/smis/template/ModulTemplate.php';

	class PenyesuaianStok extends ModulTemplate {
		private $db;
		private $name;
		private $entity;
		private $dbslug;
		private $proto_name;
		private $proto_implement;
		private $proto_slug;
		
		private $barang_masuk;
		private $penyesuaian_barang;
		private $stok_barang;
		private $riwayat_stok_barang;
		private $kartu_stok_barang;
		
		private $obat_masuk;
		private $penyesuaian_obat;
		private $stok_obat;
		private $riwayat_stok_obat;
		private $kartu_stok_obat;
		
		private $is_use_obat;
		private $is_use_barang;
		private $is_use_inventaris;
		
		private $obat_property;
		private $barang_property;
		
		public function __construct($db, $name, $entity, $dbslug) {
			$this->db = $db;
			$this->name = $name;
			$this->entity = $entity;
			$this->dbslug = $dbslug;
			$this->proto_name = "";
			$this->proto_slug = "";
			$this->proto_implement = "";
			$this->is_use_obat = true;
			$this->is_use_barang = true;
			$this->is_use_inventaris = true;
			$this->obat_property = array();
			$this->barang_property = array();
			
			$this->barang_masuk = "smis_".$dbslug."_barang_masuk";
			$this->penyesuaian_barang = "smis_".$dbslug."_penyesuaian_stok_barang";
			$this->stok_barang = "smis_".$dbslug."_stok_barang";
			$this->riwayat_stok_barang = "smis_".$dbslug."_riwayat_stok_barang";
			$this->kartu_stok_barang="smis_".$dbslug."_kartu_stok_barang";
			$this->obat_masuk="smis_".$dbslug."_obat_masuk";
			$this->penyesuaian_obat = "smis_".$dbslug."_penyesuaian_stok_obat";
			$this->stok_obat = "smis_".$dbslug."_stok_obat";
			$this->riwayat_stok_obat = "smis_".$dbslug."_riwayat_stok_obat";
			$this->kartu_stok_obat="smis_".$dbslug."_kartu_stok_obat";
		}
		
		public function setPrototype($pname,$pslug,$pimplement){
			$this->proto_name = $pname;
			$this->proto_implement = $pimplement;
			$this->proto_slug = $pslug;
			
			$this->barang_masuk = "smis_".$this->dbslug."_barang_masuk_".$pslug;
			$this->penyesuaian_barang = "smis_".$this->dbslug."_penyesuaian_stok_barang_".$pslug;
			$this->stok_barang = "smis_".$this->dbslug."_stok_barang_".$pslug;
			$this->riwayat_stok_barang = "smis_".$this->dbslug."_riwayat_stok_barang_".$pslug;
			$this->kartu_stok_barang="smis_".$this->dbslug."_kartu_stok_barang_".$pslug;
			$this->obat_masuk = "smis_".$this->dbslug."_obat_masuk_".$pslug;
			$this->penyesuaian_obat = "smis_".$this->dbslug."_penyesuaian_stok_obat_".$pslug;
			$this->stok_obat = "smis_".$this->dbslug."_stok_obat_".$pslug;
			$this->riwayat_stok_obat = "smis_".$this->dbslug."_riwayat_stok_obat_".$pslug;
			$this->kartu_stok_obat="smis_".$this->dbslug."_kartu_stok_obat_".$pslug;
		}
		
		public function setUsePenyesuaianStok($barang,$obat,$inventaris){
			$this->is_use_barang=$barang;
			$this->is_use_obat=$obat;
			$this->is_use_inventaris=$inventaris;
		}
		
		public function setObatProperty($slug,$val){
			$this->obat_property[$slug]=$val;
		}
		
		public function setBarangProperty($slug,$val){
			$this->barang_property[$slug]=$val;
		}
		
		public function initialize(){
			$action = $_POST['action'];
			if ($action == "penyesuaian_stok") {
				$this->phpPreLoad();
				return;
			}
			
			switch ($action){
				case "detail_stok_barang" : $this->detailBarang(); break;
				case "riwayat_penyesuaian_stok_barang" : $this->riwayatBarang(); break;
				case "detail_stok_obat" : $this->detailObat(); break;
				case "riwayat_penyesuaian_stok_obat" : $this->riwayatObat(); break;
			}
			
		}
		
		public function phpPreLoad(){		
			$penyesuaian_stok = new Tabulator("peneysuaian_stok", "");

			if ($this->is_use_obat) {
				$obat = new Tabulator("obat", "", Tabulator::$LANDSCAPE);
				if (!isset($this->obat_property['detail_stok_obat']) || $this->obat_property['detail_stok_obat']) {
					ob_start(); 
					$this->detailObat(); 
					$detail_stok_obat = ob_get_clean();
					$obat->add("detail_stok_obat", "Penyesuaian", $detail_stok_obat, Tabulator::$TYPE_HTML, "fa fa-adjust");
				}
				if (!isset($this->obat_property['riwayat_penyesuaian_stok_obat']) || $this->obat_property['riwayat_penyesuaian_stok_obat']) {
					ob_start(); 
					$this->riwayatObat(); 
					$riwayat_penyesuaian_stok_obat = ob_get_clean();
					$obat->add("riwayat_penyesuaian_stok_obat", "Riwayat Penyesuaian", $riwayat_penyesuaian_stok_obat,Tabulator::$TYPE_HTML, "fa fa-history");
				}
				if ($obat->getTotalElement() > 0 )
					$penyesuaian_stok->add("obat_tabs", "Obat", $obat, Tabulator::$TYPE_COMPONENT, "fa fa-eyedropper");
			}
			
			if ($this->is_use_barang) {
				$barang = new Tabulator("barang", "",Tabulator::$LANDSCAPE);
				if(!isset($this->barang_property['detail_stok_barang']) || $this->barang_property['detail_stok_barang']){
					ob_start(); $this->detailBarang(); $detail_stok_barang=ob_get_clean();
					$barang->add("detail_stok_barang", "Penyesuaian", $detail_stok_barang,Tabulator::$TYPE_HTML,"fa fa-adjust");
				}
				if(!isset($this->barang_property['riwayat_penyesuaian_stok_barang']) || $this->barang_property['riwayat_penyesuaian_stok_barang']){
					ob_start(); $this->riwayatBarang(); $riwayat_penyesuaian_stok_barang=ob_get_clean();
					$barang->add("riwayat_penyesuaian_stok_barang", "Riwayat Penyesuaian", $riwayat_penyesuaian_stok_barang,Tabulator::$TYPE_HTML,"fa fa-history");
				}
				if ($barang->getTotalElement() > 0)
					$penyesuaian_stok->add("barang_tabs", "Barang", $barang, Tabulator::$TYPE_COMPONENT,"fa fa-suitcase");
			}
			echo $penyesuaian_stok->getHtml();
		}
		
		public function detailBarang(){
			require_once 'smis-libs-inventory/modul/PenyesuaianStokBarang.php';
			$df=new PenyesuaianStokBarang($this->db, $this->name, $this->penyesuaian_barang, $this->stok_barang, $this->riwayat_stok_barang, $this->barang_masuk, $this->entity);
			$df->setPrototype($this->proto_name, $this->proto_slug, $this->proto_implement);
			$df->initialize();
		}
		
		public function riwayatBarang(){
			require_once 'smis-libs-inventory/modul/RiwayatPenyesuaianStokBarang.php';
			$df=new RiwayatPenyesuaianStokBarang($this->db, $this->name,$this->penyesuaian_barang, $this->stok_barang, $this->entity);
			$df->setPrototype($this->proto_name, $this->proto_slug, $this->proto_implement);
			$df->initialize();
		}
		
		public function detailObat(){
			require_once 'smis-libs-inventory/modul/PenyesuaianStokObat.php';
			$df=new PenyesuaianStokObat($this->db, $this->name, $this->penyesuaian_obat, $this->stok_obat, $this->riwayat_stok_obat, $this->obat_masuk, $this->kartu_stok_obat, $this->entity);
			$df->setPrototype($this->proto_name, $this->proto_slug, $this->proto_implement);
			$df->initialize();
		}
		
		public function riwayatObat(){
			require_once 'smis-libs-inventory/modul/RiwayatPenyesuaianStokObat.php';
			$df=new RiwayatPenyesuaianStokObat($this->db, $this->name, $this->penyesuaian_obat, $this->stok_obat, $this->entity);
			$df->setPrototype($this->proto_name, $this->proto_slug, $this->proto_implement);
			$df->initialize();
		}
	}
?>