<?php 
	require_once 'smis-framework/smis/template/ModulTemplate.php';
	require_once 'smis-base/smis-include-service-consumer.php';

	class PerubahanEDObat extends ModulTemplate{
		
		private $db;
		private $name;
		private $tbl_obat_masuk;
		private $tbl_stok_obat;
		private $page;
		private $action;
		private $perubahan_ed_obat_table;
		private $perubahan_ed_obat_modal;
		private $proto_name;
		private $proto_implement;
		private $proto_slug;
		
		public function __construct($db, $name_entity, $slug_table_parent, $slug_table_child, $page) {
			$this->db = $db;
			$this->name = $name_entity;
			$this->tbl_obat_masuk = $slug_table_parent;
			$this->tbl_stok_obat = $slug_table_child;
			$this->page = $page;
			$this->perubahan_ed_obat_table = new Table(	
				array("Nomor", "Kode Obat", "Nama Obat", "Jenis Obat", "Jenis Stok", "Sisa","Harga Satuan", "Ket. Jumlah", "Tgl. Exp.", "No. Batch"), 
				$this->name . " : Perubahan Tgl. Exp. Obat"
			);
			$this->perubahan_ed_obat_table->addHeader("before", $this->headerObat());
			$this->perubahan_ed_obat_table->setName("perubahan_ed_obat");
			$this->perubahan_ed_obat_table->setAddButtonEnable(false);
			$this->perubahan_ed_obat_table->setPrintButtonEnable(false);
			$this->perubahan_ed_obat_table->setReloadButtonEnable(false);
			$this->perubahan_ed_obat_table->setDelButtonEnable(false);

			$this->perubahan_ed_obat_modal = new Modal("perubahan_ed_obat_add_form", "smis_form_container", "perubahan_ed_obat");
			$this->perubahan_ed_obat_modal->setTitle("Perubahan ED Obat");
			$id_hidden = new Hidden("perubahan_ed_obat_id", "perubahan_ed_obat_id", "");
			$this->perubahan_ed_obat_modal->addElement("", $id_hidden);
			$kode_obat_text = new Text("perubahan_ed_obat_kode_obat", "perubahan_ed_obat_kode_obat", "");
			$kode_obat_text->setAtribute("disabled='disabled'");
			$this->perubahan_ed_obat_modal->addElement("Kode Obat", $kode_obat_text);
			$nama_obat_text = new Text("perubahan_ed_obat_nama_obat", "perubahan_ed_obat_nama_obat", "");
			$nama_obat_text->setAtribute("disabled='disabled'");
			$this->perubahan_ed_obat_modal->addElement("Nama Obat", $nama_obat_text);
			$nama_jenis_obat_text = new Text("perubahan_ed_obat_nama_jenis_obat", "perubahan_ed_obat_nama_jenis_obat", "");
			$nama_jenis_obat_text->setAtribute("disabled='disabled'");
			$this->perubahan_ed_obat_modal->addElement("Jenis Obat", $nama_jenis_obat_text);
			$sisa_text = new Text("perubahan_ed_obat_sisa", "perubahan_ed_obat_sisa", "");
			$sisa_text->setAtribute("disabled='disabled'");
			$this->perubahan_ed_obat_modal->addElement("Sisa", $sisa_text);
			$tanggal_exp_text = new Text("perubahan_ed_obat_tanggal_exp", "perubahan_ed_obat_tanggal_exp", "");
			$tanggal_exp_text->setClass("mydate");
			$tanggal_exp_text->setAtribute("data-date-format='yyyy-mm-dd'");
			$this->perubahan_ed_obat_modal->addElement("Tgl. Exp.", $tanggal_exp_text);
			$no_batch_text = new Text("perubahan_ed_obat_no_batch", "perubahan_ed_obat_no_batch", "");
			$no_batch_text->setAtribute("disabled='disabled'");
			$this->perubahan_ed_obat_modal->addElement("No. Batch", $no_batch_text);
			$save_button = new Button("", "", "Simpan");
			$save_button->setClass("btn-success");
			$save_button->setAction("perubahan_ed_obat.save()");
			$save_button->setIcon("fa fa-floppy-o");
			$save_button->setIsButton(Button::$ICONIC);
			$this->perubahan_ed_obat_modal->addFooter($save_button);
		}
		
		public function headerObat(){
			$option = new OptionBuilder();
			$option->add("Semua","%%", "1");
			$tahun_rows = $this->db->get_result("
				SELECT 
					DISTINCT YEAR(a.tanggal_exp) tahun
				FROM 
					" . $this->tbl_stok_obat . " a LEFT JOIN " . $this->tbl_obat_masuk . " b ON a.id_obat_masuk = b.id
				WHERE 
					a.prop = '' AND b.prop = '' AND YEAR(a.tanggal_exp) > 0 AND a.sisa > 0 AND b.status = 'sudah'
				ORDER BY
					YEAR(a.tanggal_exp) ASC
			");
			if ($tahun_rows != null) {
				foreach ($tahun_rows as $tr)
					$option->addSingle($tr->tahun);
			}
			$select = new Select("perubahan_ed_obat_tahun", "Tahun", $option->getContent());
			$tr = "<tr><td colspan='11'>" . $select->getHtml() . "</td></tr>";
			return $tr;
		}
		
		public function setPrototype($pname, $pslug, $pimplement) {
			$this->proto_name=$pname;
			$this->proto_implement=$pimplement;
			$this->proto_slug=$pslug;
		}
				
		public function command($command){
			$perubahan_ed_obat_adapter = new SimpleAdapter(true, "Nomor");
			$perubahan_ed_obat_adapter->add("Kode Obat", "kode_obat");
			$perubahan_ed_obat_adapter->add("Nama Obat", "nama_obat");
			$perubahan_ed_obat_adapter->add("Jenis Obat", "nama_jenis_obat");
			$perubahan_ed_obat_adapter->add("Jenis Stok", "label", "unslug");
			$perubahan_ed_obat_adapter->add("Sisa", "sisa","number");
			$perubahan_ed_obat_adapter->add("Harga Satuan", "hna","money");
			$perubahan_ed_obat_adapter->add("Ket. Jumlah", "satuan");
			$perubahan_ed_obat_adapter->add("Tgl. Exp.", "tanggal_exp", "date d-m-Y");
			$perubahan_ed_obat_adapter->add("No. Batch", "no_batch");
			$columns = array("id", "tanggal_exp");
			$perubahan_ed_obat_dbtable = new DBTable(	
				$this->db,
				$this->tbl_stok_obat,
				$columns
			);
			$filter = "";
			if (isset($_POST['filter']))
				$filter .= " AND YEAR(tanggal_exp) LIKE '" . $_POST['filter'] . "' ";
			if (isset($_POST['kriteria']))
				$filter .= " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%') ";
			
			$v_stok="
				SELECT 
					a.*
				FROM 
					" . $this->tbl_stok_obat . " a LEFT JOIN " . $this->tbl_obat_masuk . " b ON a.id_obat_masuk = b.id
				WHERE 
					a.prop = '' AND b.prop = '' AND b.status = 'sudah' AND a.sisa > 0 " . $filter . "
			";
			$query_value = "
				SELECT *
				FROM (
					" . $v_stok . "
				) v
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					" . $v_stok . "
				) v
			";			
			$perubahan_ed_obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
			$perubahan_ed_obat_dbresponder = new DBResponder(
				$perubahan_ed_obat_dbtable,
				$this->perubahan_ed_obat_table,
				$perubahan_ed_obat_adapter
			);
			$data = $perubahan_ed_obat_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		
		public function phpPreLoad() {
			echo $this->perubahan_ed_obat_modal->getHtml();
			echo $this->perubahan_ed_obat_table->getHtml();
			echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
			echo addCSS("framework/bootstrap/css/datepicker.css");	
			echo addJS("framework/smis/js/table_action.js");
		}
		
		public function jsPreLoad(){
			?>		
			<script type="text/javascript">
				var PERUBAHAN_ED_OBAT_PNAME = "<?php echo $this->proto_name; ?>";
				var PERUBAHAN_ED_OBAT_PSLUG = "<?php echo $this->proto_slug; ?>";
				var PERUBAHAN_ED_OBAT_PIMPL = "<?php echo $this->proto_implement; ?>";
				var PERUBAHAN_ED_OBAT_ENTITY = "<?php echo $this->page; ?>";
				var perubahan_ed_obat;
				$(document).ready(function() {
					$('[data-toggle="popover"]').popover({
						trigger: 'hover',
						'placement': 'top'
					});
					$(".mydate").datepicker();
					var perubahan_ed_obat_columns = new Array("id", "id_obat", "kode_obat", "nama_obat", "nama_jenis_obat", "sisa", "no_batch", "tanggal_exp");
					perubahan_ed_obat = new TableAction(
						"perubahan_ed_obat",
						PERUBAHAN_ED_OBAT_ENTITY,
						"perubahan_ed_obat",
						perubahan_ed_obat_columns
					);
					perubahan_ed_obat.setPrototipe(
						PERUBAHAN_ED_OBAT_PNAME,
						PERUBAHAN_ED_OBAT_PSLUG,
						PERUBAHAN_ED_OBAT_PIMPL
					);
					perubahan_ed_obat.addViewData = function(view_data) {
						view_data['filter'] = $("#perubahan_ed_obat_tahun").val();
						return view_data;
					};
					perubahan_ed_obat.view();
					$("#perubahan_ed_obat_tahun").on("change", function() {
						perubahan_ed_obat.view();
					});
				});
			</script>
			<?php 
		}	
	}
?>