<?php
	require_once("smis-base/smis-include-service-consumer.php");

	class LaporanPenyesuaianStokObat extends ModulTemplate {		
		private $db;
		private $name;
		private $tbl_stok_obat;
		private $tbl_penyesuaian_stok_obat;
		private $page;
		private $action;
		private $pso_table;
		private $pso_form;
		private $proto_name;
		private $proto_implement;
		private $proto_slug;
		
		public function __construct($db, $name_entity, $tbl_stok_obat, $tbl_penyesuaian_stok_obat, $page){
			$this->db = $db;
			$this->name = $name_entity;
			$this->tbl_stok_obat = $tbl_stok_obat;
			$this->tbl_penyesuaian_stok_obat = $tbl_penyesuaian_stok_obat;
			$this->page = $page;

			$this->initializeForm();
			$this->initailizeTable();
		}
		
		protected function initializeForm() {
			$this->pso_form = new Form("", "", $this->name . " : Stok Opname");
			$tanggal_from_text = new Text("laporan_pso_tanggal_from", "laporan_pso_tanggal_from", date("Y-m-") . "01");
			$tanggal_from_text->setClass("mydate");
			$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
			$this->pso_form->addElement("Waktu Awal", $tanggal_from_text);
			$tanggal_to_text = new Text("laporan_pso_tanggal_to", "laporan_pso_tanggal_to", date("Y-m-d"));
			$tanggal_to_text->setClass("mydate");
			$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
			$this->pso_form->addElement("Waktu Akhir", $tanggal_to_text);
			$show_button = new Button("", "", "Tampilkan");
			$show_button->setClass("btn-primary");
			$show_button->setIcon("icon-white icon-repeat");
			$show_button->setIsButton(Button::$ICONIC);
			$show_button->setAction("laporan_pso.view()");
			$pdf_button = new Button("", "", "Unduh");
			$pdf_button->setClass("btn-inverse");
			$pdf_button->setIcon("fa fa-download");
			$pdf_button->setIsButton(Button::$ICONIC);
			$pdf_button->setAction("laporan_pso.export_pdf()");
			$btn_group = new ButtonGroup("noprint");
			$btn_group->addButton($show_button);
			$btn_group->addButton($pdf_button);
			$this->pso_form->addElement("", $btn_group);
		}

		protected function initailizeTable() {
			$this->pso_table = new Table(
				array("No.", "Tanggal", "Nama Obat", "Satuan", "Jumlah Sistem", "Jumlah Fisik", "Selisih", "Keterangan"), ""
			);
			$this->pso_table->setName("laporan_pso");
			$this->pso_table->setAction(false);
			$this->pso_table->setFooterVisible(false);
		}

		public function setPrototype($pname,$pslug,$pimplement){
			$this->proto_name = $pname;
			$this->proto_implement = $pimplement;
			$this->proto_slug = $pslug;
		}

		public function command($command){
			if ($_POST['command'] == "export_pdf") {
				$nama_entitas = getSettings($this->db, "smis_autonomous_title", "");
				$alamat_entitas = getSettings($this->db, "smis_autonomous_address", "");
				$tanggal_from = $_POST['tanggal_from'];
				$tanggal_to = $_POST['tanggal_to'];

				$margin_left = 5;
				$margin_top = 5;
				$total = 0;
				$data = $this->db->get_result("
					SELECT a.tanggal, b.nama_obat, b.satuan, a.jumlah_lama AS 'jumlah_sistem', a.jumlah_baru AS 'jumlah_fisik', jumlah_lama - jumlah_baru AS 'selisih', keterangan
					FROM " . $this->tbl_penyesuaian_stok_obat . " a LEFT JOIN " . $this->tbl_stok_obat . " b ON a.id_stok_obat = b.id
					WHERE a.prop = '' AND a.tanggal >= '" . $_POST['tanggal_from'] . "' AND a.tanggal <= '" . $_POST['tanggal_to'] . "'
				");
				$jumlah_item = count($data);
				$jumlah_item_per_halaman = 48;
				$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;

				require_once("smis-libs-out/fpdf/fpdf.php");
				$fpdf = new FPDF("P", "mm", "A4");
				$fpdf->SetFont("Arial", "B", 8);
				$fpdf->SetMargins($margin_left, $margin_top);

				$fpdf->SetFont("Arial", "", 8);
				if ($data != null) {
				 	for ($i = $i_halaman * $jumlah_item_per_halaman; $i < $jumlah_item; $i++) {
				 		if ($i % $jumlah_item_per_halaman == 0) {
				 			$fpdf->AddPage();
							$fpdf->SetY($last_y + 10);
							$fpdf->SetX(5);
							$fpdf->Ln(4);
							$fpdf->SetFont("Arial", "B", 9);
							$fpdf->Cell(200, 5, "LAPORAN PENYESUAIAN STOK OBAT", 0, 0, "C");
							$fpdf->Ln(5);
							$fpdf->SetFont("Arial", "B", 7);
							$fpdf->Cell(200, 5, ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s/d " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " | UNIT : " . strtoupper($this->name), 0, 0, "C");
							$fpdf->Ln(7);
							$fpdf->SetFont("Arial", "B", 8);
							$fpdf->Cell(15, 5, "No.", 1, 0, "C");
							$fpdf->Cell(20, 5, "Tanggal", 1, 0, "C");
							$fpdf->Cell(40, 5, "Nama Obat", 1, 0, "C");
							$fpdf->Cell(15, 5, "Satuan", 1, 0, "C");
							$fpdf->Cell(25, 5, "Jumlah Sistem", 1, 0, "C");
							$fpdf->Cell(20, 5, "Jumlah Fisik", 1, 0, "C");
							$fpdf->Cell(20, 5, "Selisih", 1, 0, "C");
							$fpdf->Cell(45, 5, "Keterangan", 1, 0, "C");
							$fpdf->Ln(5);
				 		}
				 		$nomor = $i + 1;
				 		$tanggal = ArrayAdapter::format("date d-m-Y", $data[$i]->tanggal);
				 		$nama_obat = $data[$i]->nama_obat;
				 		$satuan = $data[$i]->satuan;
				 		$jumlah_sistem = $data[$i]->jumlah_sistem;
				 		$jumlah_fisik = $data[$i]->jumlah_fisik;
				 		$selisih = $data[$i]->selisih;
				 		$keterangan = $data[$i]->keterangan;

						$fpdf->SetFont("Arial", "", 8);
						$fpdf->SetX(5);
						$fpdf->Cell(15, 5, $nomor, 1, 0);
						$fpdf->Cell(20, 5, $tanggal, 1, 0);
						$fpdf->Cell(40, 5, substr($nama_obat, 0, 22), 1, 0);
						$fpdf->Cell(15, 5, $satuan, 1, 0);
						$fpdf->Cell(25, 5, $jumlah_sistem, 1, 0, "R");
						$fpdf->Cell(20, 5, $jumlah_fisik, 1, 0, "R");
						$fpdf->Cell(20, 5, $selisih, 1, 0, "R");
						$fpdf->Cell(45, 5, substr($keterangan, 0, 22), 1, 0);
						$fpdf->Ln(5);
				 		if ($i == ($i_halaman * $jumlah_item_per_halaman + $jumlah_item_per_halaman - 1) || $i == $jumlah_item - 1) {
			 				$fpdf->SetX(5);
							$fpdf->SetFont("Arial", "B", 8);
							$fpdf->Cell(200, 5, "Halaman " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0, "R");
							$fpdf->Ln(5);
							$i_halaman++;
				 		}
				 	}
			 	}
				global $user;
			    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
				$filename = "laporan_penyesuaian_stok_obat.pdf";
				$pathfile = "smis-temp/" . $md5 . $filename;
				$fpdf->Output($pathfile, "F");
				$pack = new ResponsePackage();
				$pack->setContent($pathfile);
				$pack->setStatus(ResponsePackage::$STATUS_OK);
				echo json_encode($pack->getPackage());
				return;
			}
			$adapter = new SimpleAdapter(true, "No.");
			$adapter->add("Tanggal", "tanggal", "date d-m-Y");
			$adapter->add("Nama Obat", "nama_obat");
			$adapter->add("Satuan", "satuan");
			$adapter->add("Jumlah Sistem", "jumlah_sistem", "number");
			$adapter->add("Jumlah Fisik", "jumlah_fisik", "number");
			$adapter->add("Selisih", "selisih", "number");
			$adapter->add("Keterangan", "keterangan");
			$dbtable = new DBTable($this->db, $this->tbl_penyesuaian_stok_obat, $columns);
			$dbtable->setShowAll(true);
			$filter = "";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (b.nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR a.keterangan LIKE '%" . $_POST['kriteria'] . "%' ) ";
			}
			$query_value = "
				SELECT a.tanggal, b.nama_obat, b.satuan, a.jumlah_lama AS 'jumlah_sistem', a.jumlah_baru AS 'jumlah_fisik', jumlah_lama - jumlah_baru AS 'selisih', keterangan
				FROM " . $this->tbl_penyesuaian_stok_obat . " a LEFT JOIN " . $this->tbl_stok_obat . " b ON a.id_stok_obat = b.id
				WHERE a.prop = '' AND a.tanggal >= '" . $_POST['tanggal_from'] . "' AND a.tanggal <= '" . $_POST['tanggal_to'] . "' " . $filter . "
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					" . $query_value . "
				) v
			";
			$dbtable->setPreferredQuery(true, $query_value, $query_count);
			$dbresponder = new DBResponder(
				$dbtable,
				$this->pso_table,
				$adapter
			);
			$data = $dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		
		public function phpPreLoad(){
			echo $this->pso_form->getHtml();
			echo $this->pso_table->getHtml();
			echo addJS("framework/smis/js/table_action.js");
			echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
			echo addCSS("framework/bootstrap/css/datepicker.css");
		}
		
		public function jsPreLoad(){
			?>
			<script type="text/javascript">				
				var laporan_pso;
				var LAPORAN_PSO_PNAME="<?php echo $this->proto_name; ?>";
				var LAPORAN_PSO_PSLUG="<?php echo $this->proto_slug; ?>";
				var LAPORAN_PSO_PIMPL="<?php echo $this->proto_implement; ?>";
				var LAPORAN_PSO_ENTITY="<?php echo $this->page; ?>";
				$(document).ready(function() {
					$('[data-toggle="popover"]').popover({
						trigger: 'hover',
						'placement': 'top'
					});
					laporan_pso = new TableAction(
						"laporan_pso",
						LAPORAN_PSO_ENTITY,
						"laporan_penyesuaian_stok_obat",
						new Array()
					);
					laporan_pso.setPrototipe(LAPORAN_PSO_PNAME, LAPORAN_PSO_PSLUG, LAPORAN_PSO_PIMPL);
					laporan_pso.addViewData = function(data) {
						data['tanggal_from'] = $("#laporan_pso_tanggal_from").val();
						data['tanggal_to'] = $("#laporan_pso_tanggal_to").val();
						return data;
					};
					laporan_pso.export_pdf = function() {
						var data = this.getRegulerData();
						data['command'] = "export_pdf";
						data['tanggal_from'] = $("#laporan_pso_tanggal_from").val();
						data['tanggal_to'] = $("#laporan_pso_tanggal_to").val();
						$.post(
							"",
							data,
							function(response) {
								var json = getContent(response);
								if (json == null) {
									dismissLoading();
									return;
								}
								var getUrl = window.location['pathname'] + json;
					            window.open(getUrl, 'pdf');
					            dismissLoading();
							}
						);	
					};
					$("tbody#laporan_pso_list").append(
						"<tr>" +
							"<td colspan='8'><strong><center><small>DATA BELUM DIPROSES</small></center></strong></td>" +
						"</tr>"
					);
				});
			</script>		
			<?php 
		}	
	}
?>