<?php 
	require_once 'smis-framework/smis/template/ModulTemplate.php';
	require_once 'smis-base/smis-include-service-consumer.php';

	class InventarisRetur extends ModulTemplate{
		
		private $db;
		private $name;
		private $tbl_inventaris;
		private $page;
		private $action;
		private $inventaris_retur_table;
		private $proto_name;
		private $proto_implement;
		private $proto_slug;
		
		public function __construct($db, $name_entity, $slug_table_parent, $page){
			$this->db=$db;
			$this->name=$name_entity;
			$this->tbl_inventaris=$slug_table_parent;
			$this->page=$page;
			$header=array("Nomor", "Kode", "Jenis", "Barang", "Merk", "Harga", "Tahun", "Penyusutan", "Kondisi", "Status");
			$this->inventaris_retur_table = new Table($header, $this->name . " : Retur Inventaris");
			$this->inventaris_retur_table->setName("inventaris_retur");
			$this->inventaris_retur_table->setReloadButtonEnable(false);
			$this->inventaris_retur_table->setPrintButtonEnable(false);
			$this->inventaris_retur_table->setEditButtonEnable(false);
			$this->inventaris_retur_table->setDelButtonEnable(false);
			$btn = new Button("", "", "Lihat");
			$btn->setClass("btn-inverse");
			$btn->setAtribute("data-content='Terima' data-toggle='popover'");
			$btn->setIcon("icon-eye-open icon-white");
			$btn->setIsButton(Button::$ICONIC);
			$this->inventaris_retur_table->addContentButton("detail", $btn);
			$this->proto_name="";
			$this->proto_implement="";
			$this->proto_slug="";
		}
		
		public function setPrototype($pname,$pslug,$pimplement){
			$this->proto_name=$pname;
			$this->proto_implement=$pimplement;
			$this->proto_slug=$pslug;
		}
		
		public function command($command){
			$inventaris_retur_adapter=new SimpleAdapter();
			$inventaris_retur_adapter->add("id", "id");
			$inventaris_retur_adapter->add("Nomor", "f_id","digit8");
			$inventaris_retur_adapter->add("Kode", "kode");
			$inventaris_retur_adapter->add("Jenis", "medis","trivial_1_Medis_Non-Medis");
			$inventaris_retur_adapter->add("Barang", "nama_barang");
			$inventaris_retur_adapter->add("Merk", "merk");
			$inventaris_retur_adapter->add("Harga", "hna","money Rp.");
			$inventaris_retur_adapter->add("Tahun", "tahun_perolehan", "date d-m-Y");
			$inventaris_retur_adapter->add("Penyusutan", "usia_penyusutan", "back Tahun");
			$inventaris_retur_adapter->add("Kondisi", "kondisi_baik","trivial_1_Baik_Rusak");
			$inventaris_retur_adapter->add("Status", "status", "trivial_sudah_SUDAH DITERIMA_BELUM DITERIMA");
			$inventaris_retur_dbtable = new DBTable($this->db,$this->tbl_inventaris);
			$inventaris_retur_dbtable->addCustomKriteria(" tipe ", " = 'retur' ");
			$inventaris_retur_dbresponder = new DBResponder($inventaris_retur_dbtable,$this->inventaris_retur_table,$inventaris_retur_adapter);
			if ($inventaris_retur_dbresponder->isSave() && $_POST['id'] != "") {
				$_POST['tipe'] = "retur";
				$_POST['status'] = "belum";
				global $user;
				$_POST['user_retur'] = $user->getNameOnly();
			}
			$data = $inventaris_retur_dbresponder->command($_POST['command']);
			
			if ($inventaris_retur_dbresponder->isSave() && $_POST['id'] != "") {
				$id['id'] = $_POST['id'];
				$inventaris_row = $inventaris_retur_dbtable->get_row("
					SELECT
						*
					FROM
						" . $this->tbl_inventaris . "
					WHERE
						id = '" . $id['id'] . "'
				");
				$array = array();
				$array['id'] = $inventaris_row->f_id;
				$array['tipe'] = $inventaris_row->tipe;
				$array['status'] = $inventaris_row->status;
				$array['user_retur'] = $inventaris_row->user_retur;
				$array['tanggal_retur'] = $inventaris_row->tanggal_retur;
				$array['kondisi_baik'] = $inventaris_row->kondisi_baik;
				$array['keterangan_retur'] = $inventaris_row->keterangan_retur;
				$array['prop'] = $inventaris_row->prop;
				$return_inventaris_service_consumer = new ServiceConsumer($this->db, "set_inventaris_retur_status",$array,"gudang_umum");
				$return_inventaris_service_consumer->execute();
			}

			echo json_encode($data);
			return;
		}
		
		public function phpPreLoad(){
			$inventaris_retur_modal = new Modal("inventaris_retur_add_form", "smis_form_container", "inventaris_retur");
			$inventaris_retur_modal->setTitle("Retur Barang Inventaris");
			$id_hidden = new Hidden("inventaris_retur_id", "inventaris_retur_id", "");
			$inventaris_retur_modal->addElement("", $id_hidden);
			$nama_barang_text = new Text("inventaris_retur_nama_barang", "inventaris_retur_nama_barang", "");
			$nama_barang_text->setAtribute("disabled='disabled'");
			$nama_barang_text->setClass("smis-one-option-input");
			$inventaris_barang_button = new Button("", "", "Pilih");
			$inventaris_barang_button->setClass("btn-info");
			$inventaris_barang_button->setIsButton(Button::$ICONIC);
			$inventaris_barang_button->setIcon("icon-white ".Button::$icon_list_alt);
			$inventaris_barang_button->setAction("inventaris_retur_barang.chooser('inventaris_retur_barang', 'inventaris_barang_button', 'inventaris_retur_barang', inventaris_retur_barang, 'Barang Inventaris')");
			$inventaris_barang_button->setAtribute("id='inventaris_retur_barang_browse'");
			$inventaris_barang_input_group = new InputGroup("");
			$inventaris_barang_input_group->addComponent($nama_barang_text);
			$inventaris_barang_input_group->addComponent($inventaris_barang_button);
			$inventaris_retur_modal->addElement("Nama Barang", $inventaris_barang_input_group);
			$tanggal_text = new Text("inventaris_retur_tanggal_retur", "inventaris_retur_tanggal_retur", date("d-m-Y H:i"));
			$tanggal_text->setClass("mydatetime");
			$tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");
			$inventaris_retur_modal->addElement("Tanggal", $tanggal_text);
			$kode_text = new Text("inventaris_retur_kode", "inventaris_retur_kode", "");
			$kode_text->setAtribute("disabled='disabled'");
			$inventaris_retur_modal->addElement("Kode", $kode_text);
			$medis_option = new OptionBuilder();
			$medis_option->add("Medis", "1");
			$medis_option->add("Non-Medis", "0");
			$medis_select = new Select("inventaris_retur_medis", "inventaris_retur_medis", $medis_option->getContent());
			$medis_select->setAtribute("disabled='disabled'");
			$inventaris_retur_modal->addElement("Jenis", $medis_select);
			$merk_text = new Text("inventaris_retur_merk", "inventaris_retur_merk", "");
			$merk_text->setAtribute("disabled='disabled'");
			$inventaris_retur_modal->addElement("Merk", $merk_text);
			$keterangan_textarea = new TextArea("inventaris_retur_keterangan_retur", "inventaris_retur_keterangan_retur", "");
			$keterangan_textarea->setLine(2);
			$inventaris_retur_modal->addElement("Keterangan", $keterangan_textarea);
			$kondisi_option = array(
				array(
					'name'	=> "Baik",
					'value'	=> 1
				),
				array(
					'name'	=> "Rusak",
					'value'	=> 0
				)
			);
			$kondisi_select = new Select("inventaris_retur_kondisi_baik", "inventaris_retur_kondisi_baik", $kondisi_option);
			$inventaris_retur_modal->addElement("Kondisi", $kondisi_select);
			$save_barang_button = new Button("", "", "Simpan");
			$save_barang_button->setAction("inventaris_retur.save()");
			$save_barang_button->setAtribute("id='inventaris_retur_save_btn'");
			$save_barang_button->setClass("btn-success");
			$save_barang_button->setIcon("fa fa-floppy-o");
			$save_barang_button->setIsButton(Button::$ICONIC);
			$inventaris_retur_modal->addFooter($save_barang_button);
			$ok_barang_button = new Button("", "", "OK");
			$ok_barang_button->setAction("$($(this).data('target')).smodal('hide')");
			$ok_barang_button->setAtribute("id='inventaris_retur_ok_btn'");
			$ok_barang_button->setClass("btn-inverse");
			$inventaris_retur_modal->addFooter($ok_barang_button);

			echo $inventaris_retur_modal->getHtml();
			echo $this->inventaris_retur_table->getHtml();
			echo addJS("framework/smis/js/table_action.js");
		}
		
		public function jsPreLoad(){
			?>				
			<script type="text/javascript">
				function IBarangAction(name, page, action, column) {
					this.initialize(name, page, action, column);
				}
				IBarangAction.prototype.constructor = IBarangAction;
				IBarangAction.prototype = new TableAction();
				IBarangAction.prototype.selected = function(json) {
					$("#inventaris_retur_id").val(json.id);
					$("#inventaris_retur_nama_barang").val(json.nama_barang);
					$("#inventaris_retur_kode").val(json.kode);
					$("#inventaris_retur_merk").val(json.merk);
					$("#inventaris_retur_medis").val(json.medis);
					$("#inventaris_retur_kondisi_baik").val(json.kondisi_baik);
				};				

				var INVENTARIS_RETUR_PNAME="<?php echo $this->proto_name; ?>";
				var INVENTARIS_RETUR_PSLUG="<?php echo $this->proto_slug; ?>";
				var INVENTARIS_RETUR_PIMPL="<?php echo $this->proto_implement; ?>";
				var INVENTARIS_RETUR_ENTITY="<?php echo $this->page; ?>";
				var inventaris_retur;
				var inventaris_retur_barang;
				$(document).ready(function() {
					$('[data-toggle="popover"]').popover({
						trigger: 'hover',
						'placement': 'top'
					});
					inventaris_retur_barang = new IBarangAction(
						"inventaris_retur_barang",
						INVENTARIS_RETUR_ENTITY,
						"inventaris_retur",
						new Array()
					);
					inventaris_retur_barang.setSuperCommand("inventaris_retur_barang");
					inventaris_retur_barang.setPrototipe(INVENTARIS_RETUR_PNAME,INVENTARIS_RETUR_PSLUG,INVENTARIS_RETUR_PIMPL);
					var inventaris_retur_columns = new Array("id", "nama_barang", "medis", "kode", "merk", "kondisi_baik", "tanggal_retur", "keterangan_retur");
					inventaris_retur = new TableAction("inventaris_retur",INVENTARIS_RETUR_ENTITY,"inventaris_retur",inventaris_retur_columns);
					inventaris_retur.setPrototipe(INVENTARIS_RETUR_PNAME,INVENTARIS_RETUR_PSLUG,INVENTARIS_RETUR_PIMPL);
					inventaris_retur.validate = function() {
						var valid = true;
						var invalid_msg = "";
						var tanggal_retur = $("#inventaris_retur_tanggal_retur").val();
						var id = $("#inventaris_retur_id").val();
						var keterangan = $("#inventaris_retur_keterangan_retur").val();
						$(".error_field").removeClass("error_field");
						if (id == "") {
							valid = false;
							invalid_msg += "<br/><strong>Barang Inventaris</strong> tidak boleh kosong";
							$("#inventaris_retur_nama_barang").addClass("error_field");
						}
						if (tanggal_retur == "") {
							valid = false;
							invalid_msg += "<br/><strong>Tanggal</strong> tidak boleh kosong";
							$("#inventaris_retur_tanggal_retur").addClass("error_field");
						}
						if (keterangan == "") {
							valid = false;
							invalid_msg += "<br/><strong>Keterangan</strong> tidak boleh kosong";
							$("#inventaris_retur_keterangan_retur").addClass("error_field");
						}
						if (!valid) {
							$("#modal_alert_inventaris_retur_add_form").html(
								"<div class='alert alert-block alert-danger'>" +
									"<h4>Peringatan</h4>" +
									invalid_msg +
								"</div>"
							);
						}
						return valid;
					};
					inventaris_retur.show_add_form = function() {
						$("#inventaris_retur_barang_browse").show();
						$("#inventaris_retur_nama_barang").removeClass("smis-one-option-input");
						$("#inventaris_retur_nama_barang").addClass("smis-one-option-input");
						$("#inventaris_retur_tanggal_retur").removeAttr("disabled");
						$("#inventaris_retur_keterangan_retur").removeAttr("disabled");
						$("#inventaris_retur_kondisi_baik").removeAttr("disabled");
						$("#inventaris_retur_save_btn").show();
						$("#inventaris_retur_ok_btn").hide();
						TableAction.prototype.show_add_form.call(this);
					};
					inventaris_retur.save = function() {
						if (!this.validate())
							return;
						var self = this;
						var data = self.getRegulerData();
						data['command'] = "save";
						data['id'] = $("#inventaris_retur_id").val();
						data['tanggal_retur'] = $("#inventaris_retur_tanggal_retur").val();
						data['keterangan_retur'] = $("#inventaris_retur_keterangan_retur").val();
						data['kondisi_baik'] = $("#inventaris_retur_kondisi_baik").val();
						showLoading();
						$.post(
							"",
							data,
							function(response) {
								var json = getContent(response);
								if (json == null) {
									$("#inventaris_retur_add_form").smodal("show");
									dismissLoading();
									return;
								}
								$("#inventaris_retur_add_form").smodal("hide");
								self.view();
								dismissLoading();
							}
						);
					};
					inventaris_retur.detail = function(id) {
						$("#inventaris_retur_barang_browse").hide();
						$("#inventaris_retur_nama_barang").removeClass("smis-one-option-input");
						$("#inventaris_retur_tanggal_retur").removeAttr("disabled");
						$("#inventaris_retur_tanggal_retur").attr("disabled", "disabled");
						$("#inventaris_retur_keterangan_retur").removeAttr("disabled");
						$("#inventaris_retur_keterangan_retur").attr("disabled", "disabled");
						$("#inventaris_retur_kondisi_baik").removeAttr("disabled");
						$("#inventaris_retur_kondisi_baik").attr("disabled", "disabled");
						$("#inventaris_retur_save_btn").hide();
						$("#inventaris_retur_ok_btn").show();
						TableAction.prototype.edit.call(this, id);
					};
					inventaris_retur.view();
				});
			</script>
			<?php 
		}	

		public function superCommand($super_command){
			$header=array("No.", "ID", "Barang", "Kode", "Jenis", "Merk", "Kondisi");
			$inventaris_retur_barang_table = new Table($header);
			$inventaris_retur_barang_table->setName("inventaris_retur_barang");
			$inventaris_retur_barang_table->setModel(Table::$SELECT);
			$inventaris_retur_barang_adapter = new SimpleAdapter(true, "No.");
			$inventaris_retur_barang_adapter->add("ID", "id");
			$inventaris_retur_barang_adapter->add("Barang", "nama_barang");
			$inventaris_retur_barang_adapter->add("Kode", "kode");
			$inventaris_retur_barang_adapter->add("Jenis", "medis", "trivial_1_Medis_Non-Medis");
			$inventaris_retur_barang_adapter->add("Merk", "merk");
			$inventaris_retur_barang_adapter->add("Kondisi", "kondisi_baik", "trivial_1_Baik_Rusak");
			$inventaris_retur_dbtable = new DBTable($this->db, $this->tbl_inventaris);
			$inventaris_retur_dbtable->addCustomKriteria(" tipe ", " = '' ");
			$inventaris_retur_barang_dbresponder = new DBResponder($inventaris_retur_dbtable, $inventaris_retur_barang_table, $inventaris_retur_barang_adapter);
			$super_command = new SuperCommand();
			$super_command->addResponder("inventaris_retur_barang", $inventaris_retur_barang_dbresponder);
			$init = $super_command->initialize();
			if ($init != null) {
				echo $init;
				return;
			}
		}
	}
?>