<?php 
	require_once 'smis-framework/smis/template/ModulTemplate.php';
	require_once 'smis-base/smis-include-service-consumer.php';

	class InventarisMasuk extends ModulTemplate{
		
		private $db;
		private $name;
		private $tbl_inventaris;
		private $page;
		private $action;
		private $inventaris_masuk_table;
		private $proto_name;
		private $proto_implement;
		private $proto_slug;
		
		public function __construct($db, $name_entity, $slug_table_parent, $page){
			$this->db=$db;
			$this->name=$name_entity;
			$this->tbl_inventaris=$slug_table_parent;
			$this->page=$page;
			$header=array("Nomor", "Kode", "Jenis", "Barang", "Merk", "Harga", "Tahun", "Penyusutan", "Kondisi");
			$this->inventaris_masuk_table = new Table($header, $this->name . " : Inventaris Masuk");
			$this->inventaris_masuk_table->setName("inventaris_masuk");
			$this->inventaris_masuk_table->setReloadButtonEnable(false);
			$this->inventaris_masuk_table->setPrintButtonEnable(false);
			$this->inventaris_masuk_table->setAddButtonEnable(false);
			$this->inventaris_masuk_table->setEditButtonEnable(false);
			$this->inventaris_masuk_table->setDelButtonEnable(false);
			$btn = new Button("", "", "Terima");
			$btn->setClass("btn-success");
			$btn->setAtribute("data-content='Terima' data-toggle='popover'");
			$btn->setIcon("fa fa-check");
			$btn->setIsButton(Button::$ICONIC);
			$this->inventaris_masuk_table->addContentButton("accept", $btn);
			$btn = new Button("", "", "Tolak");
			$btn->setClass("btn-danger");
			$btn->setAtribute("data-content='Tolak' data-toggle='popover'");
			$btn->setIcon("fa fa-times");
			$btn->setIsButton(Button::$ICONIC);
			$this->inventaris_masuk_table->addContentButton("cancel", $btn);
			$this->proto_name="";
			$this->proto_implement="";
			$this->proto_slug="";
		}
		
		public function setPrototype($pname,$pslug,$pimplement){
			$this->proto_name=$pname;
			$this->proto_implement=$pimplement;
			$this->proto_slug=$pslug;
		}
		
		public function command($command){
			$inventaris_masuk_adapter=new SimpleAdapter();
			$inventaris_masuk_adapter->add("id", "id");
			$inventaris_masuk_adapter->add("Nomor", "f_id","digit8");
			$inventaris_masuk_adapter->add("Kode", "kode");
			$inventaris_masuk_adapter->add("Jenis", "medis","trivial_1_Medis_Non-Medis");
			$inventaris_masuk_adapter->add("Barang", "nama_barang");
			$inventaris_masuk_adapter->add("Merk", "merk");
			$inventaris_masuk_adapter->add("Harga", "hna","money Rp.");
			$inventaris_masuk_adapter->add("Tahun", "tahun_perolehan", "date d-m-Y");
			$inventaris_masuk_adapter->add("Penyusutan", "usia_penyusutan", "back Tahun");
			$inventaris_masuk_adapter->add("Kondisi", "kondisi_baik","trivial_1_Baik_Rusak");
			$inventaris_masuk_dbtable = new DBTable($this->db,$this->tbl_inventaris);
			$inventaris_masuk_dbtable->addCustomKriteria(" tipe ", " = 'mutasi' ");
			$inventaris_masuk_dbtable->addCustomKriteria(" status ", " = 'belum' ");
			$inventaris_masuk_dbresponder = new DBResponder($inventaris_masuk_dbtable,$this->inventaris_masuk_table,$inventaris_masuk_adapter);
			if ($inventaris_masuk_dbresponder->isSave() && $_POST['id'] != "" && isset($_POST['status'])) {
				if ($_POST['status'] == "sudah") {
					$_POST['tipe'] = "";
					global $user;
					$_POST['user_acc_mutasi'] = $user->getNameOnly();
					$_POST['tanggal_acc_mutasi'] = date("Y-m-d H:i:s");
				}
			}
			$data = $inventaris_masuk_dbresponder->command($_POST['command']);
			
			if (($inventaris_masuk_dbresponder->isSave() || $_POST['command'] == "del") && $_POST['id'] != "") {
				$id['id'] = $_POST['id'];
				$inventaris_row = $inventaris_masuk_dbtable->get_row("
					SELECT
						*
					FROM
						" . $this->tbl_inventaris . "
					WHERE
						id = '" . $id['id'] . "'
				");
				$array = array();
				$array['id'] = $inventaris_row->f_id;
				$array['tipe'] = $inventaris_row->tipe;
				$array['status'] = $inventaris_row->status;
				$array['user_acc_mutasi'] = $inventaris_row->user_acc_mutasi;
				$array['tanggal_acc_mutasi'] = $inventaris_row->tanggal_acc_mutasi;
				$array['prop'] = $inventaris_row->prop;
				$return_inventaris_service_consumer = new ServiceConsumer($this->db, "set_inventaris_mutasi_status",$array,"gudang_umum");
				$return_inventaris_service_consumer->execute();
			}

			echo json_encode($data);
			return;
		}
		
		public function phpPreLoad(){
			echo $this->inventaris_masuk_table->getHtml();
			echo addJS("framework/smis/js/table_action.js");
		}
		
		public function jsPreLoad(){
			?>				
			<script type="text/javascript">
				var INVENTARIS_MASUK_PNAME="<?php echo $this->proto_name; ?>";
				var INVENTARIS_MASUK_PSLUG="<?php echo $this->proto_slug; ?>";
				var INVENTARIS_MASUK_PIMPL="<?php echo $this->proto_implement; ?>";
				var INVENTARIS_MASUK_ENTITY="<?php echo $this->page; ?>";
				var inventaris_masuk;
				$(document).ready(function() {
					$('[data-toggle="popover"]').popover({
						trigger: 'hover',
						'placement': 'top'
					});
					var inventaris_masuk_columns = new Array("id", "f_id", "nama_barang", "medis", "kode", "merk", "hna", "tahun_perolehan", "usia_penyusutan", "kondisi_baik", "tipe");
					inventaris_masuk = new TableAction("inventaris_masuk",INVENTARIS_MASUK_ENTITY,"inventaris_masuk",inventaris_masuk_columns);
					inventaris_masuk.setPrototipe(INVENTARIS_MASUK_PNAME,INVENTARIS_MASUK_PSLUG,INVENTARIS_MASUK_PIMPL);
					inventaris_masuk.accept = function(id) {
						var self = this;
						bootbox.confirm(
							"Yakin menerima Inventaris ini?",
							function(result) {
								if (result) {
									showLoading();
									var data = self.getRegulerData();
									data['command'] = "save";
									data['status'] = "sudah";
									data['id'] = id;
									$.post(
										"",
										data,
										function() {
											self.view();
											dismissLoading();
										}
									);
								}
							}
						);
					};
					inventaris_masuk.cancel = function(id) {
						var self = this;
						bootbox.confirm(
							"Yakin menolak Inventaris ini?",
							function(result) {
								if (result) {
									showLoading();
									var data = self.getRegulerData();
									data['command'] = "del";
									data['id'] = id;
									$.post(
										"",
										data,
										function() {
											self.view();
											dismissLoading();
										}
									);
								}
							}
						);
					};
					inventaris_masuk.view();
				});
			</script>
			<?php 
		}	
	}
?>