<?php 
	require_once 'smis-framework/smis/template/ModulTemplate.php';
	require_once 'smis-base/smis-include-service-consumer.php';

	class DaftarObat extends ModulTemplate{
		
		private $db;
		private $name;
		private $tbl_obat_masuk;
		private $tbl_stok_obat;
		private $page;
		private $action;
		private $daftar_obat_table;
		private $proto_name;
		private $proto_implement;
		private $proto_slug;
		private $header_button;
		
		public function __construct($db, $name_entity, $slug_table_parent, $slug_table_child, $page){
			$this->db=$db;
			$this->name=$name_entity;
			$this->tbl_obat_masuk=$slug_table_parent;
			$this->tbl_stok_obat=$slug_table_child;
			$this->page=$page;
			$this->daftar_obat_table = new Table(	array("Nomor", "Nama Obat", "Jenis Obat", "Stok","Nilai"), $this->name . " : Rekapitulasi Stok Obat");
			$this->daftar_obat_table->addHeader("before", $this->headerObat());
			$this->daftar_obat_table->setName("daftar_obat");
			$this->daftar_obat_table->setAddButtonEnable(false);
			$this->daftar_obat_table->setEditButtonEnable(false);
			$this->daftar_obat_table->setDelButtonEnable(false);
			$export_button = new Button("", "", "Eksport PDF");
			$export_button->setClass("btn-inverse");
			$export_button->setAction("daftar_obat.export_pdf()");
			$export_button->setIcon("fa fa-download");
			$export_button->setIsButton(Button::$ICONIC);
			$this->daftar_obat_table->addHeaderButton($export_button);
		}
		
		public function headerObat(){
			$option=new OptionBuilder();
			$option->add("Semua","all")
				   ->add("Semua, Kecuali Kosong","all_not_empty", "1")
				   ->add("Kosong","empty");
			$select=new Select("filter", "Daftar Obat", $option->getContent());
			$tr="<tr><td colspan='10'>".$select->getHtml()."</td></tr>";
			return $tr;
		}
		
		public function setPrototype($pname,$pslug,$pimplement){
			$this->proto_name=$pname;
			$this->proto_implement=$pimplement;
			$this->proto_slug=$pslug;
		}
		
		
		public function command($command){
			if ($_POST['command'] == "export_pdf") {
				$nama_instansi = "KLINIK CASA MEDICAL PANBIL";
				$alamat_instansi_1 = "Komp. Panbil Komersil Area Blok A";
				$alamat_instansi_2 = "No. 3A Kelurahan Muka Kuning";
				$no_izin_instansi = getSettings($db, "instansi_no_ijin", "");

				$margin_left = 10;
				$margin_top = 10;
				$total = 0;
				$jumlah_item = 0;
				$jumlah_item_per_halaman = 44;

				$row = $this->db->get_row("
					SELECT COUNT(*) AS 'jumlah'
					FROM (
						SELECT  id_obat, 
							    nama_obat, 
								nama_jenis_obat, 
								sum(uang) as uang, 
								GROUP_CONCAT(CONCAT(sisa, ' ', satuan) 
								ORDER BY satuan, sisa ASC SEPARATOR ', ') AS 'stok'
						FROM (
							SELECT id_obat, nama_obat, 
						    		nama_jenis_obat, SUM(sisa) AS 'sisa', 
									sum(hna*sisa) as uang, satuan, 
										konversi, satuan_konversi
							FROM ".$this->tbl_stok_obat." 
								LEFT JOIN ".$this->tbl_obat_masuk." 
									ON ".$this->tbl_stok_obat.".id_obat_masuk = ".$this->tbl_obat_masuk.".id
							WHERE ".$this->tbl_stok_obat.".prop NOT LIKE 'del' 
										AND ".$this->tbl_obat_masuk.".prop NOT LIKE 'del' 
										AND ".$this->tbl_obat_masuk.".status = 'sudah'
							GROUP BY id_obat, satuan, konversi, satuan_konversi
						) v_obat
						GROUP BY id_obat
					) v_stok
				");
				if ($row != null)
					$jumlah_item = $row->jumlah;
				$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;

				require_once("smis-libs-out/fpdf/fpdf.php");
				$fpdf = new FPDF("P", "mm", "A4");
				$fpdf->SetFont("Arial", "B", 8);
				$fpdf->SetMargins($margin_left, $margin_top);

				for ($i_halaman = 0; $i_halaman < $jumlah_halaman; $i_halaman++) {
					$fpdf->AddPage();
					$fpdf->SetY($last_y + 10);
					$fpdf->SetX(10);
					$fpdf->Ln(4);
					$fpdf->SetFont("Arial", "B", 9);
					$fpdf->Cell(180, 5, "DAFTAR OBAT " . strtoupper($this->name), 0, 0, "C");
					$fpdf->Ln(5);
					$fpdf->SetFont("Arial", "B", 8);
					$fpdf->Cell(180, 5, ArrayAdapter::format("date d-m-Y, H:i:s", date("Y-m-d H:i:s")), 0, 0, "C");
					$fpdf->Ln(10);
					$fpdf->SetFont("Arial", "B", 9);
					$fpdf->Cell(22.6, 5, "Nomor", 1, 0, "C");
					$fpdf->Cell(27.6, 5, "Kode Obat", 1, 0, "C");
					$fpdf->Cell(42.6, 5, "Nama Obat", 1, 0, "C");
					$fpdf->Cell(47.6, 5, "Jenis Obat", 1, 0, "C");
					$fpdf->Cell(47.6, 5, "Stok", 1, 0, "C");
					$fpdf->Ln(5);
					$rows = $this->db->get_result("
						SELECT *
						FROM (
							SELECT  id_obat, 
								    nama_obat, 
									nama_jenis_obat, 
									sum(uang) as uang, 
									GROUP_CONCAT(CONCAT(sisa, ' ', satuan) 
									ORDER BY satuan, sisa ASC SEPARATOR ', ') AS 'stok'
							FROM (
								SELECT id_obat, nama_obat, 
										nama_jenis_obat, SUM(sisa) AS 'sisa', 
										sum(hna*sisa) as uang, satuan, 
										konversi, satuan_konversi
								FROM ".$this->tbl_stok_obat." 
								LEFT JOIN ".$this->tbl_obat_masuk." 
									ON ".$this->tbl_stok_obat.".id_obat_masuk = ".$this->tbl_obat_masuk.".id
								WHERE ".$this->tbl_stok_obat.".prop NOT LIKE 'del' 
										AND ".$this->tbl_obat_masuk.".prop NOT LIKE 'del' 
										AND ".$this->tbl_obat_masuk.".status = 'sudah'
								GROUP BY id_obat, satuan, konversi, satuan_konversi
							) v_obat
							GROUP BY id_obat
						) v
						LIMIT " . $i_halaman * $jumlah_item_per_halaman . ", " . $jumlah_item_per_halaman . "
					");

					$fpdf->SetFont("Arial", "", 9);
					if ($rows != null) {
						foreach ($rows as $row) {
							$fpdf->SetX(10);
							$fpdf->Cell(22.6, 5, ArrayAdapter::format("only-digit8", $row->id_obat), 1, 0);
							$fpdf->Cell(27.6, 5, substr($row->kode_obat, 0, 25), 1, 0);
							$fpdf->Cell(42.6, 5, substr($row->nama_obat, 0, 25), 1, 0);
							$fpdf->Cell(47.6, 5, substr($row->nama_jenis_obat, 0, 20), 1, 0);
							$fpdf->Cell(47.6, 5, substr($row->stok, 0, 25), 1, 0);
							$fpdf->Ln(5);
						}
					}
					for ($i = count($rows); $i <= $jumlah_item_per_halaman; $i++) {
						$fpdf->SetX(10);
						$fpdf->Cell(22.6, 5, "", 1, 0);
						$fpdf->Cell(27.6, 5, "", 1, 0);
						$fpdf->Cell(42.6, 5, "", 1, 0);
						$fpdf->Cell(47.6, 5, "", 1, 0);
						$fpdf->Cell(47.6, 5, "", 1, 0);
						$fpdf->Ln(5);
					}
					$fpdf->SetX(10);
					$fpdf->SetFont("Arial", "B", 8);
					$fpdf->Cell(180, 5, "Halaman " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0, "R");
					$fpdf->Ln(5);
				}

				global $user;
			    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
				$filename = "daftar_obat.pdf";
				$pathfile = "smis-temp/" . $md5 . $filename;
				$fpdf->Output($pathfile, "F");
				$pack = new ResponsePackage();
				$pack->setContent($pathfile);
				$pack->setStatus(ResponsePackage::$STATUS_OK);
				echo json_encode($pack->getPackage());
				return;
			}
			$daftar_obat_adapter =new SummaryAdapter();
			$daftar_obat_adapter->addFixValue("Stok", "<strong>Total</strong>");
			$daftar_obat_adapter->addSummary("Nilai", "uang","money Rp.");
			$daftar_obat_adapter->setUseID(false);
			$daftar_obat_adapter->add("id", "id_obat");
			$daftar_obat_adapter->add("Nomor", "id_obat","digit8");
			$daftar_obat_adapter->add("Nama Obat", "nama_obat");
			$daftar_obat_adapter->add("Jenis Obat", "nama_jenis_obat");
			$daftar_obat_adapter->add("Stok", "stok");
			$daftar_obat_adapter->add("Nilai", "uang","money Rp.");
			$columns = array("id_obat", "nama_obat", "nama_jenis_obat", "sisa");
			$daftar_obat_dbtable = new DBTable(	$this->db,$this->tbl_stok_obat,$columns);
			$filter = "";
			if (isset($_POST['kriteria'])) {
				$filter = " AND (		nama_obat LIKE '%" . $_POST['kriteria'] . "%' 
									OR 	nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%'
								)";
			}
			
			if(isset($_POST['filter']) && $_POST['filter']=="all_not_empty"){
				$filter .= " AND sisa>0 ";
			}else if(isset($_POST['filter']) && $_POST['filter']=="empty"){
				$filter .= " AND sisa<=0 ";
			}
			
			$v_stok="
					SELECT id_obat, 
							nama_obat, 
							nama_jenis_obat, 
							sum(uang) as uang, 
							GROUP_CONCAT(CONCAT(sisa, ' ', satuan) 
							ORDER BY satuan, sisa ASC SEPARATOR ', ') AS 'stok'
					FROM (
						SELECT id_obat, nama_obat, 
								nama_jenis_obat, SUM(sisa) AS 'sisa', 
								sum(hna*sisa) as uang, satuan, 
								konversi, satuan_konversi
						FROM ".$this->tbl_stok_obat." 
						LEFT JOIN ".$this->tbl_obat_masuk." 
							ON ".$this->tbl_stok_obat.".id_obat_masuk = ".$this->tbl_obat_masuk.".id
						WHERE ".$this->tbl_stok_obat.".prop NOT LIKE 'del' 
								AND ".$this->tbl_obat_masuk.".prop NOT LIKE 'del' 
								AND ".$this->tbl_obat_masuk.".status = 'sudah' " . $filter . "
						GROUP BY id_obat, satuan, konversi, satuan_konversi
					) v_obat
					GROUP BY id_obat";
			
			
			$query_value = "SELECT * FROM ( $v_stok ) v_stok ORDER BY nama_obat, nama_jenis_obat ASC";
			$query_count = " SELECT COUNT(*) FROM ( $v_stok ) v_stok WHERE stok NOT LIKE '0 %' ";

			$daftar_obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
			$daftar_obat_dbresponder = new DBResponder(	$daftar_obat_dbtable,$this->daftar_obat_table,$daftar_obat_adapter);
			$data = $daftar_obat_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		
		public function phpPreLoad(){
			echo $this->header_button;
			echo "</br>";
			echo $this->daftar_obat_table->getHtml();
			echo addJS("framework/smis/js/table_action.js");
		}
		
		public function jsPreLoad(){
			?>		
			<script type="text/javascript">
				var DAFTAR_OBAT_PNAME="<?php echo $this->proto_name; ?>";
				var DAFTAR_OBAT_PSLUG="<?php echo $this->proto_slug; ?>";
				var DAFTAR_OBAT_PIMPL="<?php echo $this->proto_implement; ?>";
				var DAFTAR_OBAT_ENTITY="<?php echo $this->page; ?>";
				var daftar_obat;
				$(document).ready(function() {
					$('[data-toggle="popover"]').popover({
						trigger: 'hover',
						'placement': 'top'
					});
					var daftar_obat_columns = new Array("id_obat", "nama_obat", "nama_jenis_obat", "sisa");
					daftar_obat = new TableAction("daftar_obat",DAFTAR_OBAT_ENTITY,"daftar_obat",daftar_obat_columns);
					daftar_obat.setPrototipe(DAFTAR_OBAT_PNAME,DAFTAR_OBAT_PSLUG,DAFTAR_OBAT_PIMPL);
					daftar_obat.addViewData=function(view_data){
						view_data['filter']=$("#filter").val();
						return view_data;
					};
					daftar_obat.export_pdf = function() {
						var self = this;
						var data = this.getRegulerData();
						data['command'] = "export_pdf";
						showLoading();
						$.post(
							"",
							data,
							function(response) {
								var json = getContent(response);
								if (json == null) {
									dismissLoading();
									return;
								}
								var getUrl = window.location['pathname'] + json;
					            window.open(getUrl, 'pdf');
					            dismissLoading();
							}
						);
					};
					daftar_obat.view();
				});
			</script>
			<?php 
		}	
	}
?>