<?php 

/**
 * Command Pattern for Consuming Service from vary Autonomous
 * instead of using class as it's parameter. it's using array as
 * implementation. if we override this Class it will act like 
 * Command Pattern.
 * 
 * @author      : goblooge
 * @since       : 15 May 2014
 * @version     : 2.1.2
 * @copyright   : Nurul Huda <goblooge@gmail.com>
 *
 */
class ServiceConsumer{
    /*@var PackageCommunication*/
	private $package_comunication;
    /*@var SendRequest*/
	private $send_request;
    /*@var string*/
	protected $result;
    /*@var QueryLog*/
	protected $querylog;
	/*@var string*/
	protected $service;
	/*@var int*/
	protected $mode;
	/*@var Array*/
	protected $data;
    /*@var string*/
	protected $this_autonomous;
	/*@var string*/
	private $code;
    
    /*processing mode*/
	public static $SINGLE_MODE					= 0;
	public static $MULTIPLE_MODE				= 1;
	public static $CLEAN_AUTONOMOUS				= 2;
	public static $CLEAN_ENTITY					= 3;
	public static $CLEAN_BOTH					= 4;
	public static $CLEAN_BOTH_JOIN_SINGLE_ARRAY	= 5;	
	public static $JOIN_AUTONOMOUS				= 6;
	public static $JOIN_ENTITY					= 7;
	public static $JOIN_BOTH					= 8;    
    public static $KEY_ENTITY					= 9;
	
    
	
	public function __construct($db,$service,$data=NULL,$entity="all",$autonomous="all",$tuser=null){
		$keys=getSettings($db, "smis_autonomous_key", "nothing");		
		if($tuser==null){
			global $user;
			$tuser = $user;
		}
		$this->data					= $data;
		$this->mode					= self::$SINGLE_MODE;
		$this->service				= $service;		
		$this->package_comunication	= new PackageComunication($autonomous, $entity, $this->service,$data);
		$this->package_comunication->setParams($keys, $tuser->getNameOnly(), $tuser->getIp());		
		$url						= getSettings($db, "smis_serverbus_url", "");
		$this->this_autonomous		= getSettings($db, "smis_autonomous_id", "");
		$url						= confirmURL($url,"smis-serverbus/service.php");
		$send_key					= getSettings($db, "smis_serverbus_key", md5(date('mdyhisu')));
		$receive_key				= $keys;
		global $querylog;		
		$this->querylog				= $querylog;
		$this->send_request			= new SendRequest($url,$this->querylog);
		$this->send_request->setPackage($this->package_comunication);
		$this->send_request->setKeys($send_key, $receive_key);
		$this->code					= "";
	}
	
	/*resetting new code if the service used twice*/
	public function resetCode(){
		$this->package_comunication->resetCode();
		return $this;
	}
	
    /**
     * @brief set the service name that want to change
     * @param string $servicename 
     * @return  
     */
    public function setService($servicename){
        $this->service				= $servicename;
        $this->package_comunication->setService($servicename);
        return $this;
    }
    
    /**
     * @brief set the cache name
     * @param string $enabled 
     * @param string $cache_name 
     * @return  this
     */
    public function setCached($enabled,$cache_name){
        $this->send_request->setCached($enabled,$cache_name);
        return $this;
    }
	
    /**
     * @brief set the entity of the service destination
     * @param string/array $entity 
     * @return  this
     */
	public function setEntity($entity){
		$this->package_comunication->setEntity($entity);
        return $this;
	}
    
    /**
     * @brief set how the service result would be used
     * @param string $mode 
     * @return  this
     */
	public function setMode($mode){
		$this->mode	= $mode;
		return $this;
	}
    
    /**
     * @brief get the current mode in the system
     * @return  mode;
     */
    public function getMode(){
        return $this->mode;
    }
	
    /**
     * @brief execute the service
     * @return  this
     */
	public function execute(){
		$this->result	= $this->send_request->execute();
		$post			= json_encode($_POST);
		$msg			= json_encode($this->send_request->getSendedMessage());
		$result			= $this->result;
		$this->code		= $this->package_comunication->getCode();
		$this->querylog->addConsumer($post, $msg, $result,$this->code,$this->service,$this->this_autonomous);
		$this->querylog->addService($this->service,$this->code);
		return $this;
	}
	
    /**
     * @brief get the code that generated by the SendRequest class
     *          for loggin purpose
     * @return  string md5 code
     */
	public function getCode(){
		return $this->code;
	}
	
    /**
     * @brief used the service result as single
     *      autonomous result, if there 2 autonomous then
     *      the first one will be used
     * @return  array $content
     */
	protected function singleResult(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous){
			foreach($autonomous as $entity){
				if($entity!=null || $entity!="")
					return $entity;
			}
		}
		return $content;
	}
	
     /**
     * @brief used the as multi result, actually is just 
     *          change the content from string json to array
     * @return  array $content
     */
	protected function multiResult(){
		$content	= array();
		$result		= json_decode($this->result,true);	
		return $result;
	}
	
     /**
     * @brief a multiple result that contain list of array join together but
     *          the autonomous name will be clean
     * @return  array $content
     */
	protected function cleanAutonomous(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous_name=>$autonomous){
			foreach($autonomous as $entity_name=>$entity){
			foreach($entity as $onelist){
					if(!isset($content[$entity_name]))
						$content[$entity_name]	= array();
					$content[$entity_name][]	= $onelist;
				}
			}
		}
		return $content;
	}
	
    /**
     * @brief a multiple result that contain list of array join together but
     *          the entity name will be clean
     * @return  array $content
     */
	protected function cleanEntity(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous_name=>$autonomous){
			foreach($autonomous as $entity_name=>$entity){
				foreach($entity as $onelist){
					if(!isset($content[$autonomous_name]))
						$content[$autonomous_name]	= array();
					$content[$autonomous_name][]	= $onelist;
				}
			}
		}
		return $content;
	}
	
    /**
     * @brief a multiple result that contain list of array join together but
     *          the autonomous name and the entity name will be clean
     * @return  array $content
     */
	protected function cleanBoth(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous_name=>$autonomous){
			foreach($autonomous as $entity_name=>$entity){
				foreach($entity as $onelist){
					$content[]	= $onelist;
				}
			}
		}
		return $content;
	}
   
   
	 /**
     * @brief a multiple result that contain list of array join together but
     *          the autonomous name and the entity name will be clean, and join as single list
     * @return  array $content
     */
	protected function cleanBothJoinSingleArray(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous_name=>$autonomous){
			foreach($autonomous as $entity_name=>$entity){
				if($entity!=NULL)
					$content[]	= $entity;
			}
		}
		return $content;
	}
	
    /**
     * @brief a multiple result that contain list of array join together but
     *          the autonomous name and the entity would be join as one data in array
     *          name , index autonomous for autonomous name and index entity for entity name
     *          and make the entity as an index, this used for same entity but different autonomous
     * @return  array $content
     */
	protected function joinAutonomous(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous_name=>$autonomous){
			foreach($autonomous as $entity_name=>$entity){
				foreach($entity as $one_list){
					$one_list['autonomous']		= $autonomous_name;
					$one_list['entity']			= $entity_name;
					if(!isset($content[$entity_name]))
						$content[$entity_name]	= array();
					$content[$entity_name][]	= $onelist;
				}
			}
		}		
		return $content;
	}
	
    /**
     * @brief a multiple result that contain list of array join together but
     *          the entity would be join as one data in array
     *          index entity for entity name
     * @return  array $content
     */
	protected function joinEntity(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous_name=>$autonomous){
			$content[$autonomous_name]	= array();
			foreach($autonomous as $entity_name=>$entity){
				foreach($entity as $one_list){
					$one_list['entity']	= $entity_name;
					if(!isset($content[$autonomous_name]))
						$content[$autonomous_name]	= array();
					$content[$autonomous_name][]	= $one_list;
				}
			}
		}
		return $content;
	}
    
    /**
     * @brief a multiple result that contain list of array join together but
     *          the entity would be join as a key of the array list 
     * @return  array $content
     */
    protected function keyEntity(){
		$content	= array();
		$result		= json_decode($this->result,true);
        $content	= array();
		foreach($result as $autonomous_name=>$autonomous){
			foreach($autonomous as $entity_name=>$entity){
				$content[$entity_name]	= $entity;
			}
		}
		return $content;
	}
	
     /**
     * @brief a multiple result that contain list of array join together but
     *          the autonomous name and the entity would be join as one data in array
     *          name , index autonomous for autonomous name and index entity for entity name
     * @return  array $content
     */
	protected function joinBoth(){
		$content	= array();
		$result		= json_decode($this->result,true);
		foreach($result as $autonomous_name=>$autonomous){
			foreach($autonomous as $entity_name=>$entity){
				foreach($entity as $one_list){
					$one_list['autonomous']	= $autonomous_name;
					$one_list['entity']		= $entity_name;
					$content[]				= $one_list;
				}
			}
		}		
		return $content;
	}
	
    /**
     * @brief get the service result
     * @return  string result
     */
	public function getResult(){
		return $this->result;
	}
	
    /**
     * @brief proceed the service result
     * @return  string result
     */
	public function proceedResult(){	
		if($this->mode==self::$SINGLE_MODE) 						return $this->singleResult();
		else if($this->mode==self::$MULTIPLE_MODE) 					return $this->multiResult();
		else if($this->mode==self::$CLEAN_AUTONOMOUS) 				return $this->cleanAutonomous();
		else if($this->mode==self::$CLEAN_ENTITY) 					return $this->cleanEntity();
		else if($this->mode==self::$CLEAN_BOTH) 					return $this->cleanBoth();
		else if($this->mode==self::$CLEAN_BOTH_JOIN_SINGLE_ARRAY) 	return $this->cleanBothJoinSingleArray();
		else if($this->mode==self::$JOIN_AUTONOMOUS) 				return $this->joinAutonomous();
		else if($this->mode==self::$JOIN_ENTITY) 					return $this->joinEntity();
		else if($this->mode==self::$JOIN_BOTH) 						return $this->joinBoth();
        else if($this->mode==self::$KEY_ENTITY) 					return $this->keyEntity();
	}
	
    /**
     * @brief get the service result
     * @return only aliasing 
     */
	public function getContent(){
		return $this->proceedResult();
	}
	
    /**
     * @brief set the data for sending to the service
     * @param Array $data 
     * @return  this
     */
	public function setData($data){
		$this->data	= $data;
		$this->package_comunication->setData($data);
		return $this;
	}
	
    /**
     * @brief adding one single data in service
     * @param string $key 
     * @param mixed $value 
     * @return  
     */
	public function addData($key,$value){
		if($this->data==NULL) {
			$this->data=array();
		}
		$this->data[$key]	= $value;
		$this->package_comunication->setData($this->data);
		return $this;
	}	
}
?>