<?php 	
	$GOBLOOGE_LOGO="data:image/png;base64,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";
	$SMIS_LOGO="data:image/png;base64,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";
?>