var _sgps = new Object();
_sgps.cur_loc  = {lat: -6.175258, lng: 106.826808};
_sgps.loaded = false;
_sgps.current_table;
_sgps.marker;
_sgps.map;

_sgps_initMap = function(){
    var element  = document.getElementById('map-modal-viewer');
    var geocoder = new google.maps.Geocoder;
      _sgps.map = new google.maps.Map(element, {
        center: _sgps.cur_loc,
        zoom: 8
      });
      _sgps.initMarker();
      $("#smis-map-chooser").smodal("show");
      google.maps.event.addListener(_sgps.map, 'click', function(args) {
        if(_sgps.marker!=null){
            _sgps.marker.setMap(null);
        }
        _sgps.marker = new google.maps.Marker({position: args.latLng, map: _sgps.map});
        $("#smis-map-longitude").val(args.latLng.lng);
        $("#smis-map-latitude").val(args.latLng.lat);

        geocoder.geocode({'location': args.latLng}, function(results, status) {
            if (status === 'OK') {
            if (results[1]) {
                $("#smis-map-address").val(results[1].formatted_address);
            } else {
                $("#smis-map-address").val("");
            }
            } else {
                $("#smis-map-address").val("");
            }
        });
    });

    // Create the search box and link it to the UI element.
    var input = document.getElementById('smis-map-search');
    var searchBox = new google.maps.places.SearchBox(input);
    _sgps.map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

    _sgps.map.addListener('bounds_changed', function() {
        searchBox.setBounds(_sgps.map.getBounds());
    });

    searchBox.addListener('places_changed', function() {
        var places = searchBox.getPlaces();

        if (places.length == 0) {
          return;
        }
        // For each place, get the icon, name and location.
        var bounds = new google.maps.LatLngBounds();
        places.forEach(function(place) {
          if (!place.geometry) {
            console.log("Returned place contains no geometry");
            return;
          }
          _sgps.map.setCenter(place.geometry.location)

          if (place.geometry.viewport) {
            bounds.union(place.geometry.viewport);
          } else {
            bounds.extend(place.geometry.location);
          }
        });
        _sgps.map.fitBounds(bounds);
      });
};

_sgps.initMarker = function(){
    if(_sgps.marker!=null){
        _sgps.marker.setMap(null);
    }
    _sgps.marker = new google.maps.Marker({position: _sgps.cur_loc, map: _sgps.map});
};

_sgps.setPosition = function(lat,lon,address){
    _sgps.cur_loc  = {lat: lat, lng: lon};
    $("#smis-map-address").val(address);
};

_sgps.show = function(tbl_action,lat,lon,element){
    _sgps.current_table = tbl_action;
    _sgps.setPosition(lat,lon,"");
    tbl_action.preInitMap(element);
    if ( !(typeof google === 'object' && typeof google.maps === 'object') ) {
        $.getScript( "https://maps.googleapis.com/maps/api/js?v=3.exp&libraries=places&" +
        "callback=_sgps_initMap&&key=AIzaSyDVUl5iuUbxug0Wgq1KGt5cdhFtL5ufOC0" )
        .done(function( script, textStatus ) {
            _sgps.loaded = true;
        })
        .fail(function( jqxhr, settings, exception ) {
            showWarning("Connection Problem...","Failed Load Map Caused By Network Problem");
        });
    }else{
        _sgps.initMarker();
        $("#smis-map-chooser").smodal("show");
    }

    if(!_sgps.loaded && typeof google === 'object' && typeof google.maps === 'object'){
        _sgps_initMap(); 
    }
};

_sgps.pint_it = function(){
    var d = new Array();
    d['address']    = $("#smis-map-address").val();
    d['longitude']  = $("#smis-map-longitude").val();
    d['latitude']   = $("#smis-map-latitude").val();
    _sgps.current_table.selected(d);
    $("#smis-map-chooser").smodal("hide");
}