<?php
require_once ("smis-framework/smis/ui/composite/Navigator.php");
require_once ("smis-framework/smis/ui/composite/Menu.php");
require_once ("smis-framework/smis/api/Plugin.php");
require_once ("smis-base/smis-base.php");
require_once "smis-administrator/class/table/PrototypeTable.php";
global $PLUGINS;

$header=array ('Name',"Slug","Parent","Keterangan","Settings" );
$uitable = new PrototypeTable ($header, "Prototype");
$uitable->setName ( "prototype" );

/* this is respond when system have to response */
if (isset ( $_POST ['command'] )) {
	$adapter = new SimpleAdapter ();
	$adapter->add ( "Slug", "slug" );
	$adapter->add ( "Name", "nama" );
	$adapter->add ( "Parent", "parent", "strtoupper" );
	$adapter->add ( "Keterangan", "keterangan" );
	$adapter->add ( "Settings", "settings" );
	$adapter->add ( "status", "status" );
	$adapter->add ( "parent", "parent" );
	$adapter->add ( "slug", "slug" );
	$dbtable = new DBTable ( $db, "smis_adm_prototype" );
	$dbtable->setOrder ( "slug ASC, nama ASC " );
	$dbres = new DBResponder ( $dbtable, $uitable, $adapter );
	$command = $_POST ['command'];
	if ($command == "install") {
		$parent = $_POST ['parent'];
		require_once $parent . '/install.php';
		$command = "save";
	}
	if($command == "uninstall"){
		$parent = $_POST ['parent'];
		require_once $parent . '/uninstall.php';
		$command = "save";
	}
	$data = $dbres->command ( $command );
	echo json_encode ( $data );
	return;
}

$parent = array ();
foreach ( $PLUGINS as $p ) {
	if (! $p->is_administrator () && $p->is_installed () && $p->is_actived () && $p->is_prototype () && ! $p->is_serverbus ()) {
		$parent [] = array (
				"name" => strtoupper ( $p->getName () ),
				"value" => $p->getname () 
		);
	}
}

global $user;
global $db;
require_once 'smis-base/smis-include-service-consumer.php';
$serv = new ServiceConsumer($db,"get_all_unit_kerja",array("username"=>$user->getUsername()),"hrd");
$serv->execute();
$content = $serv->getContent();
$unitkerja  = $content;	

$uitable->addModal("id","hidden","","");
$uitable->addModal("slug","text","Slug","");
$uitable->addModal("nama","text","Nama","");
$uitable->addModal("parent","select","Prototype",$parent);
$uitable->addModal("unitkerja","select","Unit Kerja",$unitkerja);
$uitable->addModal("keterangan","textarea","Keterangan","");
$uitable->addModal("settings","textarea","Settings","");

$modal = $uitable->getModal ();
$modal->setTitle ( "Prototype" );

echo $uitable->getHtml ();
echo $modal->getHtml ();
echo addJS ( "framework/smis/js/table_action.js" );

?>
<script type="text/javascript">
var prototype;
$(document).ready(function(){
	$('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
	var column=new Array('id','slug','nama',"parent",'keterangan',"settings","unitkerja");
	prototype=new TableAction("prototype","smis-administrator","prototype",column);
	prototype.setDisabledOnEdit(new Array("slug","parent"));
	
	
	prototype.install=function(id,slug,parent){
		var save_data=this.getRegulerData();
		save_data['command']="install";
		save_data['status']="installed";
		save_data['slug']=slug;
		save_data['parent']=parent;
		save_data['prototype_install']='y';
		save_data['id']=id;
		showLoading();
		$.post("",save_data,function(res){
			var json=getContent(res);
			prototype.view();
			dismissLoading();
		});
	};

	prototype.uninstall=function(id,slug,parent){
		var save_data=this.getRegulerData();
		save_data['status']="";
		save_data['command']="uninstall";
		save_data['slug']=slug;
		save_data['parent']=parent;
		save_data['prototype_install']='y';
		save_data['id']=id;
		showLoading();
		$.post("",save_data,function(res){
			var json=getContent(res);
			prototype.view();
			dismissLoading();
		});
	};

	prototype.actived=function(id){
		var save_data=this.getRegulerData();
		save_data['command']="save";
		save_data['status']="actived";
		save_data['id']=id;
		showLoading();
		$.post("",save_data,function(res){
			var json=getContent(res);
			prototype.view();
			dismissLoading();
		});
	};

	prototype.deactived=function(id){
		var save_data=this.getRegulerData();
		save_data['command']="save";
		save_data['status']="deactived";
		save_data['id']=id;
		showLoading();
		$.post("",save_data,function(res){
			var json=getContent(res);
			prototype.view();
			dismissLoading();
		});
	};

	prototype.view();

});
</script>