<?php 
require_once "smis-libs-class/MasterTemplate.php";
require_once "registration/class/responder/BPJSBackEndResponder.php";
global $db;

$mas=new MasterTemplate($db,"smis_rg_sep","registration","seprj");
$mas->setDateTimeEnable(true);
$uitable=$mas->getUItable();
$uitable->addModal("id","hidden","","");
$uitable->addModal("nama","text","Nama","");
$uitable->addModal("kode","text","Kode","");
$uitable->addModal("status","checkbox","Status","");
$uitable->setDelButtonEnable(false);
$uitable->setHeader(array("No.","No.SEP","No.RM","No.Reg","No.BPJS","Tanggal","Tgl Rujukan","No.RJK","PPK","Diagnosa","Tujuan","Kelas","Server"));

$detail=new Button("","","Detail");
$detail->setIsButton(Button::$ICONIC);
$detail->setIcon(" fa fa-list");
$detail->setClass("btn-primary");
$uitable->addContentButton("sep_detail",$detail);

$detail=new Button("","","Cetak");
$detail->setIsButton(Button::$ICONIC);
$detail->setIcon(" fa fa-print");
$detail->setClass("btn-inverse");
$uitable->addContentButton("sep_print",$detail);

$pulang=new Button("","","Pulang");
$pulang->setIsButton(Button::$ICONIC);
$pulang->setIcon(" fa fa-sign-out");
$pulang->setClass("btn-info");
$uitable->addContentButton("show_sep_pulang",$pulang);


$remove=new Button("","","Hapus");
$remove->setIsButton(Button::$ICONIC);
$remove->setIcon(" fa fa-trash");
$remove->setClass("btn-danger");
$uitable->addContentButton("sep_remove",$remove);


$jenis=new OptionBuilder();
$jenis->add("","",1);
$jenis->add("IGD","0",0);
$jenis->add("Rawat Inap","1",0);
$jenis->add("Rawat Jalan","2",0);

$polidb=new DBTable($db,"smis_rg_refpolibpjs");
$polidb->addCustomKriteria("status","='1'");
$polidb->setShowAll(true);
$d=$polidb->view("",0);
$list=$d['data'];
$adapter=new SelectAdapter("nama","kode");
$content=$adapter->getContent($list);
array_push($content,array("name"=>"","value"=>"","default"=>1));

$kelas=new OptionBuilder();
$kelas->add("","",1);
$kelas->add("Kelas I","1",0);
$kelas->add("Kelas II","2",0);
$kelas->add("Kelas III/Rawat Jalan","3",0);

$laka=new OptionBuilder();
$laka->add("Kasus Kecelakaan","1",0);
$laka->add("Bukan Kasus Kecelakaan","2",1);

$uitable->clearContent();
$uitable->addModal("id","hidden","","");
$uitable->addModal("noSEP","text","No Sep","","n",null,true);
$uitable->addModal("noKartu","text","No BPJS","","n",null,true);
$uitable->addModal("tglSep","datetime","Tgl SEP","","n",null,false);
$uitable->addModal("tglRujukan","datetime","Tgl Rujukan","","n",null,false);
$uitable->addModal("noRujukan","text","No Rujukan","","y",null,false);
$uitable->addModal("ppkRujukan","text","PPK Rujukan","","y",null,false);
$uitable->addModal("ppkPelayanan","text","PPK Pelayanan","","n",null,false);
$uitable->addModal("jnsPelayanan","select","Jenis Layanan",$jenis->getContent(),"n",null,true);
$uitable->addModal("diagAwal","text","Kode Diagnosa","A010","n",null,false);
$uitable->addModal("poliTujuan","select","Poli Tujuan",$content,"y",null,false);
$uitable->addModal("klsRawat","select","Kelas",$kelas->getContent(),"n",null);
$uitable->addModal("lakaLantas","select","Kasus Laka",$laka->getContent(),"n",null);
$uitable->addModal("lokasiLaka","text","Lokasi Laka","","y",null);
$uitable->addModal("catatan","textarea","Catatan","","y",null);
$uitable->addModal("user","text","User SEP",getSettings($db,"reg-bpjs-sep-api-user","-"),"y",null,true);
$uitable->addModal("noMr","text","NRM Pasien","","n",null,true);

$adapter=$mas->getAdapter();
$adapter->setUseNumber(true,"No.","back.");
$adapter->add("No.SEP","noSEP");
$adapter->add("No.RM","noMr","only-digit8");
$adapter->add("No.Reg","noReg","only-digit8");
$adapter->add("No.BPJS","noKartu");
$adapter->add("Tanggal","tglSep","date d M Y H:i");
$adapter->add("Tgl Rujukan","tglRujukan","date d M Y H:i");
$adapter->add("No.RJK","noRujukan");
$adapter->add("PPK","ppkRujukan");
$adapter->add("Diagnosa","diagAwal");
$adapter->add("Tujuan","poliTujuan");
$adapter->add("Kelas","klsRawat");
$adapter->add("Server","delServer","trivial_1_Deleted_Saved");

$dbtable=$mas->getDBtable();
$dbtable->addCustomKriteria("jnsPelayanan","='2'");
$dbres=new BPJSBackEndResponder($dbtable,$uitable,$adapter);
if($dbres->isPreload()){
    $modal=new Modal("update_tgl_pulang_seprj","","seprj");
    $modal->addModalElement("datetime","","Tanggal","tanggal_pulang",null,"n");
    $modal->addModalElement("hidden","","","id_pulang",null,"n");
    $button=new Button("", "", "Update Pulang");
    $button->setClass("btn-primary");
    $button->setIsButton(Button::$ICONIC_TEXT);
    $button->setIcon("fa fa-sign-out");
    $button->setAction("seprj.sep_pulang()");
    $modal->addFooter($button);
    $modal->setTitle("Update Tanggal Pulang");
    echo $modal->getHtml();
}
$mas->setDBresponder($dbres);    
$mas->setModalTitle("Map Referensi Poli BPJS");
$mas->addResouce("js","registration/resource/js/seprj.js");
$mas->addResouce("css","registration/resource/css/sep_table.css");
$mas->initialize();

?>