<?php 
/**
 * this page used to control and registration
 * of patient BPJS so usign VClaim system
 * 
 * @author      : Nurul Huda
 * @since       : 17 Feb 2018
 * @license     : LGPv2
 * @copyright   : goblooge@gmail.com
 * @version     : 1.2.1
 * @database    : - smis_rg_sep
 * 
 */
global $db;
$uitable            = new Table("");
$uitable->setName("cek_vklaim");

if(isset($_POST['super_command']) && $_POST['super_command']!=""){
    require_once "smis-base/smis-include-service-consumer.php";
    $array          = array ("Kode",'DTD','Nama',"Sebab" );
    $muitable       = new Table($array);
    $muitable       ->setModel(Table::$SELECT)
                    ->setName("cek_vklaim_icd");
    $madapter       = new SimpleAdapter();
    $madapter       ->add("Nama","nama")
                    ->add("Kode","icd")
                    ->add("DTD","dtd")
                    ->add("Sebab","sebab");
    $mr_mresponder  = new ServiceResponder($db, $muitable, $madapter,"get_diagnosa_responder","medical_record");

    $super          = new SuperCommand ();
    $super->addResponder ( "cek_vklaim_icd", $mr_mresponder );
    $init           = $super->initialize ();
    if ($init != null) {
        echo $init;
        return;
    }
}

if(isset($_POST['command']) &&  $_POST['command']!=""){
    require_once "registration/class/responder/BPJSVClaimCheckerResponder.php";
    $dbtable    = new DBTable($db,"smis_rg_sep");
    $adapter    = new SimpleAdapter();
    $dbres      = new BPJSVClaimCheckerResponder($dbtable,$uitable,$adapter);
    $data       = $dbres->command($_POST['command']);
    echo json_encode($data);
    return;
}

$uitable        ->addModal("no_bpjs","text","No. BPJS","")
                ->addModal("no_ktp","text","No. KTP","");
$form           = $uitable->getModal()->getForm();
$cek            = new Button("cek_vklaim_button","cek_vklaim_button","Cek BPJS");
$cek            ->setAction("cek_vklaim.fetch_server()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-id-card")
                ->setClass(" btn btn-primary");
$rujukan        = new Button("","","Cek Rujukan");
$rujukan        ->setAction("cek_vklaim.cek_rujukan()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-arrows")
                ->setClass(" btn btn-success");
$reset          = new Button("","","Reset");
$reset          ->setAction("cek_vklaim.reset()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-refresh")
                ->setClass(" btn btn-danger");
$grup           = new ButtonGroup("","","");
$grup           ->addButton($cek)
                ->addButton($rujukan)
                ->addButton($reset);
$form           ->addElement("",$grup);

$jenis          = new OptionBuilder();
$jenis          ->add("","",1)
                ->add("Rawat Inap","1",0)
                ->add("Rawat Jalan","2",0);

$polidb         = new DBTable($db,"smis_rg_refpolibpjs");
$polidb         ->addCustomKriteria("status","='1'")
                ->addCustomKriteria("grup","='poli'")
                ->setOrder(" nama ASC ",true)
                ->setShowAll(true);
$d              = $polidb->view("",0);
$list           = $d['data'];
$adapter        = new SelectAdapter("nama","kode");
$content        = $adapter->getContent($list);
array_push($content,array("name"=>"","value"=>"","default"=>1));

$kelas          = new OptionBuilder();
$kelas          ->add("","",1)
                ->add("Kelas I","1",0)
                ->add("Kelas II","2",0)
                ->add("Kelas III/Rawat Jalan","3",0);
$asal           = new OptionBuilder();
$asal           ->add("Faskes Tingkat 1 (Puskesmas)","1","1")
                ->add("Faskes Tingkat 2 (RS)","2","0");
$cob            = new OptionBuilder();
$cob            ->add("Ya","1","0")
                ->add("Tidak","0","1");
$pjmn           = new OptionBuilder();
$pjmn           ->add("","","1")
                ->add("Jasa raharja ","1","0")
                ->add("BPJS Ketenagakerjaan","2","0")
                ->add("TASPEN PT","3","0")
                ->add("ASABRI PT","4","0");

$laka           = new OptionBuilder();
$laka           ->add("Bukan Kasus Kecelakaan","0",1)
                ->add("Kasus Kecelakaan","1",0);
$ppkPelayanan   = getSettings($db,"reg-bpjs-vclaim-api-ppk-pelayanan","");
$bpjs_user      = getSettings($db,"reg-bpjs-vclaim-api-user","smis");
$uitable        ->clearContent();
$uitable        ->addModal("noKartu","text","No BPJS","","n",null,false)
                ->addModal("tglSep","datetime","Tgl SEP",date("Y-m-d H:i:s"),"n",null,false)
                ->addModal("tglRujukan","datetime","Tgl Rujukan",date("Y-m-d H:i:s"),"n")
                ->addModal("noRujukan","text","No Rujukan","","y",null)
                ->addModal("asalRujukan","select","Asal Rujukan",$asal->getContent(),"y",null)
                ->addModal("ppkRujukan","text","PPK Rujukan","","y",null)
                ->addModal("ppkPelayanan","text","PPK Pelayanan",$ppkPelayanan,"n",null,true)
                ->addModal("jnsPelayanan","select","Jenis Layanan",$jenis->getContent(),"n",null)
                ->addModal("diagAwal","chooser-cek_vklaim-cek_vklaim_icd-ICD 10 Diagnosa","Kode Diagnosa","","n",null)
                ->addModal("poliTujuan","select","Poli Tujuan",$content,"n",null)
                ->addModal("eksekutif","checkbox","Eksekutif","","y",null)
                ->addModal("cob","select","Cost Bersama (COB)",$cob->getContent(),"y",null)
                ->addModal("klsRawat","select","Kelas",$kelas->getContent(),"n",null)
                ->addModal("lakaLantas","select","Kasus Laka",$laka->getContent(),"n",null)
                ->addModal("penjamin","multiple-select","Penjamin",$pjmn->getContent(),"y",null)
                ->addModal("lokasiLaka","text","Lokasi Laka","","y",null,true)
                ->addModal("catatan","textarea","Catatan","","y",null)
                ->addModal("user","text","User SEP",$bpjs_user,"n",null,true)
                ->addModal("noMr","text","NRM Pasien","","n",null,true)
                ->addModal("id_pasien","text","ID Pasien","","n",null,true)
                ->addModal("noTelp","text","Telp Pasien","","n");

$formsep        = $uitable->getModal()->setComponentSize(Modal::$MEDIUM)->getForm();
$cek            = new Button("","","Register SEP");
$cek            ->setAction("cek_vklaim.reg_sep()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-upload")
                ->setClass(" btn btn-primary");
$formsep        ->addElement("",$cek);

$uitable->clearContent();
$uitable->addModal("noSEP","text","No SEP","","n",null,true);
$formnosep      = $uitable->getModal()->setComponentSize(Modal::$MEDIUM)->getForm();
$print          = new Button("","","Cetak SEP");
$print          ->setAction("cek_vklaim.print_sep()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-print")
                ->setClass(" btn btn-primary");
$formnosep      ->addElement("",$print);

$uitable->clearContent();
$uitable->addModal("noREG","text","No REG","","n",null,true);
$formnorereg    = $uitable->getModal()->setComponentSize(Modal::$MEDIUM)->getForm();
$reg            = new Button("","","Register Pasien");
$reg            ->setAction("cek_vklaim.register_pasien_bpjs()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-sign-in")
                ->setClass(" btn btn-primary");
$fix            = new Button("","","Fix Register");
$fix            ->setAction("cek_vklaim.fix_register()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-eraser")
                ->setClass(" btn btn-success");
$sep            = new Button("","","SEP Sementara");
$sep            ->setAction("cek_vklaim.sep_sementara()")
                ->setIsButton(Button::$ICONIC_TEXT)
                ->setIcon(" fa fa-tag")
                ->setClass(" btn btn-danger");
$btngroup       = new ButtonGroup("");
$btngroup       ->addButton($reg)
                ->addButton($fix);
$formnorereg    ->addElement("",$btngroup)
                ->addElement("",$sep);


$rows           = new RowSpan();
$rows           ->addSpan("<h5>REGISTRASI BPJS/SEP</h5><div class='clear'></div><div>".$formsep->getHtml()." <div class='clear'></div>".$formnosep->getHtml()." <div class='clear'></div>".$formnorereg->getHtml()." </div>",7)
                ->addSpan("<h5>DATA PESERTA BPJS</h5><div class='clear'></div><div id='cek_vklaim_page'>Silakan Masukan No. BPJS atau No. KTP dibagian Pencarian dan Hasilnya akan di tampilkan !!!</div>",5);

echo $form->getHtml();
echo "<div class='clear'></div>";
echo $rows->getHtml();
echo addJS  ("framework/bootstrap/js/bootstrap-datetimepicker.js");
echo addCSS ("framework/bootstrap/css/bootstrap-datetimepicker.css");
echo addJS  ("framework/smis/js/table_action.js");
echo addJS  ("registration/resource/js/cek_vklaim.js",false);
echo addCSS ("registration/resource/css/sep_table.css",false);
?>