<?php

global $db;
require_once "smis-libs-class/MasterTemplate.php";
require_once "smis-libs-class/MasterSlaveTemplate.php";
require_once "registration/class/responder/KelompokProlanisDBTable.php";
require_once "registration/class/responder/ClubProlanisDBTable.php";
require_once "registration/class/responder/DBResponderProlanis.php";

$master = new MasterSlaveTemplate($db,"smis_rg_asuransi","registration","kelompok_prolanis");
$dbtable = new KelompokProlanisDBTable($db,"smis_rg_asuransi",array("id","club_id","nama_club","tanggal_pelayanan","nama_kegiatan","nama_kelompok","materi","pembicara","lokasi","keterangan","biaya"));
$dbresponder = new DBResponderProlanis($dbtable,$master->getUItable(),$master->getAdapter());
$master ->setDBTable($dbtable);
$master ->setDBresponder($dbresponder);
$master->getUItable()->addModal("bulan","text","Bulan","");
$form = $master->getForm();
$master->getUItable()->clearContent();

$view = new Button("kelompok_prolanis","kelompok_prolanis","View");
$view->setAction("kelompok_prolanis.view()");
$view->setIsButton(Button::$ICONIC_TEXT);
$view->setIcon(" fa fa-search");
$view->setClass(" btn btn-primary");
$form ->addElement("",$view);

$master->getUItable()->setAction(true);
$master->getUItable()->setPrintButtonEnable(false);
$master->getUItable()->setReloadButtonEnable(false);
$master->getUItable()->setFooterVisible(false);
$master->getUItable()->setEditButtonEnable(false);

$master->getUItable()->addHeaderElement("No.");
$master->getUItable()->addHeaderElement("Edu ID");
$master->getUItable()->addHeaderElement("Nama Club");
$master->getUItable()->addHeaderElement("Nama Program");
$master->getUItable()->addHeaderElement("Tanggal Pelayanan");
$master->getAdapter()->setUseNumber(true,"No.","back.");

$kegiatan = new OptionBuilder();
$kegiatan ->add("Senam","01",1);
$kegiatan ->add("Penyuluhan","10",0);
$kegiatan ->add("Penyuluhan dan Senam","11",0);

$program = new OptionBuilder();
$program ->add("Diabetes Melitus","01",1);
$program ->add("Hipertensi","02",0);

$master->getAdapter()->add("id","text","Edu ID","");
$master->getAdapter()->add("Nama Club","nama_club");
$master->getAdapter()->add("Nama Program","nama_program");
$master->getAdapter()->add("Tanggal Pelayanan","tanggal_pelayanan","date d M Y");

$master->addJSColumn("id");
$master->addJSColumn("club_id");
$master->addJSColumn("nama_club");
$master->addJSColumn("tanggal_pelayanan");
$master->addJSColumn("nama_kegiatan");
$master->addJSColumn("nama_kelompok");
$master->addJSColumn("materi");
$master->addJSColumn("pembicara");
$master->addJSColumn("lokasi");
$master->addJSColumn("keterangan");
$master->addJSColumn("biaya");

$master->getUItable()->addModal("id","text","Edu ID","","y",null,true);
$master->getUItable()->addModal("club_id","chooser-kelompok_prolanis-club-Pilih Club","Club ID","","n",null,true);
$master->getUItable()->addModal("nama_club","text","Nama Club","","n",null,true);
$master->getUItable()->addModal("tanggal_pelayanan","idate","Tanggal","");
$master->getUItable()->addModal("nama_kegiatan","select","Nama Kegiatan",$kegiatan->getContent());
$master->getUItable()->addModal("nama_kelompok","select","Nama Kelompok",$program->getContent());
$master->getUItable()->addModal("materi","text","Materi","");
$master->getUItable()->addModal("pembicara","text","Pembicara","");
$master->getUItable()->addModal("lokasi","text","Lokasi","");
$master->getUItable()->addModal("keterangan","textarea","Keterangan","");
$master->getUItable()->addModal("biaya","money","Biaya","");

$master->setModalTitle("Kelompok Prolanis");
$master->addRegulerData("bulan","bulan","id-value");
$master->addResouce("js","registration/resource/js/kelompok_prolanis.js");
$master->setDateEnable(true);
$master->setModalComponentSize(Modal::$MEDIUM);

$dbtable = new ClubProlanisDBTable($db,"smis_rg_asuransi"); 
$adapter = new SimpleAdapter();
$adapter ->add("ID Club","id");
$adapter ->add("Tanggal Mulai","tanggal_mulai","date d M Y");
$adapter ->add("Nama Club","nama_club");
$uitable = new Table(array("ID Club","Tanggal Mulai","Nama Club"),"");
$uitable ->setFooterVisible(false);
$uitable ->setModel(Table::$SELECT);
$uitable ->setName("club");
$dbresponder = new DBResponderProlanis($dbtable,$uitable,$adapter);
$master->addSuperCommandResponder("club",$dbresponder);
$master->addSuperCommandArray("club","club_id","id");
$master->addSuperCommandArray("club","nama_club","nama_club");
$master->addSuperCommandRegulerData("club","jenis_kelompok","nama_kelompok");
$master->initialize();
