<?php 
    require_once("registration/class/pcare/PCareStatusPulang.php");

    if (isset($_POST['command'])) {
        if ($_POST['command'] == "list") {            
            $response_package = new ResponsePackage();
            $number           = (isset($_POST['number']) && $_POST['number'] != "") ? $_POST['number'] : 0;
            $n_number         = $number;
            $max              = isset($_POST['max']) ? $_POST['max'] : "10";     
            $nama         	  = $_POST['nama'];
            $uri 			  = $_POST['uri'];
            $pcare            = new PCareStatusPulang();
            $pcare->setPCareAuthorization();
            $data             = $pcare->getStatusPulang($uri);
            $total            = $data['response']['count'];
            $code             = $data['metaData']['code'];
            $message          = $data['metaData']['message'];
            $max_page         = ceil($total / $max);
            if ($n_number >= $max_page && $n_number != 0) {
                $n_number       = $max_page - 1;
            }
            $page             = $n_number;
            $data             = $data['response']['list'];
            $max_page         = $max_page;
            $list             = "";
            $nomor            = 1 + $max * $number;
            foreach ($data as $d) {
        		if (stripos($d['kdStatusPulang'], $nama) !== false || stripos($d['nmStatusPulang'], $nama) !== false || $nama == "") {
	                $list .=    "<tr>" .
	                            	"<td>" . $nomor++ . "</td>" .
	                                "<td>" . $d['kdStatusPulang'] . "</td>" .
	                                "<td>" . $d['nmStatusPulang'] . "</td>" .
	                            "</tr>";
                }
            }
            $pagination = new Pagination('','', $number, 3, "pcare_status_pulang.paginate(this)", $max_page);
            $content = array(
                'list'          => $list,
                'pagination'    => $pagination->getHtml(),
                'number'        => $page,
                'number_p'      => $number,
                'total'         => $total,
                'max_page'      => $max_page,
                'max'           => $max
            );
            $response_package->setContent($content);
            if ($code == 200)
                $response_package->setStatus(ResponsePackage::$STATUS_OK);
            else {
                $response_package->setStatus(ResponsePackage::$STATUS_FAIL);
                $response_package->setAlertContent("Proses Pengambilan Data Gagal : " . $code, $message, ResponsePackage::$TIPE_DANGER);
                $response_package->setAlertVisible(true);
            }
            echo json_encode($response_package->getPackage());
        }
        return;
    }

    $table = new Table(
        array("No.", "Kode Status Pulang", "Nama Status Pulang"),
        "",
        null,
        true        
    );
    $table->setName("pcare_status_pulang");
    $table->setAction(false);

    $form = new Form("", "", "");
    $status_pulang_text = new Text("pcare_status_pulang_nama", "pcare_status_pulang_nama", "");
    $form->addElement("Status Pulang", $status_pulang_text);
    $uri_checkbox = new CheckBox("pcare_status_pulang_uri", "", true);
    $form->addElement("Status Pulang Rawat Inap", $uri_checkbox);
    $search_button = new Button("", "", "Tampilkan");
    $search_button->setClass("btn-inverse");
    $search_button->setIsButton(Button::$ICONIC_TEXT);
    $search_button->setIcon("icon-white icon-search");
    $search_button->setAction("pcare_status_pulang.view()");
    $form->addElement("", $search_button);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
    var pcare_status_pulang;
    $(document).ready(function() {
        pcare_status_pulang = new TableAction(
            "pcare_status_pulang",
            "registration",
            "pcare_status_pulang",
            new Array()
        );
        pcare_status_pulang.addViewData = function(data) {
            data['nama'] = $("#pcare_status_pulang_nama").val();
            data['uri'] = $("#pcare_status_pulang_uri").prop("checked");
            return data;
        };
        pcare_status_pulang.view = function() {
            var self        = this;
            var view_data   = this.getViewData();
            console.log();
            if (view_data == null) {
                showWarning("Error", this.view_data_null_message);
                return;
            }
            showLoading();
            $.post(
                '',
                view_data,
                function(res) {
                    var json = getContent(res);
                    if (json == null) {
                        
                    } else {
                        $("#" + self.prefix + "_list").html(json.list);
                        $("#" + self.prefix + "_pagination").html(json.pagination); 
                        self.initPopover();
                    }
                    dismissLoading();
                }
            );
            return this;
        };
        pcare_status_pulang.view();
        $("#pcare_status_pulang_nama").on("keydown", function(e) {
            if (e.which == 13) {
                e.preventDefault();
                pcare_status_pulang.view();
            }
        });
        $("#pcare_status_pulang_kriteria").remove();
        $("#pcare_status_pulang_search_button").remove();
        $("#pcare_status_pulang_pagination").html("");
        $("#pcare_status_pulang_max").val(5);
    });
</script>
<style type="text/css">
	.pcare_status_pulang_uri > label {
		width: 180 !important;
	}
</style>