<?php 
show_error();
require_once("registration/class/pcare/PCareReffSpesialis.php");

$header     = array("No.", "Kode PPK", "Nama PPK","Alamat","Telp","Kelas","Kecamatan","Jarak","Jadwal","Jumlah Rujuk","Kapasitas","Persentase");
$table      = new Table($header,"",null,true);
$table      ->setName("pcare_reff_rujukan_khusus_alih");
$table      ->setAction(false);
$table      ->setFooterVisible(false);

if (isset($_POST['command'])) {
    if ($_POST['command'] == "list") {            
        $response_package = new ResponsePackage();
        $number           = (isset($_POST['number']) && $_POST['number'] != "") ? $_POST['number'] : 0;
        $n_number         = $number;
        $max              = isset($_POST['max']) ? $_POST['max'] : "10";     
        $kode_icd         = $_POST['kode_icd'];
        $pcare            = new PCareReffSpesialis();
        $pcare->setPCareAuthorization();
        $tgl              = explode("-",$_POST['tanggal']);
        $rtg              = $tgl[2]."-".$tgl[1]."-".$tgl[0];
        $data             = $pcare->getRujukanKhususAlih($_POST['khusus'],$_POST['no_kartu'], $rtg);
        $total            = $data['response']['count'];
        $code             = $data['metaData']['code'];
        $message          = $data['metaData']['message'];
        $max_page         = ceil($total / $max);
        if ($n_number >= $max_page && $n_number != 0) {
            $n_number       = $max_page - 1;
        }
        $page             = $n_number;
        $datax            = $data['response']['list'];
       
        $max_page         = $max_page;
        $list             = "";
        $nomor            = 1 + $max * $number;

        $adapter = new SimpleAdapter(true,"No.","back.");
        $adapter ->add("Kode PPK","kdppk");
        $adapter ->add("Nama PPK","nmppk");
        $adapter ->add("Alamat","alamatPpk");
        $adapter ->add("Telp","telpPpk");
        $adapter ->add("Kelas","kelas");
        $adapter ->add("Kecamatan","nmkc");
        $adapter ->add("Jarak","distance","back M");
        $adapter ->add("Jadwal","jadwal");
        $adapter ->add("Jumlah Rujuk","jmlRujuk","back Orang");
        $adapter ->add("Kapasitas","kapasitas","back Orang");
        $adapter ->add("Persentase","persentase","back%");

        $bd      = $adapter ->getContent($datax);
        $table   ->setContent($bd);
        $list    = $table->getBodyContent();
      
        $content = array(
            'list'          => $list,
            'pagination'    => "",
            'number'        => $page,
            'number_p'      => $number,
            'total'         => $total,
            'max_page'      => $max_page,
            'max'           => $max
        );
        $response_package->setContent($content);
        if ($code == 200){
            $response_package->setStatus(ResponsePackage::$STATUS_OK);
        }else {
            $response_package->setStatus(ResponsePackage::$STATUS_FAIL);
            $response_package->setAlertContent("Proses Pengambilan Data Gagal : ".$code, $message, ResponsePackage::$TIPE_DANGER);
            $response_package->setAlertVisible(true);
        }
        echo json_encode($response_package->getPackage());
    }
    return;
}



$dbtable  = new DBTable($db,"smis_rg_pcare_reff_khusus");
$dbtable  ->setShowAll(true);
$dbtable  ->addCustomKriteria(" kode_khusus "," !='THA' ");
$dbtable  ->addCustomKriteria(" nama_khusus "," !='HEMOFILI' ");
$data     = $dbtable ->view("","0");
$list     = $data['data'];

$adapter  = new SelectAdapter("nama_khusus","kode_khusus");
$khusus   = $adapter ->getContent($list);
$khusus[] = array("name"=>"","value"=>"","default"=>"");

$table ->addModal("khusus","select","Khusus",$khusus);
$table ->addModal("no_kartu","text","No Kartu","");
$table ->addModal("tanggal","date","Tanggal Estimasi Rujuk","");
$form  = $table ->getModal()->getForm();

$sbtn  = new Button("", "", "Tampilkan");
$sbtn  ->setClass("btn-inverse");
$sbtn  ->setIsButton(Button::$ICONIC_TEXT);
$sbtn  ->setIcon("icon-white icon-search");
$sbtn  ->setAction("pcare_reff_rujukan_khusus_alih.view()");
$form  ->addElement("", $sbtn);

echo $form  ->getHtml();
echo $table ->getHtml();

echo addJS  ("framework/bootstrap/js/bootstrap-datepicker.js");
echo addCSS ("framework/bootstrap/css/datepicker.css");
echo addJS  ("framework/smis/js/table_action.js");
echo addJS  ("registration/resource/js/pcare_reff_rujukan_khusus_alih.js",false);