<?php 
global $db;

require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-class/MasterTemplate.php';
require_once 'registration/class/RegistrationResource.php';
$m = new MasterTemplate($db, "smis_rg_pcare_poli", "registration", "pcare_poli");

$ruangan = array();
$ruangan[] = array("name"=>"","value"=>"","default"=>1);
if($m->getDBResponder()->isPreload()){
    $content = RegistrationResource::getURJIP($db);
    foreach ($content as $autonomous=>$ruang){
        foreach($ruang as $nama_ruang=>$jip){
            $option				 = array();
            $option['value']	 = $nama_ruang;
            if(isset($jip['name'])){
                $option['name']	 = $jip['name'];
            }else{
                $option['name']	 = ArrayAdapter::format("unslug", $nama_ruang);
            }
            $ruangan[]			 = $option;
        }
    }
}

$m->getUItable()->addModal("id", "hidden", "", "");
$m->getUItable()->addModal("kode_poli", "text", "Kode Poli","", "n",null,true);
$m->getUItable()->addModal("nama_poli", "text", "Nama Poli", "", "n",null,true);
$m->getUItable()->addModal("poli_sakit", "checkbox", "Poli Sakit", "", "n",null,true);
$m->getUItable()->addModal("kode_ppk", "text", "Kode PPK", "", "n",null,true);
$m->getUItable()->addModal("nama_pcare", "text", "Nama PCare", "", "n",null,true);
$m->getUItable()->addModal("slug_mapping", "select", "Slug Mapping", $ruangan);

$m->getUItable()->setHeader(array("No.","Nama Klinik","Kode Poli","Nama Poli","Kode PPK","Poli Sakit","Slug Mapping"));
$m->getAdapter()->setUseNumber(true, "No.","back.");
$m->getAdapter()->add("Kode PPK", "kode_ppk");
$m->getAdapter()->add("Kode Poli", "kode_poli");
$m->getAdapter()->add("Nama Poli", "nama_poli");
$m->getAdapter()->add("Poli Sakit", "poli_sakit","trivial_1_<i class='fa fa-check'></i>");
$m->getAdapter()->add("Nama Klinik", "nama_pcare");
$m->getAdapter()->add("Slug Mapping", "slug_mapping","unslug");
$m->setModalTitle("PCare Poli");
$m->setModalComponentSize(Modal::$MEDIUM);
$m->initialize();