<?php 
    require_once("registration/class/pcare/PCareObat.php");

    if (isset($_POST['command'])) {
        if ($_POST['command'] == "list") {            
            $response_package = new ResponsePackage();
            $number           = 0;
            $max              = 500;     
            $kode_obat         = $_POST['kode_obat'];
            $pcare            = new PCareObat();
            $pcare->setPCareAuthorization();
            $data             = $pcare->getObat($kode_obat, $number, $max);
            $total            = $data['response']['count'];
            $code             = $data['metaData']['code'];
            $message          = $data['metaData']['message'];
            $data             = $data['response']['list'];
            $list             = "";
            $nomor            = 1 + $max * $number;
            foreach ($data as $d) {
                $list         .=    "<tr>" .
                                        "<td>" . $nomor++ . "</td>" .
                                        "<td>" . $d['kdObat'] . "</td>" .
                                        "<td>" . $d['nmObat'] . "</td>" .
                                        "<td>" . ArrayAdapter::format("number", $d['sedia']) . "</td>" .
                                    "</tr>";
            }
            $content = array(
                'list'          => $list
            );
            $response_package->setContent($content);
            if ($code == 200)
                $response_package->setStatus(ResponsePackage::$STATUS_OK);
            else {
                $response_package->setStatus(ResponsePackage::$STATUS_FAIL);
                $response_package->setAlertContent("Proses Pengambilan Data Gagal : " . $code, $message, ResponsePackage::$TIPE_DANGER);
                $response_package->setAlertVisible(true);
            }
            echo json_encode($response_package->getPackage());
        }
        return;
    }

    $table = new Table(
        array("No.", "Kode Obat", "Nama Obat", "Sedia"),
        "",
        null,
        true        
    );
    $table->setName("pcare_obat");
    $table->setAction(false);
    $table->setFooterVisible(false);

    $form = new Form("", "", "");
    $kode_obat_text = new Text("pcare_obat_kode_obat", "pcare_obat_kode_obat", "");
    $form->addElement("Kode / Nama Obat", $kode_obat_text);
    $search_button = new Button("", "", "Tampilkan");
    $search_button->setClass("btn-inverse");
    $search_button->setIsButton(Button::$ICONIC_TEXT);
    $search_button->setIcon("icon-white icon-search");
    $search_button->setAction("pcare_obat.view()");
    $form->addElement("", $search_button);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
    var pcare_obat;
    $(document).ready(function() {
        pcare_obat = new TableAction(
            "pcare_obat",
            "registration",
            "pcare_obat",
            new Array()
        );
        pcare_obat.addViewData = function(data) {
            data['kode_obat'] = $("#pcare_obat_kode_obat").val();
            return data;
        };
        pcare_obat.view = function() {
            if ($("#pcare_obat_kode_obat").val() == "") {
                bootbox.alert("Silakan Mengisi Kode / Nama Obat Terlebih Dahulu");
                return;
            }
            var self        = this;
            var view_data   = this.getViewData();
            if (view_data == null) {
                showWarning("Error", this.view_data_null_message);
                return;
            }
            TableAction.prototype.view.call(this);
        };
        $("#pcare_obat_kode_obat").on("keydown", function(e) {
            if (e.which == 13) {
                e.preventDefault();
                pcare_obat.view();
            }
        });
    });
</script>
<style type="text/css">
    #pcare_obat > div.form-container > form > div.pcare_obat_kode_obat > label {
        width: 150px !important;
    }
</style>