<?php 
    require_once("registration/class/pcare/PCareKesadaran.php");

    if (isset($_POST['command'])) {
        if ($_POST['command'] == "list") {            
            $response_package = new ResponsePackage();
            $number           = (isset($_POST['number']) && $_POST['number'] != "") ? $_POST['number'] : 0;
            $n_number         = $number;
            $max              = isset($_POST['max']) ? $_POST['max'] : "10";     
            $nama         	  = $_POST['nama'];
            $pcare            = new PCareKesadaran();
            $pcare->setPCareAuthorization();
            $data             = $pcare->getKesadaran();
            $total            = $data['response']['count'];
            $code             = $data['metaData']['code'];
            $message          = $data['metaData']['message'];
            $max_page         = ceil($total / $max);
            if ($n_number >= $max_page && $n_number != 0) {
                $n_number       = $max_page - 1;
            }
            $page             = $n_number;
            $data             = $data['response']['list'];
            $max_page         = $max_page;
            $list             = "";
            $nomor            = 1 + $max * $number;
            foreach ($data as $d) {
        		if (stripos($d['kdSadar'], $nama) !== false || stripos($d['nmSadar'], $nama) !== false || $nama == "") {
	                $list .=    "<tr>" .
	                            	"<td>" . $nomor++ . "</td>" .
	                                "<td>" . $d['kdSadar'] . "</td>" .
	                                "<td>" . $d['nmSadar'] . "</td>" .
	                            "</tr>";
                }
            }
            $pagination = new Pagination('','', $number, 3, "pcare_kesadaran.paginate(this)", $max_page);
            $content = array(
                'list'          => $list,
                'pagination'    => $pagination->getHtml(),
                'number'        => $page,
                'number_p'      => $number,
                'total'         => $total,
                'max_page'      => $max_page,
                'max'           => $max
            );
            $response_package->setContent($content);
            if ($code == 200)
                $response_package->setStatus(ResponsePackage::$STATUS_OK);
            else {
                $response_package->setStatus(ResponsePackage::$STATUS_FAIL);
                $response_package->setAlertContent("Proses Pengambilan Data Gagal : " . $code, $message, ResponsePackage::$TIPE_DANGER);
                $response_package->setAlertVisible(true);
            }
            echo json_encode($response_package->getPackage());
        }
        return;
    }

    $table = new Table(
        array("No.", "Kode Kesadaran", "Nama Kesadaran"),
        "",
        null,
        true        
    );
    $table->setName("pcare_kesadaran");
    $table->setAction(false);

    $form = new Form("", "", "");
    $kode_icd_text = new Text("pcare_kesadaran_nama", "pcare_kesadaran_nama", "");
    $form->addElement("Kesadaran", $kode_icd_text);
    $search_button = new Button("", "", "Tampilkan");
    $search_button->setClass("btn-inverse");
    $search_button->setIsButton(Button::$ICONIC_TEXT);
    $search_button->setIcon("icon-white icon-search");
    $search_button->setAction("pcare_kesadaran.view()");
    $form->addElement("", $search_button);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
    var pcare_kesadaran;
    $(document).ready(function() {
        pcare_kesadaran = new TableAction(
            "pcare_kesadaran",
            "registration",
            "pcare_kesadaran",
            new Array()
        );
        pcare_kesadaran.addViewData = function(data) {
            data['nama'] = $("#pcare_kesadaran_nama").val();
            return data;
        };
        pcare_kesadaran.view = function() {
            var self        = this;
            var view_data   = this.getViewData();
            console.log();
            if (view_data == null) {
                showWarning("Error", this.view_data_null_message);
                return;
            }
            showLoading();
            $.post(
                '',
                view_data,
                function(res) {
                    var json = getContent(res);
                    if (json == null) {
                        
                    } else {
                        $("#" + self.prefix + "_list").html(json.list);
                        $("#" + self.prefix + "_pagination").html(json.pagination); 
                        self.initPopover();
                    }
                    dismissLoading();
                }
            );
            return this;
        };
        pcare_kesadaran.view();
        $("#pcare_kesadaran_nama").on("keydown", function(e) {
            if (e.which == 13) {
                e.preventDefault();
                pcare_kesadaran.view();
            }
        });
        $("#pcare_kesadaran_kriteria").remove();
        $("#pcare_kesadaran_search_button").remove();
        $("#pcare_kesadaran_pagination").html("");
        $("#pcare_kesadaran_max").val(5);
    });
</script>