<?php 
require_once 'smis-libs-class/MasterSlaveTemplate.php';
require_once 'registration/class/responder/PasienNonAktifResponder.php';

global $db;

$button = new Button("", "", "");
$button ->setAction("laporan_non_aktif.view()");
$button ->setClass("btn-primary");
$button ->setIsButton(Button::$ICONIC);
$button ->setIcon("fa fa-refresh");

$excel = new Button("", "", "Excel");
$excel ->setAction("laporan_non_aktif.excel()");
$excel ->setClass("btn-primary");
$excel ->setIsButton(Button::$ICONIC_TEXT);
$excel ->setIcon("fa fa-file-excel-o");

$pdf = new Button("", "", "PDF");
$pdf ->setAction("laporan_non_aktif.pdf()");
$pdf ->setClass("btn-primary");
$pdf ->setIsButton(Button::$ICONIC_TEXT);
$pdf ->setIcon("fa fa-file-pdf-o");

$laporan_non_aktif = new MasterSlaveTemplate($db, "smis_rg_patient", "registration", "laporan_non_aktif");
$responder = new PasienNonAktifResponder($laporan_non_aktif->getDBtable(),$laporan_non_aktif->getUItable(),$laporan_non_aktif->getAdapter());
$laporan_non_aktif ->setDBresponder($responder);

$uitable = $laporan_non_aktif->getUItable();
$uitable ->setAction(true);
$uitable ->setDelButtonEnable(false);
$uitable ->setEditButtonEnable(false);
$uitable ->setAddButtonEnable(false);
$uitable ->setPrintButtonEnable(false);
$uitable ->setReloadButtonEnable(false);
$uitable ->setAction(false);
$uitable ->setFooterVisible(false);

if($laporan_non_aktif  ->getDBResponder()->isView()  || $laporan_non_aktif  ->getDBResponder()->isExcel() || $laporan_non_aktif  ->getDBResponder()->is('pdf')){
    $laporan_non_aktif  ->getDBtable()
                        ->setShowAll(true)
                        ->setOrder(" deleted_date ASC ")
                        ->addCustomKriteria(" prop "," ='del' ")
                        ->setRealDelete(true)
                        ->setDelete(true);

    if($_POST['dari']!=""){
        $laporan_non_aktif  ->getDBtable()->addCustomKriteria(" deleted_date >","='".$_POST['dari']."'");
    }
    if($_POST['sampai']!=""){
        $laporan_non_aktif  ->getDBtable()->addCustomKriteria(" deleted_date <","='".$_POST['sampai']."'");
    }
    
}

$header  = array("No.","Tanggal Arsip","No. RM","Nama Pasien","Tanggal Lahir","Petugas");
$uitable ->setHeader($header);

$adapter = new SimpleAdapter();
$adapter ->setUseNumber(true, "No.","back.");
$adapter ->add("Tanggal Arsip", "deleted_date","date d M Y")
		 ->add("No. RM", "nrm")
         ->add("Nama Pasien", "nama")
         ->add("Petugas", "deleted_by")
         ->add("Tanggal Lahir", "tgl_lahir","date d M Y");

$laporan_non_aktif  ->setAdapter($adapter);
$laporan_non_aktif  ->addViewData("dari", "dari");
$laporan_non_aktif  ->addViewData("sampai", "sampai");
if($laporan_non_aktif->getDBResponder()->isPreload()){

    $laporan_non_aktif  ->addFlag("dari", "Dari", "Silakan Pilih Dari")
                        ->addFlag("sampai", "Sampai", "Silakan Pilih Sampai")
					->addNoClear("dari")
					->addNoClear("sampai")
					->setDateEnable(true)
					->getUItable()
					->addModal("dari", "date", "Dari", "")
					->addModal("sampai", "date", "Sampai", "");

    $laporan_non_aktif  ->getForm()
                    ->addElement("", $button)
                    ->addElement("", $pdf)
                    ->addElement("", $excel);

}

$laporan_non_aktif->initialize();