Date.prototype.addDays = function(days) {
    var date = new Date(this.valueOf());
    date.setDate(date.getDate() + days);
    return date;
}
$(document).ready(function(){
    history_pcare.doview = function(){
        var s = $("#history_pcare_tanggal_pcare").val();
        var c = $("#history_pcare_tanggal_pcare_sampai").val();
        var u = $("#history_pcare_unitkerja").val();
        if(u.trim()==""){
            showWarning("Pilih Unit Kerja","Silakan Pilih unit kerja terlebih dahulu !!");
            return;
        }
        if(s!="" && c!=""){
            var ds = s.split("-");
            var dc = c.split("-");

            var startDate = new Date(Number(ds[2]),Number(ds[1])-1,Number(ds[0]),0,0,0,0); 
            var stopDate = new Date(Number(dc[2]),Number(dc[1])-1,Number(dc[0]),0,0,0,0); 
            var dateArray = new Array();
            var currentDate = startDate;

            while (currentDate <= stopDate) {
              dateArray.push(currentDate);
              currentDate = currentDate.addDays(1);
            }

            smis_loader.showLoader();
            $("#"+history_pcare.prefix+"_list").html("");
            history_pcare.xview_loop(0,dateArray,0);
            
        }
    };

    history_pcare.xview_loop = function(current,dateArray,total){
        if(current>=dateArray.length){
            smis_loader.hideLoader();
            return;
        }
        var total_data  = dateArray.length;
        var self		= this;
        var view_data	= this.getViewData();
        var dt =  dateArray[current];

        var year = dt.getFullYear();
        var month = dt.getMonth()+1;
        var tdate = dt.getDate();

        var xdate = tdate>9?(tdate+""):("0"+tdate);
        var xmonth = month>9?(month+""):("0"+month);

        current++;
        view_data['tanggal_pcare']  = xdate+"-"+xmonth+"-"+year;
        view_data['unitkerja']  = $("#history_pcare_unitkerja").val();
        smis_loader.updateLoader('true',"Processing "+view_data['tanggal_pcare'] +"... [ "+current+" / "+total_data+" ] ",current*100/total_data);
        
        view_data['total']          = total;
        console.log(view_data['tanggal_pcare']);
        
        
        //showLoading();
        $.post('',view_data,function(res){
            var json=getContent(res);
            if(json==null) {
                
            }else{
                total = Number(json.total);
                $("#"+self.prefix+"_list").append(json.list);
                setTimeout(function(){
                    history_pcare.xview_loop(current,dateArray,total);
                },500);
            }
            
            //dismissLoading();
        });
        return this;
    };


});