/**
 * this page used to control and registration
 * of patient BPJS so usign VClaim system
 * 
 * @author      : Nurul Huda
 * @since       : 17 Feb 2018
 * @license     : LGPv2
 * @copyright   : goblooge@gmail.com
 * @version     : 1.0.1
 * @used        : registration/resource/php/registration_patient/cek_vklaim.php
 * 
 */
var cek_vklaim;
var cek_vklaim_icd;
$(document).ready(function(){
    $(".mydatetime").datetimepicker({minuteStep:1});    
    $("#cek_vklaim_no_bpjs, #cek_vklaim_no_ktp ").keyup(function(e){ 
        var code = e.which;
        if(code==13)e.preventDefault();
        if(code==32||code==13||code==188||code==186){
            cek_vklaim.fetch_server();
        }
    });
    
    cek_vklaim = new TableAction("cek_vklaim","registration","cek_vklaim");
    cek_vklaim.fetch_server=function(){
        $("#cek_vklaim_noSEP").val("");
        data            = this.getRegulerData();
        data['no_bpjs'] = $("#cek_vklaim_no_bpjs").val();
        data['no_ktp']  = $("#cek_vklaim_no_ktp").val();
        data['command'] = "cek_vklaim";
        
        if(data['no_bpjs']=="" && (data['no_ktp']=="" || data['no_ktp']=="-") ){
            showWarning("Terjadi Kesalahan !!!","Masukan No. BPJS atau No. KTP, jika No. BPJS terisi No. KTP tidak dihiraukan");
        }
        
        showLoading();
        $.post("",data,function(res){
              var json  = getContent(res);
              $("#cek_vklaim_page").html(json.table);
              cek_vklaim.reset_part();
              if(json.raw != null && json.raw.status=="AKTIF"){
                  $("#cek_vklaim_noKartu").val(json.raw.nobpjs);
                  $("#cek_vklaim_no_ktp").val(json.raw.nik);
                  $("#cek_vklaim_no_bpjs").val(json.raw.nobpjs);
                  $("#cek_vklaim_ppkRujukan").val(json.raw.kd_provider);
              }
              dismissLoading();
        });
    };
    
    cek_vklaim.cek_rujukan=function(){
        $("#cek_vklaim_noSEP").val("");
        data                = this.getRegulerData();
        data['noRujukan']   = $("#cek_vklaim_noRujukan").val();
        data['noBPJS']      = $("#cek_vklaim_no_bpjs").val();
        data['command']     = "cek_rujukan";
        
        if(data['noBPJS']=="" && data['noRujukan']=="" ){
            showWarning("Terjadi Kesalahan !!!","Silakan Isikan Nomor Rujukanya atau Nomor BPJS Terlebih Dahulu, kemudian tekan enter atau Klik Tombol Pencarian Rujukan");
        }
        
        showLoading();
        $.post("",data,function(res){
              var json      = getContent(res);
              $("#cek_vklaim_noRujukan").val(data['noRujukan']);
              if(json.message=="Data Ditemukan"){
                  cek_vklaim.reset_part();
                  $("#cek_vklaim_no_bpjs").val(json.nobpjs);     
                  $("#cek_vklaim_noKartu").val(json.nobpjs);                  
                  $("#cek_vklaim_tglRujukan").val(json.tgl_kunjungan);
                  $("#cek_vklaim_ppkRujukan").val(json.kd_provider);
                  $("#cek_vklaim_diagAwal").val(json.kode_diagnosa);
                  $("#cek_vklaim_poliTujuan").val(json.kd_poli);
                  $("#cek_vklaim_catatan").val(json.catatan);
                  $("#cek_vklaim_noRujukan").val(json.no_kunjungan);
                  $("#cek_vklaim_catatan").val(json.catatan);
                  $("#cek_vklaim_no_ktp").val(json.nik);
                  $("#cek_vklaim_asalRujukan").val(json.asal_rujukan);                  
                  if(json.kd_poli!=null && json.kd_poli!=""){
                    $("#cek_vklaim_jnsPelayanan").val(2);
                  }else{
                    $("#cek_vklaim_jnsPelayanan").val(1); 
                  }
                  $("#cek_vklaim_jnsPelayanan").trigger("change");
              }else{
                  showWarning("Terjadi Kesalahan !!!",json.message);
              }
              dismissLoading();
        });
    };
    
    cek_vklaim.reset=function(){
        $("#cek_vklaim_noSEP").val("");
        $("#cek_vklaim_no_ktp").val(""); 
        $("#cek_vklaim_noMr").val("");
        $("#cek_vklaim_noTelp").val("");
        cek_vklaim.reset_part();
    };
    
    cek_vklaim.reset_part=function(){
        var currentdate = new Date(); 
        var month       = (currentdate.getMonth()+1);
        if(month<10){
                month   = "0"+month;
        }        
        var dt          = currentdate.getDate();
        if(dt<10){
                dt      = "0"+dt;
        }        
        var hour        = currentdate.getHours();
        if(hour<10){
                hour    = "0"+hour;
        }        
        var minute      = currentdate.getMinutes();
        if(minute<10){
                minute  = "0"+minute;
        }        
        var second      = currentdate.getSeconds();
        if(second<10){
                second  = "0"+second;
        }        
        var datetime    = currentdate.getFullYear() + "-" + month + "-" + dt + " "+ hour + ":" + minute + ":"+ second;         
        $("#cek_vklaim_noKartu").val("");
        $("#cek_vklaim_no_bpjs").val("");
        $("#cek_vklaim_tglSep").val(datetime);
        $("#cek_vklaim_tglRujukan").val(datetime);
        $("#cek_vklaim_noRujukan").val("");
        $("#cek_vklaim_ppkRujukan").val("");
        $("#cek_vklaim_jnsPelayanan").val("");
        $("#cek_vklaim_diagAwal").val("");
        $("#cek_vklaim_poliTujuan").val("");
        $("#cek_vklaim_klsRawat").val("");
        $("#cek_vklaim_lakaLantas").val("");
        $("#cek_vklaim_lokasiLaka").val("");
        $("#cek_vklaim_catatan").val("");
        $("#cek_vklaim_noREG").val("");
        $("#cek_vklaim_penjamin").val("");
        $("#cek_vklaim_cob").val("");
        $("#cek_vklaim_eksekutif").val("");
        $("#cek_vklaim_asalRujukan").val("");        
    };
    
     cek_vklaim.print_sep=function(){
         var nosep      = $("#cek_vklaim_noSEP").val();
         if(nosep==""){
            showWarning("Peringatan !!!","Silakan Masukan Nomor BPJS Terlebih dahulu, pastikan pasien aktif, kemudian create SEP baru registrasi.");
            return;
        }
         data           = this.getRegulerData();
         data['nosep']  = nosep;
         data['action'] = "print_vklaim";
         showLoading();
         $.post("",data,function(res){
             var json=getContent(res);
             smis_print(json);
             dismissLoading();
         });
     };
     
     cek_vklaim.sep_sementara=function(){
         var self                       = this;
         bootbox.confirm("SEP Sementara tidak terhubung dengan SIM SEP BPJS, Hanya Dipakai ketika Jaringan BPJS Bermasalah dan harus diinput ulang oleh petugas maksimal 3 hari", function(result){ 
            if(result){
                data                    = self.getRegulerData();
                data['tanggal']         = $("#"+self.prefix+"_tglSep").val();
                data['no_bpjs']         = $("#"+self.prefix+"_no_bpjs").val()==""?$("#"+self.prefix+"_no_bpjs").val():$("#"+self.prefix+"_noKartu").val();
                data['no_rujukan']      = $("#"+self.prefix+"_noRujukan").val();
                data['no_ktp']          = $("#"+self.prefix+"_no_ktp").val();
                data['nrm']             = $("#"+self.prefix+"_noMr").val();
                data['poli_tujuan']     = $("#"+self.prefix+"_poliTujuan option:selected").text();;
                data['diagnosa_awal']   = $("#"+self.prefix+"_diagAwal").val();
                data['catatan']         = $("#"+self.prefix+"_catatan").val();
                data['jns_rawat']       = $("#"+self.prefix+"_jnsPelayanan option:selected").text();
                data['kasus_laka']      = $("#"+self.prefix+"_lakaLantas option:selected").text();
                data['lokasi_laka']     = $("#"+self.prefix+"_lokasiLaka").val();;
                data['action']          = "print_sep_sementara";
                showLoading();
                $.post("",data,function(res){
                    var json            = getContent(res);
                    smis_print(json);
                    dismissLoading();
                });
            }
        });
     };
     
    cek_vklaim.register_pasien_bpjs=function(){
        var nosep   = $("#"+this.prefix+"_noSEP").val();
        var noreg   = $("#"+this.prefix+"_noREG").val();
        var nrm     = $("#"+this.prefix+"_noMr").val();
        var nobpjs  = $("#"+this.prefix+"_noKartu").val();
        var kelas   = $("#"+this.prefix+"_klsRawat").val();
        if(nosep==""){
            showWarning("Peringatan !!!","Silakan Masukan Nomor BPJS Terlebih dahulu, pastikan pasien aktif, kemudian create SEP baru registrasi.");
            return;
        }        
        if(noreg=="0"){
            daftar_pasien.show_add_form_nosep(nrm,nosep,nobpjs,kelas);
        }else{
            daftar_pasien.edit_nosep(noreg,nosep,nobpjs,kelas);    
        }
    };
    
    cek_vklaim.cek_nomor_rm=function(id_pasien,nrm,ktp,telpon){
        cek_vklaim.reset();
        $("#cek_vklaim_id_pasien").val(id_pasien);
        $("#cek_vklaim_noMr").val(nrm);
        $("#cek_vklaim_no_ktp").val(ktp);
        $("#cek_vklaim_noTelp").val(telpon);
        $("#cek_vklaim_no_bpjs").val("");
        if(ktp=="" || ktp=="-"){
            var data        = this.getRegulerData();
            data['nrm']     = nrm;
            data['action']  = "search_no_bpjs";
            showLoading();
            $.post("",data,function(res){
                dismissLoading();
                var json=getContent(res);
                if(json==""){
                    showWarning("No. BPJS/KTP/NIK Kosong","dikarenakan No. BPJS/KTP/NIK kosong, silakan isikan No. BPJS/KTP/NIK pasien yang bersangkutan");
                }else{
                    $("#cek_vklaim_no_bpjs").val(json);
                    $("#cek_vklaim_button").trigger("click");
                }
            });
        }else{
            $("#cek_vklaim_button").trigger("click");
        }
    };
    
    cek_vklaim.fix_register=function(){
        data            = this.getRegulerData();
        data['noSEP']   = $("#cek_vklaim_noSEP").val();
        data['noMr']    = $("#cek_vklaim_noMr").val();
        if(data['noSEP']=="" || data['noMr']==""){
            showWarning("Peringatan !!!","Silakan Bikin BPJS SEP terlebih dahulu, Jika No RM kosong, silakan buka Menu Registrasi Pasien, Pilih pasienya, kemudian Tekan Opsi SEP. Pastikan No. KTP/NIK terisi untuk kemudahan");
            return;
        }        
        data['command'] = "fix_register";
        showLoading();
        $.post("",data,function(res){
              var json  = getContent(res);
              $("#cek_vklaim_noREG").val(json.noreg);
              dismissLoading();
        });
    };

    
    cek_vklaim.reg_sep=function(){
        $("#cek_vklaim_noSEP").val("");
        data                = this.getRegulerData();
        data['noKartu']     = $("#cek_vklaim_noKartu").val();
        data['tglSep']      = $("#cek_vklaim_tglSep").val();
        data['tglRujukan']  = $("#cek_vklaim_tglRujukan").val();
        data['noRujukan']   = $("#cek_vklaim_noRujukan").val();
        data['ppkRujukan']  = $("#cek_vklaim_ppkRujukan").val();
        data['ppkPelayanan']= $("#cek_vklaim_ppkPelayanan").val();
        data['jnsPelayanan']= $("#cek_vklaim_jnsPelayanan").val();
        data['diagAwal']    = $("#cek_vklaim_diagAwal").val();
        data['poliTujuan']  = $("#cek_vklaim_poliTujuan").val();
        data['klsRawat']    = $("#cek_vklaim_klsRawat").val();
        data['lakaLantas']  = $("#cek_vklaim_lakaLantas").val();
        data['lokasiLaka']  = $("#cek_vklaim_lokasiLaka").val();
        data['catatan']     = $("#cek_vklaim_catatan").val();
        data['user']        = $("#cek_vklaim_user").val();
        data['noMr']        = $("#cek_vklaim_noMr").val();
        data['id_pasien']   = $("#cek_vklaim_id_pasien").val();        
        data['penjamin']    = $("#cek_vklaim_penjamin").val();
        data['cob']         = $("#cek_vklaim_cob").val();
        data['eksekutif']   = smis_get_data("#cek_vklaim_eksekutif");//$().val();
        data['asalRujukan'] = $("#cek_vklaim_asalRujukan").val();
        data['noTelp']      = $("#cek_vklaim_noTelp").val();
        data['command']     = "reg_sep";
        showLoading();
        $.post("",data,function(res){
              var json      = getContent(res);
              $("#cek_vklaim_noSEP").val(json.noSEP);
              $("#cek_vklaim_noREG").val(json.noreg);
              dismissLoading();
        });
    };
    
    $("#cek_vklaim_noRujukan").keyup(function(e){
        if (e.keyCode==13) {
            cek_vklaim.cek_rujukan();
        }
    });
    
    $("#cek_vklaim_lakaLantas").on("change",function(e){
        if( $("#cek_vklaim_lakaLantas").val()=="1"){
            $("#cek_vklaim_lokasiLaka").prop("disabled",false);
        }else{
            $("#cek_vklaim_lokasiLaka").prop("disabled",true);
            $("#cek_vklaim_lokasiLaka").val("");
        }
    });
    
    $("#cek_vklaim_jnsPelayanan").on("change",function(e){
        if( $(this).val()=="2"){
            /*rawat jalan*/
            $("#cek_vklaim_klsRawat").val("3");
            $("#cek_vklaim_klsRawat").attr('disabled','disabled');
            $("#cek_vklaim_poliTujuan").removeAttr('disabled');
        }else{
            /*rawat inap*/
           $("#cek_vklaim_klsRawat").val("");
           $("#cek_vklaim_klsRawat").removeAttr('disabled');
           $("#cek_vklaim_poliTujuan").val("");
           $("#cek_vklaim_poliTujuan").attr('disabled','disabled');
        }
    });
    
    cek_vklaim_icd=new TableAction("cek_vklaim_icd","registration","cek_vklaim",new Array());
    cek_vklaim_icd.setSuperCommand("cek_vklaim_icd");
    cek_vklaim_icd.selected=function(json){
        var kode=json.icd;		
        $("#cek_vklaim_diagAwal").val(kode);
    };
});