<?php 

function bpjs_print_format(Database $db,$nosep,$res){
    $tp=new TablePrint("sep_table");
    $tp->setMaxWidth(false);
    $tp->setDefaultBootrapClass(false);
    
    $tp->addColumn("<img src='registration/resource/image/bpjs-logo.png' id='logo_bpjs' />",3,2);
    if(getSettings($db,"reg-bpjs-print-logo","0")=="1"){
        $logo=getLogo();
        $tp->addColumn("<div id='title_bpjs'>SURAT ELEGIBILITAS PESERTA</div><div id='sub_title_bpjs'>".getSettings($db,"smis_autonomous_title","")."</div>",5,1);
        $tp->addColumn("<img src='".$logo."' id='logo_system' />",2,2);
        $tp->commit("header");
    }else{
        $tp->addColumn("<div id='title_bpjs'>SURAT ELEGIBILITAS PESERTA</div><div id='sub_title'>".getSettings($db,"smis_autonomous_title","")."</div>",7,1);
        $tp->commit("header");
    }
    
    $tp->addColumn("No.SEP",1,1)
       ->addColumn(":",1,1)
       ->addColumn("<strong><big>".$nosep."</big></strong>",8,1)
       ->commit("body");
       
    $tp->addColumn("Tgl SEP",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Tanggal SEP'],3,1)
       ->addSpace(5,1)
       ->commit("body");
    
    $tp->addColumn("No Kartu",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['No BPJS'],3,1)
       ->addColumn("Peserta",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Jenis Peserta'],3,1)
       ->commit("body");
       
    $tp->addColumn("Nama Peserta",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Nama'],3,1)
       ->addSpace(5,1)
       ->commit("body");
       
    $tp->addColumn("Tgl Lahir",1,1)
       ->addColumn(":",1,1)
       ->addColumn(ArrayAdapter::format("date d M Y",$res['Tanggal Lahir']),3,1)
       ->addColumn("COB",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Status COB'],3,1)
       ->commit("body");
    
    $tp->addColumn("Jns Kelamin",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['L/P'],3,1)
       ->addColumn("Jns Rawat",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Jenis Pelayanan'],3,1)
       ->commit("body");
    
    $tp->addColumn("Poli Tujuan",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Poli Tujuan'],3,1)
       ->addColumn("No. Telp",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['No. Telp'],3,1)
       ->commit("body");
    
    $tp->addColumn("Asal Rujukan",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Provider Rujukan'],3,1)
       ->addColumn("Kls Rawat",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Kelas'],3,1)
       ->commit("body");
    
    $tp->addColumn("Diagnosa Awal",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Diagnosa Awal'],3,1)
       ->addSpace(5,1)
       ->commit("body");
    
    $tp->addColumn("Catatan",1,1)
       ->addColumn(":",1,1)
       ->addColumn($res['Catatan'],3,1)
       ->addColumn("Pasien/",3,1)
       ->addColumn("Petugas",2,1)               
       ->commit("body");
    
    $tp->addSpace(5,1)
       ->addColumn("Keluarga Pasien",3,1)
       ->addColumn("BPJS Kesehatan",2,1)
       ->commit("body");
    
    $tp->addColumn("<small>*saya menyetujui bpjs kesehatan menggunakan informasi medis jika diperlukan</small>",5,1)
       ->addSpace(5,1)
       ->commit("body");
    
    $tp->addColumn("<small>*SEP bukan sebagai penjaminan peserta </small>",5,1)
       ->addSpace(5,1)
       ->commit("body");
       
    $tp->addColumn("<small>cetakan ke 1 - ".date("d-m-Y H:i:s")."</small>",5,1)
       ->addColumn("_______________",3,1)
       ->addColumn("_______________",2,1)
       ->commit("body");
    
    $tp->addColumn("<strong><big>".$nosep."</big></strong>",10,1)
       ->commit("body");
       
    $css=getSettings($db,"reg-bpjs-vclaim-print-css","");
    return $tp->getHtml().$css;
}

?>