<?php 

function bpjs_array_adapter($data){
    $res=array();
    $res['Nama']=$data['response']['peserta']['nama'];
    $res['NIK/No.KTP']=$data['response']['peserta']['nik'];
    $res['No BPJS']=$data['response']['peserta']['noKartu'];
    $res['L/P']=$data['response']['peserta']['sex'];
    $res['Kelas']=$data['response']['peserta']['kelasTanggungan']['nmKelas'];
    $res['Umur']=$data['response']['peserta']['umur']['umurSekarang'];
    $res['Jenis Peserta']=$data['response']['peserta']['jenisPeserta']['nmJenisPeserta'];
    $res['Jenis Pelayanan']=$data['response']['jnsPelayanan'];
    $res['PISA']=$data['response']['peserta']['pisa'];            
    $res['Diagnosa Awal']=$data['response']['diagAwal']['kdDiag']." - ".$data['response']['diagAwal']['nmDiag'];
    $res['Informasi Dinsos']=$data['response']['peserta']['informasi']['dinsos'];
    $res['Informasi Iuran']=$data['response']['peserta']['informasi']['iuran'];
    $res['Informasi SKTM']=$data['response']['peserta']['informasi']['noSKTM'];
    $res['Informasi PRB']=$data['response']['peserta']['informasi']['prolanisPRB'];
    $res['Tanggal Lahir']=$data['response']['peserta']['tglLahir'];
    $res['Tanggal Daftar']=$data['response']['peserta']['tglTMT'];
    $res['Tanggal TAT']=$data['response']['peserta']['tglTAT'];
    $res['Tanggal Cetak Kartu']=$data['response']['peserta']['tglCetakKartu'];      
    
    $res['Provider Umum']=$data['response']['peserta']['provUmum']['nmProvider']." - ".$data['response']['peserta']['provUmum']['kdProvider'];
    $res['Provider Rujukan']=$data['response']['provRujukan']['nmProvider']." - ".$data['response']['provRujukan']['kdProvider'];
    $res['Provider Pelayanan']=$data['response']['provPelayanan']['nmProvider']." - ".$data['response']['provPelayanan']['kdProvider'];
    $res['Poli Tujuan']=$data['response']['poliTujuan']['nmPoli']." - ".$data['response']['poliTujuan']['kdPoli'];
    $res['Status SEP']=$data['response']['statSep']['nmStatSep']." - ".$data['response']['statSep']['kdStatSep'];
    $res['Status COB']=$data['response']['statusCOB']['namaCOB']." - ".$data['response']['statusCOB']['kodeCOB'];
    
    $res['Tanggal Pulang']=$data['response']['tglPulang'];
    $res['Tanggal Rujukan']=$data['response']['tglRujukan'];
    $res['Tanggal SEP']=$data['response']['tglSep'];
    $res['Catatan']=$data['response']['catatan'];
    $res['Biaya']=ArrayAdapter::format("money Rp.",$data['response']['byTagihan']);
    
    return $res;
}

function bpjs_array_adapter_vclaim($data,$data_sep){
    $res=array();
    $res['Nama']             = $data['response']['peserta']['nama'];
    $res['No BPJS']          = $data['response']['peserta']['noKartu']." (".$data_sep['noMr'].") ";
    $res['L/P']              = $data['response']['peserta']['kelamin'];
    $res['Kelas']            = $data['response']['peserta']['hakKelas'];
    $res['Jenis Peserta']    = $data['response']['peserta']['jnsPeserta'];
    $res['Jenis Pelayanan']  = $data['response']['jnsPelayanan'];
    $res['Diagnosa Awal']    = $data['response']['diagnosa'];
    $res['Tanggal Lahir']    = $data['response']['peserta']['tglLahir'];
    $res['Poli Tujuan']      = $data['response']['poli'];
    $res['Tanggal SEP']      = $data['response']['tglSep'];
    $res['Catatan']          = $data['response']['catatan'];
    $res['Status COB']       = $data_sep['cob']=="1"?"Ya":"Tidak";
    $res['Provider Rujukan'] = $data_sep['namaRujukan']." (".$data_sep['ppkRujukan'].") ";
    $res['No. Telp']         = $data_sep['noTelp'];    
    return $res;
}

?>