<?php

class PasienVakumDBResponder extends DBResponder{
    
    public function pdf(){
        global $db;
        $this->getDBTable()->setShowAll(true);
        
        $list = $this->getDBTable()->view("","0");
        $data = $list['data'];
        $fix  = $this->adapter->getContent($data);


        $subheader = "<div class='tclass'>";
             $subheader .= "<div class='ttl'><h4>Laporan pasien yang tidak berobat selama 1 tahun terakhir</h4></div>";
             $subheader .= "<div class='ttl'><h5>Tanggal Cetak : ".ArrayAdapter::format("date d M Y",date("Y-m-d"))."</h5></div>";
        $subheader .= "</div>";
        
        $tp = new TablePrint("vakum_pasien");
        $tp ->setMaxWidth(true);


        $tp ->addColumn("<strong>No.</strong>",1,1);
        $tp ->addColumn("<strong>Tanggal</strong>",1,1);
        $tp ->addColumn("<strong>Cara Bayar</strong>",1,1);
        $tp ->addColumn("<strong>No. Register</strong>",1,1);        
        $tp ->addColumn("<strong>Layanan</strong>",1,1);
        $tp ->addColumn("<strong>No. RM</strong>",1,1);
        $tp ->addColumn("<strong>Nama Pasien</strong>",1,1);
        $tp ->addColumn("<strong>Umur</strong>",1,1);
        $tp ->commit("header");

        $no=0;
        foreach($fix as $u){
            $no++;

            $tp ->addColumn($u['No.'],1,1);
            $tp ->addColumn($u['Tanggal'],1,1);
            $tp ->addColumn($u['Cara Bayar'],1,1);
            $tp ->addColumn($u['No. Register'],1,1);        
            $tp ->addColumn($u['Layanan'],1,1);
            $tp ->addColumn($u['No. RM'],1,1);
            $tp ->addColumn($u['Nama Pasien'],1,1);
            $tp ->addColumn($u['Umur'],1,1);
            $tp ->commit("body");
        }

        require_once "smis-libs-out/mpdf-7.1.0/vendor/autoload.php";
        $mpdf = new \Mpdf\Mpdf(['format' => 'Legal-P']);
        
        $tphtml = $tp->getHtml();
        $tphtml = str_replace("<table","<table cellspacing='0'",$tphtml);

        $final = $subheader.$tphtml;

        $stylesheet = file_get_contents('registration/resource/css/vakum_pasien.css');
        $mpdf->WriteHTML("<style>".$stylesheet."</style>");
        $mpdf->WriteHTML($final); 
        $mpdf->Output("smis-temp/Laporan pasien yang tidak berobat selama 1 tahun.pdf");
        
        return "smis-temp/Laporan pasien yang tidak berobat selama 1 tahun.pdf";
    }

    public function excel() {

        $this->dbtable->setShowAll(true);
        $data = $this->dbtable->view("",0);
        $fix  = $this->adapter->getContent($data['data']);
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file = new PHPExcel ();
        
        $sheet = $file->getActiveSheet ();
        $i = 1;
        
       
       
        $sheet->mergeCells("A".$i.":H".$i)->setCellValue("A".$i, "Laporan pasien yang tidak berobat selama 1 Tahun");
        $sheet->getStyle("H".$i)->getFont()->setBold(true);
        $i++;
        $sheet->mergeCells("A".$i.":H".$i)->setCellValue("A".$i, "Tanggal Cetak : ".ArrayAdapter::format("date d M Y",date("Y-m-d")));
        $sheet->getStyle("H".$i)->getFont()->setBold(true);
        $i += 2;

        $border_start = $i;
        $sheet->setCellValue("A".$i, "No.");
        $sheet->setCellValue("B".$i, "Tanggal");
        $sheet->setCellValue("C".$i, "Cara Bayar");
        $sheet->setCellValue("D".$i, "No. Register");
        $sheet->setCellValue("E".$i, "Layanan");
        $sheet->setCellValue("F".$i, "No. RM");
        $sheet->setCellValue("G".$i, "Nama Pasien");
        $sheet->setCellValue("H".$i, "Umur");

        $sheet->getStyle("A1:H".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A1:H".$i)->getFont()->setBold(true);
        $i++;
        
        foreach($fix as $a) {
            $sheet->setCellValue("A".$i, $a["No."]." ");
            $sheet->setCellValue("B".$i, $a["Tanggal"]." ");
            $sheet->setCellValue("C".$i, $a["Cara Bayar"]." ");
            $sheet->setCellValue("D".$i, $a["No. Register"]);
            $sheet->setCellValue("E".$i, $a["Layanan"]);
            $sheet->setCellValue("F".$i, $a["No. RM"]);
            $sheet->setCellValue("G".$i, $a["Nama Pasien"]);
            $sheet->setCellValue("H".$i, $a["Umur"]);
            
            $sheet->getStyle("A".$i.":H".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $i++;
        }
        $border_end = $i - 1;
        $sheet->getStyle("A".$border_end.":H".$border_end)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        
        $thin = array ();
        $thin['borders']=array();
        $thin['borders']['allborders']=array();
        $thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
        $sheet  ->getStyle ( "A".$border_start.":H".$border_end )->applyFromArray ($thin);
        
        $filename = "Laporan pasien yang tidak berobat selama 1 tahun.xls";
        $sheet->getColumnDimension("A")->setAutoSize(true);
        $sheet->getColumnDimension("B")->setAutoSize(true);
        $sheet->getColumnDimension("C")->setAutoSize(true);
        $sheet->getColumnDimension("D")->setAutoSize(true);
        $sheet->getColumnDimension("E")->setAutoSize(true);
        $sheet->getColumnDimension("F")->setAutoSize(true);
        $sheet->getColumnDimension("G")->setAutoSize(true);
        $sheet->getColumnDimension("H")->setAutoSize(true);

        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="'.$filename.'"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
    }
}