<?php 
class PasienResponder extends DuplicateResponder{
    private $no_bpjs_enabled;
    private $no_profile_enabled;
    
    public function command($command) {
    	if ($command == "check_exist_nrm") {
    		$pack = new ResponsePackage();
    		$content = $this->check_exist_nrm();
    		$pack->setContent($content);
    		$pack->setStatus(ResponsePackage::$STATUS_OK);
    	} else if ($command == "check_max_nrm") {
    		$pack = new ResponsePackage();
    		$content = $this->check_max_nrm();
    		$pack->setContent($content);
    		$pack->setStatus(ResponsePackage::$STATUS_OK);
    	} else if ($command == "check_exist_name_address") {
    		$pack = new ResponsePackage();
    		$content = $this->check_exist_name_address();
    		$pack->setContent($content);
    		$pack->setStatus(ResponsePackage::$STATUS_OK);
    	} else if ($command == "sinkronisasi") {
    		$pack = new ResponsePackage();
    		$content = $this->synchronize();
    		$pack->setContent($content);
    		$pack->setStatus(ResponsePackage::$STATUS_OK);
    	} else{
    		return parent::command($command);
    	}    	
    	return $pack->getPackage();
    }
    
    public function setNoProfileUsability($enability){
        $this->no_profile_enabled=$enability;
        return $this;
    }
    
    public function setNoBPJSUsability($enability){
        $this->no_bpjs_enabled=$enability;
        return $this;
    }

	private $newnrm_get;
	private $lastnrm_get;


	public function logNRM($post,$baru=true){
		global $db;
		global $user;
		require_once "registration/class/RegistrationResource.php";
		$ukerja  = RegistrationResource::getUserUnitKerja();

		if($baru){
			$deskripsi = "SMIS PASIEN BARU";
			if($_POST['nrm']!=""){
				$deskripsi = "SMIS PASIEN BARU ISI MANUAL";	
				$this->lastnrm_get = "";
				$this->newnrm_get = $_POST['nrm'];
			}
		}else{
			$deskripsi = "SMIS PASIEN LAMA";
			$row = (array) $this->select($_POST['id']);
			$this->lastnrm_get = $row['nrm'];	
			$this->newnrm_get = $_POST['nrm'];
		}

		$h['id_rg_patient'] = $post['id'];
		$h['operator'] 	= $user->getUsername();
		$h['waktu'] 	= date("Y-m-d H:i:s");
		$h['deskripsi'] = $deskripsi;
		$h['nrm_asal'] 	= $this->lastnrm_get;
		$h['nrm_baru'] 	= $this->newnrm_get;
		$h['unit'] 		= $ukerja;
		$dbtable = new DBTable($db,"smis_rg_history_nrm");
		$dbtable->insert($h);

	}
	
	public function postToArray(){
		$post		= parent::postToArray();
		$db			= $this->dbtable->get_db();
		$autoformat	= getSettings($this->getDBTable()->get_db(),"reg-format-rm",0)*1;
		
		if( isset($post['id']) &&  ($post['id']=="" || $post['id']=="0" ) ){
			$post['id'] = $this->getIDPasien();
			//format NRM
			if($post['nrm']==""){
				if($autoformat==1) 		 $post['nrm'] = $this->getAutoDateNRM();
				else if($autoformat==2)  $post['nrm'] = $this->getAutoRMPartial();
				else if($autoformat==0)  $post['nrm'] = $this->getAutoIncrementNRM();
				else if($autoformat==-1) $post['nrm'] = $this->getAutoNRMSameAsID($post['id']);	
			}
			$post['origin_id'] = $post['id'];

			$this->logNRM($post,true);
		}else{
			$this->logNRM($post,false);
		}
		return $post;
	}

	private function getAutoNRMSameAsID($id){
		require_once "registration/function/prefix_unit_kerja.php";
		$prefix		= strlen(get_prefix_id_pasien());//strlen(getSettings($this->getDBTable()->get_db(),"reg-prefix-id-pasien",""));
		$format		= getSettings($this->getDBTable()->get_db(),"reg-format-id-pasien","0");
		if($format  =="1" ){
			return substr($id,$prefix);
		}else{
			return $id;
		}
	}

	private function getIDPasien(){
		require_once "registration/function/prefix_unit_kerja.php";
		$prefix		= get_prefix_id_pasien();//getSettings($this->getDBTable()->get_db(),"reg-prefix-id-pasien","");
		$format		= getSettings($this->getDBTable()->get_db(),"reg-format-id-pasien","0");
		
		if($prefix=="" || $format=="0"){
			$query 	= "SELECT MAX(id*1) FROM smis_rg_patient ";
			$id 	= $this->getDBTable()->get_db()->get_var($query)*1+1;
			return $id;
		}else{
			$query = "SELECT MAX(REPLACE(id,'".$prefix."','')*1) FROM smis_rg_patient WHERE id LIKE '".$prefix."%' ";
			$id 	= $this->getDBTable()->get_db()->get_var($query)*1+1;
			return $prefix.$id;
		}
	}
    
    private function getAutoRMPartial(){
		require_once "registration/function/prefix_unit_kerja.php";
        $this->lastnrm_get	= get_last_nrm_unitkerja();
		$this->newnrm_get 	= $this->lastnrm_get*1+1;
		//getSettings($this->getDBTable()->get_db(),"smis-reg-nrm-partial-last",0)*1+1;
        //setSettings($this->getDBTable()->get_db(),"smis-reg-nrm-partial-last",$last);
		set_last_nrm_unitkerja($this->newnrm_get);
        return $this->newnrm_get ;
	}
	
	private function getAutoIncrementNRM(){
		$query		 = "SELECT MAX(nrm*1) FROM smis_rg_patient";
		$last_number = $this->dbtable->get_db()->get_var($query);
		if($last_number==NULL){
			return (1);
		}
		return ($last_number*1)+1;
	}
	
	private function getAutoDateNRM(){
		$dt		= (date("Ym")."000")*1;
		$query	= "SELECT MAX(nrm*1) FROM smis_rg_patient WHERE nrm >".$dt."  ";
		$last_number=$this->dbtable->get_db()->get_var($query);
		if($last_number==NULL){
			return ($dt+1);
		}
		return ($last_number*1)+1;
	}
	
	public function synchronize(){
		loadLibrary("smis-libs-function-medical");
		$kriteria['id_pasien']	= $_POST['id'];
		$kriteria['selesai']	= 0;
        
		$pasien			= $this->select($_POST['id']);		
		$tanggal_lahir	= $pasien['tgl_lahir'];
		$dbtable		= new DBTable($this->getDBTable()->get_db(),"smis_rg_layananpasien");
		$dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
		$layanan		= $dbtable->select($kriteria);
		
		$start			= $tanggal_lahir;
		$end			= $layanan['tanggal'];
		$data			= array();
		$keterangan		= "";
		if($start=="" || $start=="0000-00-00"){
			$data['gol_umur']	= "TGL LAHIR TDK VALID";
			$data['umur']	= "TGL LAHIR TDK VALID";
			$keterangan	= "Tanggal Lahir Tidak Valid Sinkronisasi Data Tidak Dilakukan !! ";
		}else{
			$data['gol_umur']		= medical_gol_umur($start,$end);
			$data['umur']		= medical_umur($start,$end);
			$keterangan		= "Sinkronisasi Data Berhasil dilakukan !!, ".$data['gol_umur']." dan usia ".$data['umur'];
			$dbtable->update($data,array("id"=>$layanan['id']));
			$layanan['gol_umur'] 	= $data['gol_umur'];
			$layanan['umur']	 	= $data['umur'];
			RegistrationResource::synchronize($layanan['id']);
		}
		return $keterangan;
	}
	
	public function view(){
		$dbtable		= $this->getDBTable();
		$search_id	= trim($_POST['search_id']);
		$search_nrm	= trim($_POST['search_nrm']);
		
		$dbtable	->addCustomKriteria(" id "," LIKE '%".($search_id)."%' ")
			->addCustomKriteria(" nrm "," LIKE '%".($search_nrm)."%' ")
			->addCustomKriteria(" tanggal "," LIKE '%".$_POST['search_tanggal']."%' ")
			->addCustomKriteria(" nama "," LIKE '%".$_POST['search_nama']."%' ")
			->addCustomKriteria(" alamat "," LIKE '%".$_POST['search_alamat']."%' ")
            ->addCustomKriteria(" kelamin "," LIKE '%".$_POST['search_kelamin']."%' ")
            ->addCustomKriteria(" telpon "," LIKE '%".$_POST['search_telp']."%' ")
            ->addCustomKriteria(" faskes "," LIKE '%".$_POST['search_faskes']."%' ");		
        	if($this->no_bpjs_enabled && $_POST['search_nobpjs']!=""){
        	    	$dbtable ->addCustomKriteria(" nobpjs "," LIKE '%".$_POST['search_nobpjs']."%' ");
        	}
        	if($this->no_profile_enabled && $_POST['search_profnum']!=""){
        	    	$dbtable ->addCustomKriteria(" profile_number "," LIKE '%".$_POST['search_profnum']."%' ");
			}
			if($_POST['search_ktp']!=""){
        	    	$dbtable ->addCustomKriteria(" ktp "," LIKE '%".$_POST['search_ktp']."%' ");
        	}
         if($_POST['search_provinsi']!=" "){
             	$dbtable ->addCustomKriteria(" nama_provinsi "," LIKE '%".$_POST['search_provinsi']."%' ");
         }
	if($_POST['search_kabupaten']!=" "){
             	$dbtable ->addCustomKriteria(" nama_kabupaten "," LIKE '%".$_POST['search_kabupaten']."%' ");
         }
	if($_POST['search_kecamatan']!=" "){
             	$dbtable ->addCustomKriteria(" nama_kecamatan "," LIKE '%".$_POST['search_kecamatan']."%' ");
         }
	if($_POST['search_kelurahan']!=" "){
            	$dbtable ->addCustomKriteria(" nama_kelurahan "," LIKE '%".$_POST['search_kelurahan']."%' ");
    }
    if($_POST['search_dmht']!=""){
        $dbtable ->addCustomKriteria(" dmht "," LIKE '".$_POST['search_dmht']."' ");
    }
    if($_POST['search_origin']!=""){
        $dbtable ->addCustomKriteria(" ukerja "," = '".$_POST['search_origin']."' ");
    }
	
    if($_POST['search_panggilan']!=""){
         	$dbtable ->addCustomKriteria(" sebutan "," LIKE '".$_POST['search_panggilan']."' ");
	}
	if($_POST['search_tgl_lhr']!=""){
         	$dbtable ->addCustomKriteria(" tgl_lahir "," LIKE '".$_POST['search_tgl_lhr']."' ");
	}
		
		return parent::view();
	}
	
	public function check_exist_nrm() {
		$id = $_POST['id'] * 1;
		$row = $this->dbtable->select($id, false);
		if ($row == null)
			return false;
		return true;
	}
	
	public function check_max_nrm() {
		$id = $_POST['id'] * 1;
		$row = $this->dbtable->get_row("
			SELECT MAX(id) AS 'id_max'
			FROM " . $this->dbtable->getName() . "
		");
		return $id > $row->id_max;
	}
	
	public function check_exist_name_address() {
		$nama = $_POST['nama'];
		$alamat = $_POST['alamat'];
		$row = $this->dbtable->get_row("
			SELECT id
			FROM " . $this->dbtable->getName() .  "
			WHERE nama = '" . $nama . "' AND alamat = '" . $alamat . "'
		");
		if ($row == null)
			return false;
		return true;
	}
	
	public function edit(){
		$id=$_POST['id'];
        	$this->dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
		$row=$this->dbtable->select($id,false);
		if($row['tgl_lahir']!="0000-00-00"){
            $row['umur']=medical_umur($row['tgl_lahir'],date("Y-m-d"));
            
        	}
		return $row;
    }
    
    /**
	 * facade design pattern that used for deleting data in Database.
	 * what this function do is :
	 * 1. Get the id of data that want to be delete.
	 * 2. check wether real delete or just hide it (mean change the prop only)
	 * 3. inform the consumet whether success or fail
	 * @return number
	 */
	public function delete(){
        global $user;
		$id['id']				= $_POST['id'];
		if($this->dbtable->isRealDelete()){
			$result				= $this->dbtable->delete($id['id']);
		}else{
            $data['prop']		= "del";
            $data['deleted_by']  = $user->getNameOnly();
            $data['deleted_date']  = date("Y-m-d");
			$result				= $this->dbtable->update($data,$id);
		}
		$success['success']		= 1;
		if($result==='false') {
			$success['success']	= 0;
		}
		return $success;
	}

	public function save(){
		global $db;
        $data = $this->postToArray();
        
		
		//if(isset($_POST['kode_faskes'])){
		//	$dbtable 			=  new DBTable($db,"smis_rg_faskes");
		//	$kode_ppk 			=  $_POST['kode_faskes'];
		//	$kp 				= $dbtable->select(array("kode"=>$kode_ppk));
		//	$data['ukerja']	 	= $kp->unitkerja;	
		//}

		if($_POST['id']=="" || $_POST['id']=="0"){
			$data['ukerja']	= RegistrationResource::getUserUnitKerja();	
		}

        if(isset($data['prop']) && $data['prop']=="del"){
            global $user;
            $data['deleted_by']  = $user->getNameOnly();
            $data['deleted_date']  = date("Y-m-d");
        }

		if($_POST['tgl_lahir']=="" || $_POST['tgl_lahir']=="0000-00-00" || $_POST['tgl_lahir']=="00-00-0000"  || $_POST['tgl_lahir']=="undefined-undefined-"){
			$umur	 = $_POST['umur'];
			if($umur!=""){
				$date				= "06-30";
				$year				= date("Y");
				$year				= $year-$umur;
				$data['tgl_lahir']  = $year."-".$date;
			}
			$data['umur'] = $umur." Tahun ";
		}else{
			$data['umur'] = "";
		}
		
		$id['id']	  = $_POST['id'];
		if($_POST['id']=="" || !$this->dbtable->is_exist($id,$this->is_exist_include_del)){
			$result   = $this->dbtable->insert($data);
			$id['id'] = $data['id'];
			$success['type']='insert';
		}else {
			$result	  		 = $this->dbtable->update($data,$id);
			$success['type'] = 'update';
		}
		$success['id']		 = $id['id'];
		$success['success']	 = 1;
		if($result===false) {
			$success['success']=0;
		}
		return $success;
	}

}


?>