<?php

class PasienNonAktifResponder extends DBResponder{
    
    public function pdf(){
        global $db;
        $this->getDBTable()->setShowAll(true);
        
        $list = $this->getDBTable()->view("","0");
        $data = $list['data'];
        $fix  = $this->adapter->getContent($data);

        $subheader = "<div class='tclass'>";
             $subheader .= "<div class='ttl'><h4>Laporan Pasien Non Aktif - ".getSettings($db,"smis_autonomous_name","")."</h4></div>";
             $subheader .= "<div class='ttl'><h5>Tanggal : ".ArrayAdapter::format("date d M Y",$_POST['dari'])." s/d ".ArrayAdapter::format("date d M Y",$_POST['sampai'])."</h5></div>";
        $subheader .= "</div>";

        $tp = new TablePrint("vakum_pasien");
        $tp ->setMaxWidth(true);

        $tp ->addColumn("<strong>No.</strong>",1,1);
        $tp ->addColumn("<strong>Tanggal Arsip</strong>",1,1);
        $tp ->addColumn("<strong>No. RM</strong>",1,1);
        $tp ->addColumn("<strong>Nama Pasien</strong>",1,1);        
        $tp ->addColumn("<strong>Tanggal Lahir</strong>",1,1);
        $tp ->addColumn("<strong>Petugas</strong>",1,1);
        $tp ->commit("header");

        $no=0;
        foreach($fix as $u){
            $no++;
            $tp ->addColumn($u['No.'],1,1);
            $tp ->addColumn($u['Tanggal Arsip'],1,1);
            $tp ->addColumn($u['No. RM'],1,1);
            $tp ->addColumn($u['Nama Pasien'],1,1);        
            $tp ->addColumn($u['Tanggal Lahir'],1,1);
            $tp ->addColumn($u['Petugas'],1,1);
            $tp ->commit("body");
        }

        require_once "smis-libs-out/mpdf-7.1.0/vendor/autoload.php";
        $mpdf = new \Mpdf\Mpdf(['format' => 'Legal-P']);
        
        $tphtml = $tp->getHtml();
        $tphtml = str_replace("<table","<table cellspacing='0'",$tphtml);

        $final = $subheader.$tphtml;

        $filename = "Laporan Pasien Non Aktif ".ArrayAdapter::format("date Ymd",$_POST['dari'])." - ".ArrayAdapter::format("date Ymd",$_POST['sampai']).".pdf";

        $stylesheet = file_get_contents('registration/resource/css/vakum_pasien.css');
        $mpdf->WriteHTML("<style>".$stylesheet."</style>");
        $mpdf->WriteHTML($final); 
        $mpdf->Output("smis-temp/".$filename);
        
        return "smis-temp/".$filename;
    }

    public function excel() {

        $this->dbtable->setShowAll(true);
        $data = $this->dbtable->view("",0);
        $fix  = $this->adapter->getContent($data['data']);
        require_once ("smis-libs-out/php-excel/PHPExcel.php");
        $file = new PHPExcel ();
        
        $sheet = $file->getActiveSheet ();
        $i = 1;
       
        $sheet->mergeCells("A".$i.":F".$i)->setCellValue("A".$i, "Laporan Pasien Non Aktif - ".getSettings($db,"smis_autonomous_name",""));
        $sheet->getStyle("F".$i)->getFont()->setBold(true);
        $i++;
        $sheet->mergeCells("A".$i.":F".$i)->setCellValue("A".$i, "Tanggal : ".ArrayAdapter::format("date d M Y",$_POST['dari'])." s/d ".ArrayAdapter::format("date d M Y",$_POST['sampai']) );
        $sheet->getStyle("F".$i)->getFont()->setBold(true);
        $i += 2;

        $border_start = $i;
        $sheet->setCellValue("A".$i, "No.");
        $sheet->setCellValue("B".$i, "Tanggal Arsip");
        $sheet->setCellValue("C".$i, "No. RM");
        $sheet->setCellValue("D".$i, "Nama Pasien");
        $sheet->setCellValue("E".$i, "Tanggal Lahir");
        $sheet->setCellValue("F".$i, "Petugas");

        $sheet->getStyle("A1:F".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle("A1:F".$i)->getFont()->setBold(true);
        $i++;

        foreach($fix as $a) {
            $sheet->setCellValue("A".$i, $a["No."]." ");
            $sheet->setCellValue("B".$i, $a["Tanggal Arsip"]." ");
            $sheet->setCellValue("C".$i, $a["No. RM"]." ");
            $sheet->setCellValue("D".$i, $a["Nama Pasien"]);
            $sheet->setCellValue("E".$i, $a["Tanggal Lahir"]);
            $sheet->setCellValue("F".$i, $a["Petugas"]);
            
            $sheet->getStyle("A".$i.":F".$i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $i++;
        }
        $border_end = $i - 1;
        $sheet->getStyle("A".$border_end.":F".$border_end)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
        
        $thin = array ();
        $thin['borders']=array();
        $thin['borders']['allborders']=array();
        $thin['borders']['allborders']['style']=PHPExcel_Style_Border::BORDER_THIN ;
        $sheet  ->getStyle ( "A".$border_start.":F".$border_end )->applyFromArray ($thin);
        
        
        $sheet->getColumnDimension("A")->setAutoSize(true);
        $sheet->getColumnDimension("B")->setAutoSize(true);
        $sheet->getColumnDimension("C")->setAutoSize(true);
        $sheet->getColumnDimension("D")->setAutoSize(true);
        $sheet->getColumnDimension("E")->setAutoSize(true);
        $sheet->getColumnDimension("F")->setAutoSize(true);

        $filename = "Laporan Pasien Non Aktif ".ArrayAdapter::format("date Ymd",$_POST['dari'])." - ".ArrayAdapter::format("date Ymd",$_POST['sampai']).".xls";

        header ( 'Content-Type: application/vnd.ms-excel' );
        header ( 'Content-Disposition: attachment;filename="'.$filename.'"' );
        header ( 'Cache-Control: max-age=0' );
        $writer = PHPExcel_IOFactory::createWriter ( $file, 'Excel5' );
        $writer->save ( 'php://output' );
		return;
    }
}