<?php 

class DaftarResponder extends DuplicateResponder{
	private $pasien		= null;
	private $service_entity	= null;
	public function command($command){
		if($command=="check_baru_lama"){
			$pack	= new ResponsePackage();
			$content	= $this->baruLama();
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack ->getPackage();
		}else if($command=="dogtag"){
			$pack	= new ResponsePackage();
			$content	= $this->getResource("dogtag");
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack ->getPackage();
		}else if($command=="label"){
			$pack	= new ResponsePackage();
			$content	= $this->getResource("label");
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack->getPackage();
		}else if($command=="label_inap"){
			$pack	= new ResponsePackage();
			$content	= $this->getResource("label_inap");
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack->getPackage();
		}else if($command == "get_last_visited_data") {
			$pack 	= new ResponsePackage();
			$content = $this->getLastVisitedData();
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack->getPackage();
		} else if ($command == "b_wbpatient_print") {
			$pack 	= new ResponsePackage();
			$content	= $this->getResource("gelang_bayi");
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack->getPackage();
		} else if ($command == "a_wbpatient_print") {
			$pack 	= new ResponsePackage();
			$content	= $this->getResource("gelang_dewasa");
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack->getPackage();
		}else if ($command == "sinkronisasi") {
			$pack 	= new ResponsePackage();
			$content	= $this->synchronize();
			$pack	->setContent($content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack->getPackage();
		}else if($command=="show_history_registrasi"){
			$pack 	= new ResponsePackage();
			$content	= $this->showHistoryRegistrasi();
			$pack	->setWarning(true,"Riwayat Kunjungan Pasien",$content)
				->setStatus(ResponsePackage::$STATUS_OK)
				->setAlertVisible(false);
			return $pack->getPackage();
		}else if($command=='save' && $this->getAddCapability()){
			$pack	= $this->save();
			return $pack->getPackage();
		}else{
			return parent::command($command);
		}
		
    }
    
    public function view(){
		$kriteria			 = isset($_POST['kriteria'])?$_POST['kriteria']:""; 
		$kriteria			 = $this->dbtable->escaped_string($kriteria);
		$number				 = (isset($_POST['number']) && $_POST['number']!="")?$_POST['number']:0;
		$max				 = isset($_POST['max'])?$_POST['max']:"10";		
		$this->dbtable->setMaximum($max);		
		$d					 = $this->dbtable->view($kriteria,$number);
		$page				 = $d['page'];
		$data				 = $d['data'];
		$max_page			 = $d['max_page'];
		$this->adapter->setNumber($page*$max);
		$uidata				 = $this->adapter->getContent($data);
		$this->uitable->setContent($uidata);
		$list				 = $this->uitable->getBodyContent();
		$pagination			 = $this->uitable->getPagination($page,3,$max_page);		
		$json['list']		 = $list;
		if(!$this->debug) {
			unset($d['custom_kriteria']);
			unset($d['query']);
		}
		$json['debug']		 = $this->debug;
		$json['dbtable']	 = $d;
		if($this->include_adapter_data){
			$json['adapter'] = $uidata;
		}
		if($this->include_raw_data){
			$json['raw']	 = $data;
		}
		$json['pagination']	 = $pagination->getHtml()." <div style='width:100%;text-align:center;'><strong>Jumlah ".$d['start']." dari ".$d['total']."</strong></div>";
		$json['number']		 = $page;
		$json['number_p']	 = $number;
		return $json;
	}
	
	public function showHistoryRegistrasi(){
        $db 	=  $this->getDBTable()->get_db();

        if(isset($_POST['id'])){
            $ptable = new DBTable($db,"smis_rg_patient");
            $px = $ptable ->select($_POST['id']);
            $_POST['nrm']= $px->nrm;

        }


		require_once("smis-base/smis-include-service-consumer.php");
		$serv 	= new ServiceConsumer($db,"get_noreg_surat_sakit");
		$serv	->addData("nrm_pasien",$_POST['nrm']);
		$serv	->execute();
        $sks 	= $serv->getContent();
        
        require_once("smis-base/smis-include-service-consumer.php");
		$serv 	= new ServiceConsumer($db,"get_noreg_surat_sakit");
		$serv	->addData("nrm_pasien",$_POST['nrm']);
		$serv	->execute();
        $sks 	= $serv->getContent();
        
        $serv 	= new ServiceConsumer($db,"get_diagnosa_nrm");
		$serv	->addData("nrm_pasien",$_POST['nrm']);
		$serv	->execute();
		$diagnosa 	= $serv->getContent();

		$dbtable = new DBTable($db,"smis_rgv_layananpasien");
		$dbtable ->addCustomKriteria("nrm","='".$_POST['nrm']."' ")
				 ->setOrder(" tanggal DESC ",true)
				 ->setShowAll(true);
		$data 	 = $dbtable->view("","0");
		$list	 = $data['data'];
		
		$table   = new TablePrint("");
		$table  ->setDefaultBootrapClass(true)
			->setMaxWidth(false);
		
		$table  ->addColumn("RIWAYAT KUNJUNGAN",4,1)
			->commit("title");
		$table  ->addColumn("No. ",1,1)
				->addColumn("Tanggal ",1,1)
				->addColumn("Tujuan ",1,1)
                ->addColumn("Dokter ",1,1)
                ->addColumn("Diagnosa ",1,1)
				->addColumn("Surat Sakit",1,1)
				->commit("title");
		$no     = 1;
		foreach($list as $x){
            $ss = "";
            $diagn = "";
			if(strpos($sks,"[".$x->id."]")!==false){
				$ss = "<i class='fa fa-check'></i>";
            }
            if(isset($diagnosa[$x->id])){
				$diagn = $diagnosa[$x->id];
			}
			$table  ->addColumn($no++,1,1)
					->addColumn(ArrayAdapter::dateFormat(" date d M Y H:i",$x->tanggal),1,1)
					->addColumn(ArrayAdapter::format("unslug",$x->jenislayanan),1,1)
                    ->addColumn($x->nama_dokter,1,1)
                    ->addColumn(trim($x->diagnosa_bpjs)==""?$diagn:$x->diagnosa_bpjs,1,1)
					->addColumn($ss,1,1)
					->commit("body");
		}
		return $table->getHtml();
	}

	/**
	 * @brief get the detail of the pastient record based on it's ID Pasien
	 * @param String $id_pasien 
	 * @return  the object or array row of the patient
	 */
	public function getPasien($id_pasien){
		if($this->pasien==null){
			$pasien_table	= new DBTable($this->getDBTable()->get_db(),'smis_rg_patient');
			$this->pasien	= $pasien_table->select($id_pasien,false);
		}
		return $this->pasien;
	}
	
	/**
	 * @brief search the last visited row of this patient
	 * 		 used for suggest to user.
	 * @return  the last visited data
	 */
	private function getLastVisitedData() {
		$id_pasien 	= $_POST['id'];
		$this->dbtable->setFetchMethode(DBTable::$ARRAY_FETCH);
		$row 		= $this->dbtable->get_row("
			SELECT *
			FROM smis_rg_layananpasien
			WHERE prop NOT LIKE 'del' AND id_pasien = '" . $id_pasien . "'
			ORDER BY id DESC
			LIMIT 0, 1
		");
		$row['last_time']=date("Y-m-d H:i:s");
		return $row;
	}
	
	/**
	 * @brief ceck wether the patient is new or old
	 * @return  old if 1 and new if 0
	 */
	private function baruLama(){
		global $db;
		$id			= $_POST['id'];
		$last			= getSettings($db, "reg-last-number", "0");
		$barulama 		= 0;
		if($id<=$last){
			$barulama	= 1;
		}else{
			$query		= "SELECT count(*) FROM smis_rg_layananpasien WHERE prop!='del' AND id_pasien='$id' ";
			$total		= $db->get_var($query);
			if($total!="0") {
				$barulama = 1;
			}
		}
		
		$dbtable = new DBTable($db,"smis_rg_patient");
		$row	 = $dbtable ->select($_POST['id']);
		$result['nrm']		= $row->nrm;
		$result['barulama']	= $barulama;
		$result['faskes']		= $row->faskes;
        $result['kode_faskes']	= $row->kode_faskes;
        $result['nobpjs']	= $row->nobpjs;
        $result['kelas_bpjs']	= $row->kelas_bpjs;
		
		if($row->kode_faskes!=""){
			$dbtable = new DBTable($db,"smis_rg_faskes");
			$fsk = $dbtable->select(array("kode"=>$row->kode_faskes));
			$result['unitkerja'] = $fsk->unitkerja;
		}else{
			$result['unitkerja'] = "";
		}
		
		return $result;
	}
	
	/**
	 * @brief used for getting snippet of simple resource
	 * for creating printing like, gelang_bayi.php, gelang_dewasa.php, label.php, dogtag.php
	 * @param String $resource 
	 * @return  String of HTML element that ready for printer.
	 */
	private function getResource($resource){
		ob_start();
		require_once "registration/snippet/".$resource.".php";
		$result=ob_get_clean();
		return $result;
	}
	
	 
	/**
	 * @brief 	this methode used for check the primary dokter 
	 * 			of this patient
	 * 			- check whether the data need to be preserver is complete
	 * 			- check the patient doesn't have the primary docter
	 * 			- check if the suggest doctor is same or not
	 * 			- if same, there will be no problem if not record the different
	 * 			- save the data
	 * @param String $nrm of patient 
	 * @param String $tanggal the datetime in YYYY-MM-DD / YYYY-MM-DD HH:ii:ss format 
	 * @return  null
	 */
	public function saveDokterUtama($nrm,$tanggal,$id_pasien){
		$db				= $this->getDBTable()->get_db();
		$dokter_utama 	= getSettings($db,"reg-activate-dokter-utama","0")=="1";
		if(	!isset($_POST['kode_du']) || !isset($_POST['suggest_du'] ) || !isset($_POST['keterangan_du']) || !isset($_POST['editable_du']) ){
			return;	
		}
		
		$save_each	= getSettings($db,"reg-activate-dokter-utama-each-time","0")=="1";
		$tanggal	= substr($tanggal,0,16);
		$dbtable	= new DBTable($db,"smis_rg_dokter_utama");
		$dbtable	->addCustomKriteria("nrm_pasien","='".$nrm."'");
		if($save_each){
			/* khusus untuk penyimpanan yang mana setiap 
			 * tanggal selesainya tidak sama, 
			 * maka disimpan. sehingga setiap dokter dapat menjadi pemilik pasien
			 * geser setiap salah satu selesai.*/
             	loadLibrary("smis-libs-function-time");
			 $tgl_selesai=addYear($tanggal,1);
			$dbtable->addCustomKriteria("selesai","='".$tgl_selesai."'");
		}else{
			/* setiap ada yang belum selesai maka tidak boleh insert baru lagi
			 * nunggu selesai dulu baru insert lagi baru */
			$dbtable->addCustomKriteria("selesai",">='".$tanggal."'");			
		}
		$dbtable->setMaximum(1);
		$dbtable->setOrder(" selesai DESC ");
		$du		= $dbtable->view("","0");
		$ddu	= $du['data'];
		if(!isset($ddu[0]) && $_POST['editable_du']=="1" ){
            		global $user;
            		loadLibrary("smis-libs-function-time");
			$keterangan="Dimasukan Melalui Menu Pendaftaran Pasien ".($save_each?"dengan mode Per Kunjungan di Aktifkan":"");
			if($_POST['kode_du']!=$_POST['suggest_du']){
				$keterangan.=" Kode Dokter Utama dari System adalah [".$_POST['suggest_du']."]";
				$keterangan.=" Tetapi di Pilih Dokter Utama Oleh Petugas adalah [".$_POST['suggest_du']."]";
			}
			
			$pasien					= $this->getPasien($id_pasien);
			$save					= array();
			$save['kode']			= $_POST['kode_du'];
			$save['nama_pasien']	= $pasien->nama;
			$save['nrm_pasien']		= $nrm;
			$save['mulai']			= $tanggal;
			$save['selesai']		= addYear(substr($tanggal,0,10),1);
			$save['petugas']		= $user->getNameOnly();
			$save['keterangan']		= $keterangan;
			$dbtable->insert($save);
		}
	}
	
    	/* every update will say that not syncronize yet */
    	public function postToArray(){
			$data			= parent::postToArray();
			if($data['id']=="" || $data['id']=="0"){

			}
			$data['synch']	= 0;
			return $data;
		}
		
		private function getAutoRegPartial(){
			require_once "registration/function/prefix_unit_kerja.php";
			global $db;
			$prefix			= get_prefix_id_pasien();//getSettings($this->getDBTable()->get_db(),"smis-reg-noreg-partial-prefix","");
			$dbtable = new DBTable($db,"smis_rg_id_layanan",array("id","prefix","kunjungan","prop"));
			$row = $dbtable->select(array("prefix"=>$prefix));
			$newid = 0;
			if($row==null){
				if($prefix==""){
					$query 	= "SELECT MAX(id*1) FROM smis_rg_layananpasien ";
					$id 	= $this->getDBTable()->get_db()->get_var($query)*1+1;
					$newid = $id;
				}else{
					$query = "SELECT MAX(REPLACE(id,'".$prefix."','')*1) FROM smis_rg_layananpasien WHERE id LIKE '".$prefix."%' ";
					$id 	= $this->getDBTable()->get_db()->get_var($query)*1+1;
					$newid = $id;
				}
				$dbtable->insert(array("kunjungan"=>$newid,"prefix"=>$prefix));
			}else{
				$newid = $row->kunjungan*1+1;
				$query 	= "SELECT count(*) as total FROM smis_rg_layananpasien WHERE id='".$prefix.$newid."' ";
				$total = $this->getDBTable()->get_db($query);
				if($total!=0){
					$query = "SELECT MAX(REPLACE(id,'".$prefix."','')*1) FROM smis_rg_layananpasien WHERE id LIKE '".$prefix."%' ";
					$id 	= $this->getDBTable()->get_db()->get_var($query)*1+1;
					$newid = $id;
				}
				$dbtable->update(array("kunjungan"=>$newid,"prefix"=>$prefix),array("prefix"=>$prefix));
			}
			return $prefix.$newid;
    	}

		private function urutTanggal(Database $db, $tanggal){
			$tanggal = substr($tanggal,0,10);
			$query   = "SELECT kunjungan as nomor FROM smis_rg_urut_kunjungan WHERE tanggal='".$tanggal."' AND prop!='del' ";
			$no_urut = $db->get_var($query)*1+1;

			$dbtable = new DBTable($db,"smis_rg_urut_kunjungan",array("tanggal","kunjungan"));
			if($no_urut==1){
				$dbtable->insert(
					array("tanggal"=>$tanggal,"kunjungan"=>$no_urut)
				);
			}else{
				$dbtable->update(
					array("tanggal"=>$tanggal,"kunjungan"=>$no_urut),array("tanggal"=>$tanggal)
				);
			}
			return $no_urut;
		}
    
	public function save(){
		$register_ganda=$this->cekRegisterGanda();
		if($register_ganda!=null){
			return $register_ganda;
		}
		$kabur	= $this->cekKabur();
		if($kabur!=null){
			return $kabur;
		}
        		$db		= $this->dbtable->get_db();
		$data	= $this->postToArray();		

		//if(isset($data['kode_ppk_tujuan'])){
		//	$dbtable 			=  new DBTable($db,"smis_rg_faskes");
		//	$kode_ppk 			=  $_POST['kode_ppk_tujuan'];
		//	$kp 				= $dbtable->select(array("kode"=>$kode_ppk));
		//	$data['unit_kerja']	= $kp->unitkerja;	
		//}

		if($_POST['id']=="" || $_POST['id']=="0"){
			$data['unit_kerja']	= RegistrationResource::getUserUnitKerja();	
		}

        $list	= $_POST['jenislayanan'];
        if(is_array($list) && count($list)==1){
            $data['jenislayanan']	= $list[0];
            $this->service_entity	= $list[0];
        }else{
            $this->service_entity	= $list;
        }
        $data['tanggal'] = $_POST['tanggal'];

		//$query			 = "SELECT * FROM smis_rg_patient WHERE id='".$_POST['id_pasien']."' AND prop!='del' ";
		//$px				 = $db->get_row($query);
		$px = $this->getPasien($_POST['id_pasien']);
		$start  		 = $px->tgl_lahir;
		$end			 = $_POST['tanggal'];
		if($start=="" || $start=="0000-00-00"){
			$data['gol_umur']	= "TGL LAHIR TDK VALID";
			$data['umur']		= "TGL LAHIR TDK VALID";
		}else{
			$data['gol_umur']	= medical_gol_umur($start,$end);
			$data['umur']		= medical_umur($start,$end);
		}
		/**pendambahan data-data lain untuk kepentingan cache */
		$data['alamat_pasien']	= $px->alamat;
		$data['nrm']			= $px->nrm;
		$data['nama_kelurahan']	= $px->nama_kelurahan;
		$data['nama_kecamatan']	= $px->nama_kecamatan;
		$data['nama_kabupaten']	= $px->nama_kabupaten;
		$data['nama_provinsi']	= $px->nama_provinsi;
		$data['nama_pasien']	= $px->nama;
		$data['kelamin']		= $px->kelamin;
		$data['telpon_pasien']	= $px->telpon;
		$data['ktp']			= $px->ktp;
		
		$id['id']	= $_POST['id'];
		if($_POST['id']=="0" || $_POST['id']==""){
            if(isset($data['id']) &&  ($data['id']=="" || $data['id']=="0")){
                $data['id'] = $this->getAutoRegPartial();
                $data['origin_id'] = $data['id'];
            }

			//$query                  = "SELECT MAX(no_urut) as nomor FROM smis_rg_layananpasien WHERE tanggal='".$_POST['tanggal']."' AND prop!='del' ";
			//$data['no_urut']        = $db->get_var($query)+1;
			$data['no_urut'] = $this->urutTanggal($this->dbtable->get_db(),$_POST['tanggal']);
			
			//$query			        = "SELECT MAX(no_kunjungan) as nomor FROM smis_rg_layananpasien WHERE id_pasien='".$_POST['id_pasien']."' AND prop!='del' ";
			//$data['no_kunjungan'] 	= $db->get_var($query)+1;
			$data['no_kunjungan'] 	= $px->no_kunjungan*1+1;
			$query = "UPDATE smis_rg_patient SET no_kunjungan=no_kunjungan+1 WHERE id= '".$px->id."' ;";
			$this->getDB()->query($query);

            global $user;
            $data['oprj']	= $user->getUsername();
			$result			= $this->dbtable->insert($data);
			$id['id']		= $data['id'];
			$success['type']	  	= 'insert';
		}else{
            $current = $this->dbtable->select($_POST['id']);
            $current_room = $current->jenislayanan;
            if($current_room!=$_POST['jenislayanan']){
                $this->pullRoom($_POST['id'],$current_room);
            }
            
			$result=$this->dbtable->update($data,$id);
			$success['type']	  	= 'update';
		}
		//$this->saveDokterUtama($data['nrm'],$_POST['tanggal'],$_POST['id_pasien']);
		$this->saveMasterPPK($_POST['id_pasien'],$_POST['kode_ppk'],$_POST['ppk_bpjs']);
		
		$success['id']			  = $id['id'];
		$success['success']		  = 1;
		if($result===false) {
            $success['success']	  = 0;
        }else{
            /* synchronize the data to server */
            require_once "registration/class/RegistrationResource.php";
            RegistrationResource::synchronizeToCashier($this->dbtable->get_db(),$success['id']);
            if($success['success']==1 && $this->isAutoSync()){
                $id=$success['id'];
                $this->notify($id,$success['type']=="insert");
            }            
            /*synchronize data to accounting*/
            RegistrationResource::synchronizeToAccounting($this->dbtable->get_db(),$success['id']);
            /*backup data for synchronize data without nrm*/
            require_once "registration/function/backup_vregister.php";
            backup_vregister($this->getDBTable()->get_db(),$success['id']);            
            /* update dan save data SEP */
            if($success['success']==1 && isset($_POST['no_sep_rj']) && $_POST['no_sep_rj']!=""){
                $this->bindingSEP($_POST['no_sep_rj'],$success['id']);
            }            
            /* save data nomor asuransi */
            $this->saveDataAsuransi();            
		}
		global $querylog;

		$this->pushTTV($success['id'],$px->nama,$px->nrm,$_POST['jenislayanan']);

		return $this->pushAntrian($success);
	}


	private function pushTTV($noreg_pasien,$nama_pasien,$nrm_pasien,$ruangan){
		global $db;
		if(isset($_POST['tinggi_badan'])){
			/**memanggil ke rekam medis */
			require_once "smis-base/smis-include-service-consumer.php";

			$nama_asuransi = "";
			if($_POST['asuransi']!=""){
				$asuransi = new DBTable($db,"smis_rg_asuransi");
				$asu = $asuransi->select($_POST['asuransi']);
				if($asu!=null){
					$nama_asuransi = $asu->nama;
				}
			}


			$ttvd = array(
				"noreg_pasien"=>$noreg_pasien,
				"ruangan"=>$ruangan,
				"nrm_pasien"=>$nrm_pasien,
				"nama_pasien"=>$nama_pasien,
				"tinggi_badan"=>$_POST['tinggi_badan'],
				"berat_badan"=>$_POST['berat_badan'],
				"lingkar_perut"=>$_POST['lingkar_perut'],
				"imt"=>$_POST['imt'],
				"sistole"=>$_POST['sistole'],
				"diastole"=>$_POST['diastole'],
				"respiratory_rate"=>$_POST['respiratory_rate'],
				"heart_rate"=>$_POST['heart_rate'],

				"nobpjs"=>$_POST['nobpjs'],
				"carabayar"=>$_POST['carabayar'],
				"asuransi"=>$nama_asuransi,
			);
			$sv= new ServiceConsumer($db,"push_ttv",$ttvd,"medical_record");
			$sv->execute();
		}
	}
	
	private function saveMasterPPK($id_pasien,$kode_faskes,$faskes){
		//todo 
		require_once "registration/class/dbtable/RGPatientTable.php";
		$db 					= $this->getDBTable()->get_db();
		$dbtable 				= new RGPatientTable($db,"smis_rg_patient",array("id","faskes","kode_faskes"));
		$update['faskes'] 		= $faskes;
		$update['kode_faskes'] 	= $kode_faskes;
		$idx['id']				= $id_pasien;
		$dbtable->update($update,$idx);
	}
    
    /**
     * @brief binding the SEP data with Registration data
     * @param string $nosep is the number of SEP 
     * @param string $noreg is the number of Registration 
     * @return  null
     */
    private function bindingSEP($nosep,$noreg){
        $dbtable=new DBTable($this->getDBTable()->get_db(),"smis_rg_sep");
        $update['noReg']=$noreg;
        $id['noSEP']=$nosep;
        $dbtable->update($update,$id);
    }


    private function pullRoom($noreg,$ruangan){
        global $db;
        require_once "smis-base/smis-include-service-consumer.php";
        $service = new ServiceConsumer($db,"del_antrian",array("noreg_pasien"=>$noreg),$ruangan);
        $service->execute();
    }

    
    /**
     * @brief dipakai untuk menyimpan data nomor asuransi
     * @return  null
     */
    private function saveDataAsuransi(){
        if(getSettings($this->getDBTable()->get_db(),"reg-activate-master-card","0")=="0"){
            return;
        }
        $data['nama_asuransi']=$_POST['nama_asuransi'];
        $data['id_asuransi']=$_POST['asuransi'];
        $data['nrm_pasien']=$_POST['nrm'];
        if($data['id_asuransi']=="" || $data['id_asuransi']=="0" || $data['nama_asuransi']=="" || $_POST['nobpjs']==""){
            return;
        }
        
        $xtable=new DBTable($this->getDBTable()->get_db(),"smis_rg_nomor_asuransi");
        if(!$xtable->is_exist($data)){
            $data['nomor_asuransi']=$_POST['nobpjs'];
            $xtable->insert($data);
        }else{
            $update['nomor_asuransi']=$_POST['nobpjs'];
            $xtable->update($update,$data);
        }
    }
	
	public function synchronize(){
		$id=$_POST['id'];
		RegistrationResource::synchronize($id);
		return "Sinkronisasi Berhasil";
    }
    
    
    public function delete(){
        global $db;
        $ptable = new DBTable($db,"smis_rg_layananpasien");
        $pendaftaran = $ptable->select($_POST['id']);
		$asuransi = $pendaftaran->asuransi;
		$asutable = new DBTable($db,"smis_rg_asuransi");
    	$asr = $asutable->select($asuransi);
		require_once "registration/function/is_pcare.php";

        if($pendaftaran->carabayar=="bpjs" && is_pcare() ){
			
			if($pendaftaran->selesai*1==1 && strpos(strtoupper($asr->nama),"BPJS KESEHATAN")!==false){
				/**tidak perlu bridging */
			}else{
				require_once "registration/class/pcare/PCarePendaftaran.php";    
				$dbtable            = new DBTable($db,"smis_rg_pcare_poli");
				$poli               = $dbtable ->select($pendaftaran->bpjs_id_poli);
				$kodePoli           = $poli->kode_poli;
				$tglDaftar          = substr($pendaftaran->tanggal,0,10);
				$tgl                = explode("-",$tglDaftar);
				$tglDaftar          = $tgl[2]."-".$tgl[1]."-".$tgl[0];
				$noUrut             = $pendaftaran->no_urut_pcare;
				$noKartu            = $pendaftaran->nobpjs;
				
				$pcare      = new PCarePendaftaran();
				$pcare->setPCareAuthorization();
				$del_bpjs = $pcare->delPendaftaran($noKartu,$tglDaftar,$noUrut,$kodePoli);
				//if(!$del_bpjs){
				//	$success['success']=0;
				//	return $success;
				//}
			}
    		
        }



		global $querylog;
        $querylog->addMessage("Trying Delete....");
        $result = parent::delete();
        $id = $_POST['id'];
        require_once "smis-base/smis-include-service-consumer.php";
        $serv = new ServiceConsumer($this->getDB(),"hapus_riwayat_kunjungan",array("noreg_pasien"=>$id));
        $serv ->execute();
		$querylog->addMessage("Hapus Riwayat Kunjungan....");
        return $result;
    }
	
	/**
	 * @brief this methode used for checking whetrer the patient 
	 * 		  ever running away from the Hospital
	 * @return  ResponsePackage
	 */
	private function cekKabur(){
		$db=$this->getDBTable()->get_db();
		$query="SELECT * FROM smis_rg_layananpasien 
				WHERE nrm='".$_POST['nrm']."' AND prop!='del' 
				AND selesai='1' AND carapulang='Kabur'";
		$row=$db->get_row($query);
		if($row!=null){
			$noreg=ArrayAdapter::format("only-digit8", $row->id);
			$package=new ResponsePackage();
			$pesan='Pasien dengan NRM '.$_POST['nrm']." Pernah Kabur dengan No Registrasi <strong>".$noreg."</strong>";
			$pesan.=" pada Tanggal Registrasi <strong>".ArrayAdapter::format("date d M Y", $row->tanggal)."</strong> ";
			$pesan.=" dan Tanggal Pulang <strong>".ArrayAdapter::format("date d M Y", $row->tanggal_pulang)."</strong>";

			$button=new Button("", "", "Reaktivasi");
			$button ->setClass("btn-primary")
					->setIsButton(Button::$ICONIC_TEXT)
					->setIcon(" fa fa-refresh")
					->setAction("daftar_pasien.reactivated('".$row->id."')");
			
			$pesan=$pesan."<div class='clear'></div> <div class='center'>".$button->getHtml()."</div> <div class='clear' id='reaktivasi'></div>";
			$package->setWarning(true, "Pendaftaran Gagal", $pesan);
			$package->setStatus(ResponsePackage::$STATUS_OK);
			$package->setContent("kabur");
			return $package;
		}
		return null;
	}
	
	/**
	 * mencegah terjadinya registrasi ganda, menghitung nomor urut, dan menghitung nomor kunjungan
	 * nomor_urut adalah nomor urut pasien hari ini.
	 * nomor_kunjungan adalah nomor berapa kali pasien ini berkunjung ke sini
	 */
	private function cekRegisterGanda(){		
		if($_POST['id']=="" || $_POST['id']=="0"){

			$tanggal = substr($_POST['tanggal'],0,10);

			$query="SELECT COUNT(*) as total FROM smis_rg_layananpasien WHERE nrm='".$_POST['nrm']."' AND id_pasien='".$_POST['id_pasien']."' AND prop!='del'  AND selesai = 0 AND DATE(tanggal) = '".$tanggal."' ;";
            $total=$this->getDBTable()->get_db()->get_var($query);
			if($total>0){
				$package=new ResponsePackage();
				$package->setContent('Pasien ini pernah didaftarkan di hari ini dengan status belum dilayani. Silahkan dicek kembali');
				$package->setStatus(ResponsePackage::$STATUS_OK);
				return $package;
			}

			/*
            if($_POST['carabayar']=="bpjs" && $_POST['asuransi']=="1"){
                $jenis_kunjungan = $_POST['jenis_kunjungan'];
                $tanggal = substr($_POST['tanggal'],0,10);
                $query="SELECT COUNT(*) as total FROM smis_rg_layananpasien WHERE nrm='".$_POST['nrm']."' AND prop!='del'  AND jenis_kunjungan = '".$jenis_kunjungan."' AND DATE(tanggal) = '".$tanggal."' ;";
                $total=$this->getDBTable()->get_db()->get_var($query);
                if($total>0){
                    $package=new ResponsePackage();
                    $package->setContent('Pasien dengan NRM '.$_POST['nrm']." Sudah Terdaftar dengan Jenis Kunjungan ".$jenis_kunjungan);
                    $package->setStatus(ResponsePackage::$STATUS_OK);
                    return $package;
                }    
            }else{
                $jenis_kunjungan = $_POST['jenis_kunjungan'];
                $query="SELECT COUNT(*) as total FROM smis_rg_layananpasien WHERE nrm='".$_POST['nrm']."' AND prop!='del' AND selesai='0'  AND jenis_kunjungan = '".$jenis_kunjungan."'";
                $total=$this->getDBTable()->get_db()->get_var($query);
                if($total>0){
                    $package=new ResponsePackage();
                    $package->setContent('Pasien dengan NRM '.$_POST['nrm']." Sudah Terdaftar dengan Jenis Kunjungan ".$jenis_kunjungan);
                    $package->setStatus(ResponsePackage::$STATUS_OK);
                    return $package;
                }    
            }*/
		}
		return null;
	}
	
	/**
	 * @brief this function used for to push the 
	 * patient list to certain room using service consumer
	 * 
	 * @return  ResponsePackage
	 */
	private function pushAntrian($datapasien){
        global $db;
		require_once 'registration/class/service/AntrianService.php';
		$pasien		     = $this->getPasien($_POST['id_pasien']);
        $this->getDBTable()->setFetchMethode(DBTable::$OBJECT_FETCH);
		$reg_pasien	     = $this->getDBTable()->select($datapasien['id'],false);
        $jenis_kunjungan = $_POST['jenis_kunjungan'];
        $dbtable = new DBTable($db,"smis_rg_jenis_kunjungan");
        $jkunj   = $dbtable ->select(array("nama"=>$jenis_kunjungan));

        

		$detail			= array();
		$detail ['alamat']	= $pasien->alamat;
		$detail ['ibu'] 		= $pasien->ibu;
		$detail ['caradatang']	= $reg_pasien->caradatang;
		$detail ['tgl_lahir']	= $pasien->tgl_lahir;
        $detail ['no_profile']  	= $pasien->profile_number;
        $detail ['no_bpjs']  	= $reg_pasien->nobpjs;
        global $querylog;
        $querylog ->addMessage(json_encode($reg_pasien));

		$alamat			= $pasien->alamat." - ".$pasien->nama_kelurahan." - ".$pasien->nama_kecamatan." - ".$pasien->nama_kabupaten." - ".$pasien->nama_provinsi;
		$service			= new AntrianService($this->getDBTable()->get_db(),$_POST['tanggal'],$pasien->nama,$_POST['nrm'],$_POST['carabayar'],$this->service_entity,$datapasien['id'],$reg_pasien->umur,$reg_pasien->gol_umur,$pasien->kelamin,$alamat,$detail);
        
		if($jkunj->keluar*1==1 || (strpos($_POST['carabayar'],"bpjs")!==false && $_POST['bpjs_tkp']=="50" ) ){
            $service->setKeluarOtomatis(true);
            $keluar = array(
                "carapulang"=>"Dipulangkan Hidup",
                "selesai"=>1,
                "tanggal_pulang"=>date("Y-m-d H:i:s")
            );
            $this->getDBTable()->update($keluar,array("id"=>$datapasien['id']));
        }
        $service->execute();

		$rp = new ResponsePackage();
		$rp->setAlertVisible(false);
		$rp->setStatus(ResponsePackage::$STATUS_OK);
		
        global $notification;
        if(is_string($this->service_entity)){  
            $response		= $service->getContent();
            $id_urut['id']		= $datapasien['id'];
            $no_urut['no_urut']	= $response['content']['nomor'];
            $this->getDBTable()->update($no_urut, $id_urut);
            
            //if($reg_pasien->no_kunjungan*1!=1){
            //    $notification->addNotification("Pasien Masuk", md5($datapasien['id']), "Pasien ".$pasien->nama." dengan NRM <strong>[ ".$_POST['nrm']." ]</strong> Masuk ke <strong>".$reg_pasien->jenislayanan."</strong>", "registration", "pasien_aktif");
            //}
	   $rp->setContent($datapasien);
	   $button = new Button("","","Cetak Antrian");
	   $button ->setClass("btn btn-primary")
		  ->setIcon("fa fa-list-alt")
		  ->setIsButton(Button::$ICONIC_TEXT)
		  ->setAction("daftar_pasien.cetak_antrian('".$datapasien['id']."')");
            $warn = "<strong >".$pasien->nama."</strong>
                     dengan NRM : <strong class='label label-inverse'>".ArrayAdapter::format("digit8",$_POST['nrm'])."</strong>
                     Berhasil di Register ke
                     <strong>".strtoupper($this->service_entity)."</strong>
                     dengan nomor Antrian
                     <strong class='badge badge-success'>".$no_urut['no_urut']."</strong> untuk Tanggal
		   <strong class='label label-info'>".ArrayAdapter::format("date d-M-Y",$_POST['tanggal'])."</strong>
		   <div class='clear'></div>";
	   if(getSettings($this->dbtable->get_db(),"reg-antrian-active","0")=="1"){
		$warn .= $button->getHtml();
	   }
        }else{
            $service->setMode(ServiceConsumer::$KEY_ENTITY);
            $full_response 	= $service->getContent();
            $warn			= "";
            $first			= true;
            foreach($full_response as $entity=>$response){
                if($first){
                    $first				= false;
                    $id_urut['id']		= $datapasien['id'];
                    $no_urut['no_urut']	= $response['content']['nomor'];                    
                    $this->getDBTable()->update($no_urut, $id_urut);
                    $rp->setContent($datapasien);
                    //if($reg_pasien->no_kunjungan*1!=1){
                    //    $notification->addNotification("Pasien Masuk", md5($datapasien['id']), "Pasien ".$pasien->nama." dengan NRM <strong>[ ".$_POST['nrm']." ]</strong> Masuk ke <strong>".$reg_pasien->jenislayanan."</strong>", "registration", "pasien_aktif");
                    //}
                }
                
                $warn.=  "	<div class='well'><strong>".$pasien->nama."</strong>
                    			dengan NRM : <strong class='label label-inverse'>".ArrayAdapter::format("digit8",$_POST['nrm'])."</strong>
                    			Berhasil di Register ke
                    			<strong>".strtoupper($entity)."</strong>
                    			dengan nomor Antrian
                    			<strong class='badge badge-success'>".$response['content']['nomor']."</strong> untuk Tanggal
                    			<strong class='label label-info'>".ArrayAdapter::format("date d-M-Y",$_POST['tanggal'])."</strong>
                    		</div>";
            }
        }
        
        if(getSettings($this->getDBTable()->get_db(),"registration-show-cashier-button","0")=="1"){
               $fastlink = new Button("","","Menuju Kasir");
			   $fastlink ->setAction("registration_patient.fast_cashier('".$datapasien['id']."');")
						 ->setIsButton(Button::$ICONIC_TEXT)
						 ->setClass("btn-primary")
						 ->setIcon(" fa fa-money");
               $warn	.= "</br></br><div class='clear'>".$fastlink->getHtml()."</div>";
        }
		$rp->setWarning(true, "Berhasil", $warn);
		return $rp;
	}
}
?>