<?php 
/**
 * this class Spesifically for Handling Response and Request to BPJS SEP Server
 * this class can handle the create SEP request, Delete , Update , Cek, and etc
 * 
 * @author      : Nurul Huda
 * @copyright   : goblooge@gmail.com
 * @version     : 1.0.3
 * @since       : 09-Feb-2017
 * @database    : - smis_rg_layananpasien
 * 
 * */

require_once "registration/class/responder/BPJSResponder.php";
class BPJSVClaimCheckerResponder extends BPJSResponder{ 

    function __construct(DBTable $dbtable,Table $uitable=NULL,ArrayAdapter $adapter=NULL){
        parent::__construct($dbtable,$uitable,$adapter);
        $this->error            = null;
        $this->response         = null;
        $this->consumer_id      = getSettings($dbtable->get_db(),"reg-bpjs-vclaim-api-cons-id","24619");
        $this->consumer_secret  = getSettings($dbtable->get_db(),"reg-bpjs-vclaim-api-cons-secret","6vOEA10FF6");
        $this->ppkPelayanan     = getSettings($dbtable->get_db(),"reg-bpjs-vclaim-api-ppk-pelayanan","1334R001");
        $this->url_base         = getSettings($dbtable->get_db(),"reg-bpjs-vclaim-api-url-base","http://dvlp.bpjs-kesehatan.go.id:8081/devwslokalrest/");
        $this->port             = getSettings($dbtable->get_db(),"reg-bpjs-vclaim-api-port",8081);
        $this->is_pcare         = false;
        $this->consumer_id      = getSettings($dbtable->get_db(),"reg-bpjs-vclaim-api-cons-id","24619");
    }
   
    public function command($command){
        if($command=="cek_vklaim"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $pack->setContent($this->cek_bpjs());
            return $pack->getPackage();
        }else if($command=="reg_sep"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $r=$this->reg_sep();
            $pack->setWarning(true,"Peberitahuan !!!",$r['msg']);
            $pack->setContent($r['response']);
            return $pack->getPackage();
        }else if($command=="fix_register"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $r=$this->fixRegister();
            $pack->setWarning(true,"Peberitahuan !!!",$r['msg']);
            $pack->setContent($r['response']);
            return $pack->getPackage();
        }else if($command=="print_vklaim"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $r=$this->print_sep();
            $pack->setContent($r);
            return $pack->getPackage();
        }else if($command=="cek_rujukan"){
            $pack=new ResponsePackage();
            $pack->setStatus(ResponsePackage::$STATUS_OK);
            $r=$this->cek_rujukan();
            $pack->setContent($r);
            return $pack->getPackage();
        }else{
           return parent::command($command);
        }
    }
    
    protected function print_sep(){
        $id     = $_POST['id'];
        $row    = $this->getDBTable()->select(array("id"=>$id));
        $nosep  = $row->noSEP;
        return $this->print_sep_nosep($nosep);
    }
    
    public function print_sep_nosep($nosep){
        $url        = $this->url_base."SEP/".$nosep;
        $metode     = "GET";
        $request    = "";
        $this->do_curl($this->port,$url,$metode,$request);
        $one        = (array) $this->dbtable->select(array("noSEP"=>$nosep));
        if ($this->error) {
          return "cURL Error #:" . $err;
        } else {
            $data   = json_decode($this->response,true);
            if($data==null ){
                return "Terjadi Kesalahan Akibat Koneksi Server BPJS";
            }else if( $data['metaData']['code']!="200" ){
                return $data['metaData']['message'];
            }else{
                global $db;
                require_once "registration/function/bpjs_array_adapter.php";
                require_once "registration/function/bpjs_print_format.php";
                $res    = bpjs_array_adapter_vclaim($data,$one);
                return bpjs_print_format($db,$nosep,$res);
            }
        }
    }

    
    
    /**
     * @brief this function used to cek whether the 
     *          BPJS account of patient is active, exist or not
     *          by using the BPJS Number OR NIK/KTP Number
     * @return  array("table"=>"HTML Table,"raw"=>array data that contains BPJS data);
     */
    public function cek_bpjs(){
        $nobpjs     = isset($_POST['no_bpjs'])?$_POST['no_bpjs']:"";
        $noktp      = isset($_POST['no_ktp'])?$_POST['no_ktp']:"";        
        $methode    = "GET";
        $request    = "";        
        if($nobpjs!=""){
            $url    = $this->url_base."Peserta/nokartu/".$nobpjs."/tglSEP/".date("Y-m-d");
        }else{
            $url    = $this->url_base."Peserta/nik/".$noktp."/tglSEP/".date("Y-m-d");
        }
       
        $this->do_curl($this->port,$url,$methode,$request);
        $data   = null;
        if ($this->error) {
            require_once "registration/function/bpjs_null.php";
            $data   = bpjs_null();
        } else {
            $response   = json_decode($this->response,true);
            if($response==null || $response['metaData']['code']!="200" ){
                require_once "registration/function/bpjs_null.php";
                $data   = bpjs_null($response['metaData']['message']);
            }else{
                require_once "registration/function/bpjs_found.php";
                $data   = bpjs_found($response);
            }
        }
        require_once "registration/function/bpjs_table_checker.php";
        $table  = bpjs_table_checker($data);
        $result = array("table"=>$table,"raw"=>$data);
        return $result;
    }
   
    
   
    /**
     * @brief this function used for creating the BPJS SEP
     *          or in other word registrating patient that used BPJS
     *          that init it's treatment
     * @return array("msg"=>"Message From BPJS Server","nosep"=>"SEP Number");  
     */
    public function reg_sep(){
        $sep            = $this->getBPJSPostData();
        $dt             = array("request"=>array("t_sep"=>$sep));
        $data           = json_encode($dt);
        $sep['noReg']   = $_POST['noReg'];
        
        $url            = $this->url_base."SEP/insert";
        $methode        = "POST";
        $request        = $data;
        $this->do_curl($this->port,$url,$methode,$request);
        if ($this->error) {
            $message    = "cURL Error #:" . $this->error;
            $nosep      = "";
            return array("msg"=>$message,"nosep"=>$nosep,"data"=>$data);
        } else {
            return $this->formateCreateSEP($this->response,$sep,$request);
        }
    }
    
    
    //khusus vclaim
    protected function getBPJSPostData(){
        $sep                            = array();
        $sep['noKartu']                 = $_POST['noKartu'];
        $sep['tglSep']                  = substr($_POST['tglSep'],0,10);
        $sep['ppkPelayanan']            = $_POST['ppkPelayanan'];
        $sep['jnsPelayanan']            = $_POST['jnsPelayanan'];
        $sep['klsRawat']                = $_POST['klsRawat'];
        $sep['noMR']                    = $_POST['noMr'];
        $sep['rujukan']                 = array();
        $sep['rujukan']['asalRujukan']  = $_POST['asalRujukan'];
        $sep['rujukan']['tglRujukan']   = substr($_POST['tglRujukan'],0,10);
        $sep['rujukan']['noRujukan']    = $_POST['noRujukan'];
        $sep['rujukan']['ppkRujukan']   = $_POST['ppkRujukan'];
        $sep['catatan']                 = $_POST['catatan'];
        $sep['diagAwal']                = $_POST['diagAwal'];
        $sep['poli']['tujuan']          = $_POST['poliTujuan'];
        $sep['poli']['eksekutif']       = $_POST['eksekutif'];
        $sep['cob']['cob']              = $_POST['cob'];
        $sep['jaminan']['lakaLantas']   = $_POST['lakaLantas'];
        $sep['jaminan']['penjamin']     = is_array($_POST['penjamin'])?implode(",",$_POST['penjamin']):$_POST['penjamin'];
        $sep['jaminan']['lokasiLaka']   = $_POST['lokasiLaka'];
        $sep['noTelp']                  = $_POST['noTelp'];
        $sep['user']                    = $_POST['user'];
        return $sep;
    }
    
    public function formateCreateSEP($response,$insertsep,$request=null){
        $json   = json_decode($response,true);
        $msg    = "";
        if($json==null  ){
            $msg    = "Pendaftaran Gagal, disebabkan Masalah Koneksi ke Server BPJS";
        }else if($json['metaData']['code']!="200"){
            $msg    = $json['metaData']['message'];
        }else{
            $msg                 = "Pendaftaran Berhasil, dengan Nomor SEP : <strong>".$json['response']['sep']['noSep']."</strong> , Tekan Tombol Cetak untuk Mencetak Form BPJS";
            $rsp['noSEP']        = $json['response']['sep']['noSep'];
            $sep                 = array();
            $sep['noKartu']      = $insertsep['noKartu'];
            $sep['tglSep']       = $insertsep['tglSep'];
            $sep['tglRujukan']   = $insertsep['rujukan']['tglRujukan'];
            $sep['asalRujukan']  = $insertsep['rujukan']['asalRujukan'];
            $sep['noRujukan']    = $insertsep['rujukan']['noRujukan'];
            $sep['ppkRujukan']   = $insertsep['rujukan']['ppkRujukan'];
            $sep['ppkPelayanan'] = $insertsep['ppkPelayanan'];
            $sep['jnsPelayanan'] = $insertsep['jnsPelayanan'];
            $sep['diagAwal']     = $insertsep['diagAwal'];
            $sep['klsRawat']     = $insertsep['klsRawat'];
            $sep['lakaLantas']   = $insertsep['jaminan']['lakaLantas'];
            $sep['lokasiLaka']   = $insertsep['jaminan']['lokasiLaka'];
            $sep['catatan']      = $insertsep['catatan'];
            $sep['user']         = $insertsep['user'];
            $sep['noMr']         = $insertsep['noMR'];
            $sep['id_pasien']    = $insertsep['id_pasien'];
            $sep['eksekutif']    = $insertsep['poli']['eksekutif'];
            $sep['poliTujuan']   = $insertsep['poli']['tujuan'];
            $sep['cob']          = $insertsep['cob'];
            $sep['noTelp']       = $insertsep['noTelp'];
            $sep['noSEP']        = $json['response']['sep']['noSep'];
            $sep['penjamin']     = is_array($_POST['penjamin'])?json_encode($_POST['penjamin']):$_POST['penjamin'];
            $sep['createBy']     = "vclaim";
            $sep['namaRujukan']  = $this->getFaskesRujukan($sep['ppkRujukan'],$sep['asalRujukan']);
            $this->getDBTable()->insert($sep);
            
            /** save telpon number */
            $idx['id']           = $sep['noMr'];
            $upx['telpon']       = $sep['noTelp'];
            $dbtable             = new DBTable($this->getDBTable()->get_db(),"smis_rg_patient");
            $dbtable             ->update($upx,$idx);

            /* binding dengan noreg dan nosep */
            $this->cekBindingBPJS($rsp,$msg);
        }
        return array("msg"=>$msg,"response"=>$rsp);
    }


    public function getFaskesRujukan($kode,$jenis){
        $url            = $this->url_base."referensi/faskes/".$kode."/".$jenis;
        $methode        = "GET";
        $this->do_curl($this->port,$url,$methode,NULL);
        if ($this->error) {
            $message    = "#".$this->error;
            return $message;
        } else {
            $json   = json_decode($this->response,true);
            if($json==null  ){
                return "#NULL";
            }else if($json['metaData']['code']!="200"){
                return  "#".$json['metaData']['message'];
            }else{
                $list = $json['response']['faskes'];
                foreach($list as $f){
                    if($f['kode']==$kode){
                        return $f['nama'];
                    }
                }
                return  "#NOT-FOUND";
            }
        }
    }
    
    /**
     * @brief untuk melakukan pengecekan ulang jika terdapat binding
     *          atau registrasi lama yang belum di pulanglan.
     * @return  array
     */
    public function fixRegister(){
        $rsp['noSEP']   = $_POST['noSEP'];
        $msg            = "";
        $this->cekBindingBPJS($rsp,$msg);        
        return array("msg"=>$msg,"response"=>$rsp);
    }
    
       
    /**
     * @brief this function to get detail of rujukan
     *          based on rujukan number.
     * @param $asal , default is empty but if there is rujukan that from puskesmas then search in rujukan rs
     * @return  array("table"=>"HTML Table,"raw"=>array data that contains BPJS data);
     */
    public function cek_rujukan($asal=""){
        $no_rujukan = isset($_POST['noRujukan'])?$_POST['noRujukan']:"";
        $nobpjs     = isset($_POST['noBPJS'])?$_POST['noBPJS']:"";        
        $methode    = "GET";
        $request    = "";
        if($no_rujukan!=""){
            $url    = $this->url_base."Rujukan/".$asal.$no_rujukan;
        }else{
            $url    = $this->url_base."Rujukan/".$asal."Peserta/".$nobpjs;
        }
        
        $this->do_curl($this->port,$url,$methode,$request);
        $data=null;
        if ($this->error) {
            require_once "registration/function/bpjs_rujukan_null.php";
            $data=bpjs_rujukan_null("Terjadi Masalah Koneksi dengan Server BPJS");
        } else {
            $response=json_decode($this->response,true);
            if($response==null || $response['metaData']['code']!="200" ){
                require_once "registration/function/bpjs_rujukan_null.php";
                if($asal==""){
                    /* try search from another RS */
                    return $this->cek_rujukan("RS/");
                }
                $data = bpjs_rujukan_null($response['metaData']['message']);
            }else{
                require_once "registration/function/bpjs_rujukan_found.php";
                $data = bpjs_rujukan_found_vclaim($response['response'],$asal);
            }
        }
        return $data;
    }
    
    
}
?>