<?php
require_once "registration/class/pcare/PCare.php";
class PCareReffSpesialis extends PCare {
	public function getRujukanSubSpesialis($subspesialis, $sarana, $tgl) {
        $url = "/spesialis/rujuk/subspesialis/" . $subspesialis . "/sarana/" . $sarana . "/tglEstRujuk/" . $tgl;
        $this->execute($url, "GET");
        
        $result = $this->getResponse();
        $json   = json_decode($result, true);
        return $json;
    }
    
    public function getRujukanKhususTHAHEM($subspesialis, $khusus,$nokartu, $tgl) {
        $url = "/spesialis/rujuk/khusus/".$khusus."/subspesialis/".$subspesialis."/noKartu/".$nokartu."/tglEstRujuk/".$tgl;
        $this->execute($url, "GET");
        $result = $this->getResponse();
        $json   = json_decode($result, true);
        return $json;
    }
    
    public function getRujukanKhususAlih($khusus,$nokartu, $tgl) {
        $url = "/spesialis/rujuk/khusus/".$khusus."/noKartu/".$nokartu."/tglEstRujuk/".$tgl;
        $this->execute($url, "GET");
        $result = $this->getResponse();
        $json   = json_decode($result, true);
        return $json;
    }

    public function getSubSpesialis($id,$kode,$nama){
        global $db;
        $this->execute("spesialis/".$kode."/subspesialis","GET");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){                    
                $total    =  $json["response"]['count']*1;
                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                if($total>0){
                    $response ->setAlertContent("Sub Spesialis Berhasil di Import",$total." Sub Spesialis Berhasil di Ambil");
                    $response ->setContent($json);
                    $list = $json['response']['list'];
                    $dbtable = new DBTable($db,"smis_rg_pcare_reff_sub_spesialis");
                    foreach($list as $x){
                        $one = array();
                        $one["nama_sub_spesialis"]  = $x['nmSubSpesialis'];
                        $one["kode_sub_spesialis"]  = $x['kdSubSpesialis'];   
                        $one["kode_poli_rujuk"]     = $x['kdPoliRujuk'];                          
                        $one["nama_spesialis"]      = $nama;
                        $one["kode_spesialis"]      = $kode;
                        $one["id_spesialis"]        = $id;     
                        $one["id_settings"]         = $this->getID();
                        $one["nama_klinik"]         = $this->getName();          
                        $dbtable ->insertOrUpdate($one,array("kode_sub_spesialis"=>$one["kode_sub_spesialis"],"kode_spesialis"=>$kode,"id_settings"=>$this->getID(),"id_spesialis"=>$id));
                    }
                }else{
                    $response ->setAlertContent("Sub Spesialis tidak ditemukan","");
                }
                return json_encode($response->getPackage());
            }else{
                if($json["response"]==null){
                    $msg      = $code; 
                }else{
                    $msg      = $field." ".$msg;    
                }

                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setAlertContent("Pesan dari Server BPJS ",$msg);
                return json_encode($response->getPackage());
            }
        }else{
            $response = new ResponsePackage();
            $response ->setStatus(ResponsePackage::$STATUS_OK);
            $response ->setAlertVisible(true);
            $response ->setAlertContent("Error Komunikasi dengan Server BPJS",$this->getError());            
            return json_encode($response->getPackage());
        }
    }
    

    public function getDataSpesialis(){
        global $db;
        $this->execute("spesialis","GET");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){                    
                $total    =  $json["response"]['count']*1;
                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                if($total>0){
                    $response ->setAlertContent("Spesialis Berhasil di Import",$total." Spesialis Berhasil di Ambil");
                    $response ->setContent($json);
                    $list = $json['response']['list'];
                    $dbtable = new DBTable($db,"smis_rg_pcare_reff_spesialis");
                    foreach($list as $x){
                        $one = array();
                        $one["nama_spesialis"]  = $x['nmSpesialis'];
                        $one["kode_spesialis"]  = $x['kdSpesialis'];     
                        $one["id_settings"]  = $this->getID();
                        $one["nama_klinik"]  = $this->getName();
                        $kriteria = array("kode_spesialis"=>$one["kode_spesialis"],"id_settings"=>$this->getID());
                        $xdata = $dbtable->select($kriteria);
                        $idnew = 0;
                        if($xdata==null){
                            $dbtable->insert($one);
                            $idnew  = $dbtable->get_inserted_id();
                        }else{
                            $dbtable->update($one,$kriteria);
                            $idnew  = $xdata->id;
                        }
                        $this->getSubSpesialis($idnew,$one["kode_spesialis"],$one["nama_spesialis"]);
                    }
                }else{
                    $response ->setAlertContent("Spesialis tidak ditemukan","");
                }
                return json_encode($response->getPackage());
            }else{
                if($json["response"]==null){
                    $msg      = $code; 
                }else{
                    $msg      = $field." ".$msg;    
                }

                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setAlertContent("Pesan dari Server BPJS ",$msg);
                return json_encode($response->getPackage());
            }
        }else{
            $response = new ResponsePackage();
            $response ->setStatus(ResponsePackage::$STATUS_OK);
            $response ->setAlertVisible(true);
            $response ->setAlertContent("Error Komunikasi dengan Server BPJS",$this->getError());            
            return json_encode($response->getPackage());
        }
    }
}