<?php 
require_once "registration/class/pcare/PCare.php";
class PCarePoli extends PCare{
    public function getPoli(){
        global $db;
        $this->execute("/poli/fktp/0/100","GET");
        $result = $this->getResponse();
        $json = json_decode($result,true);

        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){                    
                $total    =  $json["response"]['count']*1;
                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setContent($peserta);
                if($total>0){
                    $response ->setAlertContent("Poli Berhasil di Import",$total." Poli Berhasil di Ambil");
                    $list = $json['response']['list'];
                    $dbtable = new DBTable($db,"smis_rg_pcare_poli");
                    foreach($list as $x){
                        $one = array();
                        $one["kode_poli"]  = $x['kdPoli'];
                        $one["nama_poli"]  = $x['nmPoli'];
                        $one["poli_sakit"] = $x['poliSakit']?1:0;
                        $one["kode_ppk"]   = $this->getPPKPelayanan();
                        $one["id_pcare"]   = $this->getID();
                        $one["nama_pcare"] = $this->getName();                 
                        $dbtable ->insertOrUpdate($one,array("kode_poli"=>$one["kode_poli"],"id_pcare"=>$one["id_pcare"]));
                    }
                }else{
                    $response ->setAlertContent("Poli tidak ditemukan","");
                }
                return json_encode($response->getPackage());
            }else{
                if($json["response"]==null){
                    $msg      = $code; 
                }else{
                    $msg      = $field." ".$msg;    
                }

                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setAlertContent("Pesan dari Server BPJS ",$msg);
                return json_encode($response->getPackage());
            }
        }else{
            $response = new ResponsePackage();
            $response ->setStatus(ResponsePackage::$STATUS_OK);
            $response ->setAlertVisible(true);
            $response ->setAlertContent("Error Komunikasi dengan Server BPJS",$this->getError());
            return json_encode($response->getPackage());
        }
    }

    
    public function getCurrentPoli($ppk=""){
        global $db;
        $dbtable = new DBTable($db,"smis_rg_pcare_poli");
        $result = array();
        if($ppk!=""){
            $dbtable ->addCustomKriteria("kode_ppk"," ='".$ppk."' ");
            $dbtable ->setShowAll(true);
            $data = $dbtable ->view("","0");
            $result = $data['data'];
        }

        if(count($result)==0){
            /**reset ppk to default */
            $this->setPCareAuthorization();
            $dbtable ->addCustomKriteria("kode_ppk"," ='".$this->getPPKPelayanan()."' ");
            $dbtable ->setShowAll(true);
            $data = $dbtable ->view("","0");
            $result = $data['data'];
        }
        return $result;
    }

    public function getPPKtoOption($ppk=""){
        $lpoli = $this->getCurrentPoli($ppk);
        $option = new OptionBuilder();
        $option->add("","","1");
        foreach($lpoli as $x){
            $option->add($x->nama_poli,$x->id);
        }
        return $option->getContent();
    }

    public function getPPKToSelect($ppk=""){
        $option = $this->getPPKtoOption();
        $select = new Select("","",$option);
        return $select->getValue();
    }

    public function getPoliPCare($id){
        global $db;
        $dbtable = new DBTable($db,"smis_rg_pcare_poli");
        $poli    = $dbtable->select($id);
        return $poli;
    }

}