<?php 
require_once "registration/class/pcare/PCare.php";
class PCarePeserta extends PCare{

    private $hasil_asli;
    
    public function __construct(){
        $this->hasil_asli=false;
    }

    public function getDataPesertaByNoBPJS($nobpjs){
        $this->execute("peserta/".$nobpjs,"GET");
        $result = $this->getResponse();
        if($this->hasil_asli){
            return $this->prosesResponseAsli($result);    
        }
        return $this->prosesResponse($result);
    }

    public function getDataPesertaByKTP($noktp){
        $this->execute("peserta/nik/".$noktp,"GET");
        $result = $this->getResponse();
        if($this->hasil_asli){
            return $this->prosesResponseAsli($result);    
        }

        return $this->prosesResponse($result);        
    }

    public function setHasilAsli($bool){
        $this->hasil_asli = $bool;
    }

    
    private function prosesResponseAsli($result){
        return $result;        
    }

    private function prosesResponse($result){
        global $db;
        $json = json_decode($result,true);        
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){
                $peserta                = array();
                $peserta['no_bpjs']     = $json["response"]["noKartu"];
                $peserta['ktp']         = $json["response"]["noKTP"];
                $peserta['nama']        = $json["response"]["nama"];
                $peserta['jk']          = $json["response"]["sex"]=="P"?1:0;
                $peserta['tgl_lahir']   = $json["response"]["tglLahir"];
                $peserta['kelas']       = $json["response"]["jnsKelas"]['nama'];
                $peserta['kode_kelas']  = $json["response"]["jnsKelas"]['kode'];
                $peserta['telp']        = $json["response"]["noHP"];
                $peserta['aktif']       = $json["response"]["ketAktif"];
                $peserta['faskes']      = $json["response"]["kdProviderPst"]["nmProvider"];
                $peserta['kode_faskes'] = $json["response"]["kdProviderPst"]["kdProvider"];
                $peserta['pisat']       = $json["response"]["hubunganKeluarga"];

                $dbtable = new DBTable($db,"smis_rg_faskes");
                $code = $dbtable->select(array("kode"=>$peserta['kode_faskes']));
                if($code!=null){
                    $peserta['unitkerja'] = $code->unitkerja;
                }else{
                    $peserta['unitkerja'] = "";
                }

                $peserta['json']        = $json["response"];
                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setContent($peserta);
                if($peserta['aktif']=="AKTIF"){
                    $response ->setAlertContent("Pesan dari BPJS","Pasien ini Aktif");
                }else{
                    $response ->setAlertContent("Pesan dari BPJS : Pasien tidak aktif",$peserta['aktif']);
                }
                return json_encode($response->getPackage());
            }else{
                if($json["response"]==null){
                    $msg      = $code; 
                }else{
                    $field    = $json["response"][0]['field'];
                    $msg      = $json["response"][0]['message'];
                    $msg      = $field." ".$msg;    
                }

                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setAlertContent("Pesan dari Server BPJS ",$msg);
                return json_encode($response->getPackage());
            }
        }else{
            $response = new ResponsePackage();
            $response ->setStatus(ResponsePackage::$STATUS_OK);
            $response ->setAlertVisible(true);
            $response ->setAlertContent("Error Komunikasi dengan Server BPJS",$this->getError());
            return json_encode($response->getPackage());
        }
    }

}