<?php
require_once "registration/class/pcare/PCare.php";
class PCarePendaftaran extends PCare{

    private $kdProviderPeserta;
    private $tglDaftar;
    private $noKartu;
    private $kdPoli;
    private $kdTkp;
    private $kunjSakit;
    private $hasil_asli;

    public function __construct(){
        $this->hasil_asli=false;
    }
    
    public function setPCareAuthorization($ppk=""){
        global $querylog;
        global $db;
        global $user;
        $authorization = null;
        $dbtable = new DBTable($db,"smis_rg_pcare_settings");
        $default = $dbtable->select(array("df"=>"1"));
        $is_default = false;
        //$authorization = $dbtable->select(array("df"=>"1"));

        if($default!=null && ($ppk=="" || $default->code_ppk == $ppk) ){
            $is_default = true;
            $authorization = $default;
        }else{
            $authorization = $dbtable->select(array("code_ppk"=>$ppk));
            if($authorization==null){
                $authorization = $dbtable->select(array("df"=>"1"));
            }    
        }

        $this->consumer_id      = $authorization->cons_id;
        $this->consumer_secret  = $authorization->cons_secret;
        $this->ppk_pelayanan    = $authorization->code_ppk;
        $this->url_base         = $authorization->url_vclaim;
        $this->port             = $authorization->port;
        $this->userkey           = $authorization->userkey;

        if($is_default){
            $querylog->addMessage("Using Default");
            $this->pcare_username   = $user->getUserPcare();//$authorization->username;
            $this->pcare_password   = $user->getPasswordPcare();//$authorization->passcode;   
            
            if($this->pcare_username=="" || $this->pcare_password==""){
                $dbtable = new DBTable($db,"smis_adm_user");
                $uname = $user->getNameOnly();
                $uname = str_replace("(","",$uname);
                $uname = str_replace(")","",$uname);
                $uname = trim($uname);     
                $one = $dbtable->select(array("realname"=>$uname));
                if($one!=null){
                    $this->pcare_username = $one->username_pcare;
                    $this->pcare_password = $one->password_pcare;
                }
            }
            
        }else{
            $querylog->addMessage(" ====> Using RG Faskes <=====");
            require_once "registration/class/RegistrationResource.php";
            $unitkerja_user = RegistrationResource::getUserUnitKerja();
            $querylog->addMessage(" ====> UNIT KERJA : ".$unitkerja_user);
            $faskesdb = new DBTable($db,"smis_rg_faskes");
            $faskes = $faskesdb->select(array("kode"=>$ppk));
            if($faskes!=null && $faskes->unitkerja==$unitkerja_user){
                $querylog->addMessage(" FASKES ====> ".json_encode($faskes));
                $querylog->addMessage(" UNITKERJA VS FASKES ====> ".$faskes->unitkerja." ".$unitkerja_user);
                
                $this->pcare_username   =  $user->getUserPcare();
                $this->pcare_password   =  $user->getPasswordPcare();
            }else{
                $querylog->addMessage(" FASKES ($ppk) ====> ".json_encode($faskes));
                $querylog->addMessage(" FASKES NULL PAKAI DEFAULT ====> ".$faskes->unitkerja);
                $this->pcare_username   = $authorization->username;
                $this->pcare_password   = $authorization->passcode;        
            }
        }
        
        $this->pcare_code       = "095";
        $this->id_pcare         = $authorization->id;
        $this->name_pcare       = $authorization->klinik;

        
    }

    public function setUsernamePassword($username,$passcode){
        $this->pcare_username   = $username;
        $this->pcare_password   = $passcode;    
    }

    public function delPendaftaran($nokartu,$tglDaftar,$noUrut,$kdPoli){
        $this->execute("pendaftaran/peserta/$nokartu/tglDaftar/$tglDaftar/noUrut/$noUrut/kdPoli/$kdPoli","DELETE",array());
        $result  = $this->getResponse();
        $json = json_decode($result,true);
        $message = $json['metaData']['code']*1;
        global $querylog;
        $querylog->addMessage("pendaftaran/peserta/$nokartu/tglDaftar/$tglDaftar/noUrut/$noUrut/kdPoli/$kdPoli");
        $querylog->addMessage($result);
        if($message==200 || $message==304){
            return true;
        }
        return false;
    }

    public function setHasilAsli($bool){
        $this->hasil_asli = $bool;
    }

    public function addPendaftaran(){
        $request = $this->getDataPendaftaran();
        $this->execute("pendaftaran","POST",$request);


        $result  = $this->getResponse();
        file_put_contents("smis-temp/add-pendaftaran.json",json_encode($request) );
        if($this->hasil_asli){
            return $result;
        }
        
        $json = json_decode($result,true);        
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="CREATED"){
                $noUrut = $json["response"]['message'];
                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setAlertContent("Pendaftaran ke PCare Telah Berhasil dengan nomor urut ".$noUrut,$noUrut);
                $ctx = array(
                    "no_urut"=>$noUrut,
                    "code"=>$code
                );
                $response ->setContent($ctx);
                return json_encode($response->getPackage());
            }else{
                if($json["response"]==null){
                    $msg      = $code; 
                }else if(is_array($json["response"]) ){
                    $field    = $json["response"][0]['field'];
                    $msg      = $json["response"][0]['message'];
                    $msg      = $field." ".$msg;    
                }else{
                    $msg = $json["response"];
                }
                $response = new ResponsePackage();
                $response ->setStatus(ResponsePackage::$STATUS_OK);
                $response ->setAlertVisible(true);
                $response ->setAlertContent("Pesan dari Server BPJS ",$msg);

                $ctx = array(
                    "no_urut"=>"",
                    "code"=>"FAILED"
                );
                if(strpos($msg,"INTERNAL_SERVER_ERROR")!==false){
                    /**mengakali internal server error tetap jalan*/
                    $ctx = array(
                        "no_urut"=>"0",
                        "code"=>"CREATED"
                    );
                }

                $response ->setContent($ctx);
                return json_encode($response->getPackage());
            }
        }else{
            $response = new ResponsePackage();
            $response ->setStatus(ResponsePackage::$STATUS_OK);
            $response ->setAlertVisible(true);
            $response ->setAlertContent("Error Komunikasi dengan Server BPJS",$this->getError());
            $ctx = array(
                "no_urut"=>"",
                "code"=>"FAILED"
            );
            $response ->setContent($ctx);
            return json_encode($response->getPackage());
        }
    }

    public function setNoKartu($nokartu){
        $this->noKartu = $nokartu;
        return $this;
    }

    public function setKodeProviderPeserta($kode_provider){
        $this->kdProviderPeserta = $kode_provider;
        return $this;
    }

    public function setTglDaftar($tgl){
        $this->tglDaftar    = $tgl;
        return $this;
    }

    public function setKdPoli($kdPoli){
        $this->kdPoli   = $kdPoli;
        return $this;
    }

    public function kdTkp($kdTkp){
        $this->kdTkp    = $kdTkp;
        return $this;
    }

    public function setKunjunganSakit($kun){
        $this->kunjSakit = $kun;
        return $this;
    }

    private function getDataPendaftaran(){
        $data                       = array();
        $data['kdProviderPeserta']  = $this->kdProviderPeserta;
        $data['tglDaftar']          = $this->tglDaftar;
        $data['noKartu']            = $this->noKartu;
        $data['kdPoli']             = $this->kdPoli;
        $data['keluhan']            = null;
        $data['kunjSakit']          = $this->kunjSakit;
        //imt
        $data['sistole']            = doubleval($_POST['sistole']);
        $data['diastole']           = doubleval($_POST['diastole']);
        $data['beratBadan']         = doubleval($_POST['berat_badan']);
        $data['tinggiBadan']        = doubleval($_POST['tinggi_badan']);
        $data['respRate']           = doubleval($_POST['respiratory_rate']);
        $data['heartRate']          = doubleval($_POST['heart_rate']);
        $data['lingkarPerut']       = doubleval($_POST['lingkar_perut']);
        $data['rujukBalik']         = 0;
        
        $data['kdTkp']              = $this->kdTkp;

        return $data;
    }
    
}