<?php 
require_once "registration/class/pcare/PCare.php";

class PCareMCU extends PCare{
    public static $KODE_kdMCU                   = "kdMCU";
    public static $KODE_noKunjungan             = "noKunjungan";
    public static $KODE_kdProvider              = "kdProvider"; //kode ppk
    public static $KODE_tglPelayanan            = "tglPelayanan";
    public static $KODE_tekananDarahSistole     = "tekananDarahSistole";
    public static $KODE_tekananDarahDiastole    = "tekananDarahDiastole";
    public static $KODE_radiologiFoto           = "radiologiFoto";
    public static $KODE_darahRutinHemo          = "darahRutinHemo";
    public static $KODE_darahRutinLeu           = "darahRutinLeu";
    public static $KODE_darahRutinErit          = "darahRutinErit";
    public static $KODE_darahRutinLaju          = "darahRutinLaju";
    public static $KODE_darahRutinHema          = "darahRutinHema";
    public static $KODE_darahRutinTrom          = "darahRutinTrom";
    public static $KODE_lemakDarahHDL           = "lemakDarahHDL";
    public static $KODE_lemakDarahLDL           = "lemakDarahLDL";
    public static $KODE_lemakDarahChol          = "lemakDarahChol";
    public static $KODE_lemakDarahTrigli        = "lemakDarahTrigli";
    public static $KODE_gulaDarahSewaktu        = "gulaDarahSewaktu";
    public static $KODE_gulaDarahPuasa          = "gulaDarahPuasa";
    public static $KODE_gulaDarahPostPrandial   = "gulaDarahPostPrandial";
    public static $KODE_gulaDarahHbA1c          = "gulaDarahHbA1c";
    public static $KODE_fungsiHatiSGOT          = "fungsiHatiSGOT";
    public static $KODE_fungsiHatiSGPT          = "fungsiHatiSGPT";
    public static $KODE_fungsiHatiGamma         = "fungsiHatiGamma";
    public static $KODE_fungsiHatiProtKual      = "fungsiHatiProtKual";
    public static $KODE_fungsiHatiAlbumin       = "fungsiHatiAlbumin";
    public static $KODE_fungsiGinjalCrea        = "fungsiGinjalCrea";
    public static $KODE_fungsiGinjalUreum       = "fungsiGinjalUreum";
    public static $KODE_fungsiGinjalAsam        = "fungsiGinjalAsam";
    public static $KODE_fungsiJantungABI        = "fungsiJantungABI";
    public static $KODE_fungsiJantungEKG        = "fungsiJantungEKG";
    public static $KODE_fungsiJantungEcho       = "fungsiJantungEcho";
    public static $KODE_funduskopi              = "funduskopi";
    public static $KODE_pemeriksaanLain         = "pemeriksaanLain";
    public static $KODE_keterangan              = "keterangan";



    private $params;
    public function addParams($kode,$value){
        $this->params[$kode]=$value;
    }

    public function getDefaultArray(){
        return array(
            self::$KODE_kdMCU => $this->params["kdMCU"]*1,
            self::$KODE_noKunjungan => $this->params["noKunjungan"],
            self::$KODE_kdProvider =>  $this->getPPKPelayanan(),//$this->params["kdProvider"],
            self::$KODE_tglPelayanan => $this->params["tglPelayanan"],
            self::$KODE_tekananDarahSistole => $this->params["tekananDarahSistole"]*1,
            self::$KODE_tekananDarahDiastole => $this->params["tekananDarahDiastole"]*1,
            self::$KODE_radiologiFoto => $this->params["radiologiFoto"],
            self::$KODE_darahRutinHemo => $this->params["darahRutinHemo"]*1,
            self::$KODE_darahRutinLeu => $this->params["darahRutinLeu"]*1,
            self::$KODE_darahRutinErit => $this->params["darahRutinErit"]*1,
            self::$KODE_darahRutinLaju => $this->params["darahRutinLaju"]*1,
            self::$KODE_darahRutinHema => $this->params["darahRutinHema"]*1,
            self::$KODE_darahRutinTrom => $this->params["darahRutinTrom"]*1,
            self::$KODE_lemakDarahHDL => $this->params["lemakDarahHDL"]*1,
            self::$KODE_lemakDarahLDL => $this->params["lemakDarahLDL"]*1,
            self::$KODE_lemakDarahChol => $this->params["lemakDarahChol"]*1,
            self::$KODE_lemakDarahTrigli => $this->params["lemakDarahTrigli"]*1,
            self::$KODE_gulaDarahSewaktu => $this->params["gulaDarahSewaktu"]*1,
            self::$KODE_gulaDarahPuasa => $this->params["gulaDarahPuasa"]*1,
            self::$KODE_gulaDarahPostPrandial => $this->params["gulaDarahPostPrandial"]*1,
            self::$KODE_gulaDarahHbA1c => $this->params["gulaDarahHbA1c"]*1,
            self::$KODE_fungsiHatiSGOT => $this->params["fungsiHatiSGOT"]*1,
            self::$KODE_fungsiHatiSGPT => $this->params["fungsiHatiSGPT"]*1,
            self::$KODE_fungsiHatiGamma => $this->params["fungsiHatiGamma"]*1,
            self::$KODE_fungsiHatiProtKual => $this->params["fungsiHatiProtKual"]*1,
            self::$KODE_fungsiHatiAlbumin => $this->params["fungsiHatiAlbumin"]*1,
            self::$KODE_fungsiGinjalCrea => $this->params["fungsiGinjalCrea"]*1,
            self::$KODE_fungsiGinjalUreum => $this->params["fungsiGinjalUreum"]*1,
            self::$KODE_fungsiGinjalAsam => $this->params["fungsiGinjalAsam"]*1,
            self::$KODE_fungsiJantungABI => $this->params["fungsiJantungABI"]*1,
            self::$KODE_fungsiJantungEKG => $this->params["fungsiJantungEKG"],
            self::$KODE_fungsiJantungEcho => $this->params["fungsiJantungEcho"],
            self::$KODE_funduskopi => $this->params["funduskopi"],
            self::$KODE_pemeriksaanLain => $this->params["pemeriksaanLain"],
            self::$KODE_keterangan => $this->params["keterangan"]
        );
    }


    public function proceedView($nokunjungan){
        $this->execute("/mcu/kunjungan/".$nokunjungan,"GET");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){   
                return $json["response"]['list'];
            }else{
                return array();
            }
        }else{
           return array();
        }
    }

    public function proceedDelete($kdmcu,$nokunjungan){
        global $db;
        $this->execute("/mcu/".$kdmcu."/kunjungan/".$nokunjungan,"DELETE");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){   
                $finalresult = array(
                    "success"=>1,
                    "message" =>  $code
                );                
            }else{
                $finalresult = array(
                    "success"=>0,
                    "message" => $code
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "message" => $this->getError()
            );
        }
        return $finalresult;
    }


    public function proceedMCU(){
        global $db;
        $methode = "POST";
        if($this->params[self::$KODE_kdMCU]!=0){
            $methode="PUT";
        }
        $this->execute("/mcu",$methode,$this->getDefaultArray());
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="CREATED"){   
                $kodemcu = $json["response"]['message'];
                $finalresult = array(
                    "success"=>1,
                    "kodemcu"=>$kodemcu,
                    "message" => $code
                );                
            }else if($code=="OK"){
                $kodemcu = $this->params[self::$KODE_kdMCU];
                $finalresult = array(
                    "success"=>1,
                    "kodemcu"=>$kodemcu,
                    "message" => $code
                );  
            }else{
                
                
                $msg = "";
                $rsp = $json["response"];
                foreach($rsp as $x=>$vl){
                    foreach($vl as $u=>$ctx){
                        $msg .= $ctx." ";
                    }
                }

                $finalresult = array(
                    "success"=>0,
                    "kodesk"=>0,
                    "message" => $msg." ==> "
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "kodesk"=>0,
                "message" => $this->getError()
            );
        }
        return $finalresult;
    }

}