<?php 
require_once "registration/class/pcare/PCare.php";

class PCareKelompokProlanis extends PCare{
    public function getKelompokProlanis($bulan){
        global $db;
        $this->execute("kelompok/kegiatan/01-".$bulan,"GET");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();
       
        $list = array();
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){ 
                
                $lst = $json["response"]['list'];
                foreach($lst as $x){
                    $row = array();
                    $row['id'] = $x['eduId'];
                    $t = explode("-",$x['tglPelayanan']);
                    $row['tanggal_pelayanan'] = $t[2]."-".$t[1]."-".$t[0];
                    $row['nama_program'] = $x['clubProl']['jnsKelompok']['nmProgram'];
                    $row['nama_club'] = $x['clubProl']['nama'];
                    $list[]=$row;
                }
                
                $finalresult = array(
                    "success"=>1,
                    "message" =>  $json["response"]['count']." data fetched",
                    "list"=>$list
                );                
            }else{
                $finalresult = array(
                    "success"=>0,
                    "message" => $code,
                    "list"=>$list
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "message" => $this->getError(),
                "list"=>$list
            );
        }
        return $finalresult;
        
    }

    public function addKelompokProlanis($data){
        global $db;
        $tg = explode("-",$data['tanggal_pelayanan']);
        $request = array();
        $request['eduId'] = null;
        $request['clubId'] = $data['club_id'];
        $request['tglPelayanan'] = $tg[2]."-".$tg[1]."-".$tg[0];
        $request['kdKegiatan'] = $data['nama_kegiatan'];
        $request['kdKelompok'] = $data['nama_kelompok'];
        $request['materi'] = $data['materi'];
        $request['pembicara'] = $data['pembicara'];
        $request['lokasi'] = $data['lokasi'];
        $request['keterangan'] = $data['keterangan'];
        $request['biaya'] = $data['biaya']*1;
       

        $this->execute("kelompok/kegiatan","POST",$request);
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();
       
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){ 
                
                $finalresult = array(
                    "success"=>1,
                    "message" =>  $json["response"]['field']." ".$json["response"]['message'],
                );                
            }else{
                $msg = array();
                $listres = $json["response"];
                foreach($listres as $r){
                    $msg[] = $r['field']." ".$r['message'];
                }

                $finalresult = array(
                    "success"=>0,
                    "message" =>$code."  ".implode(", ",$msg)
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "message" => $this->getError()
            );
        }
        return $finalresult;
    }

}