<?php 
require_once "registration/class/pcare/PCare.php";

class PCareClubProlanis extends PCare{
    public function getClubProlanis($kodeclub){
        global $db;
        $this->execute("/kelompok/club/".$kodeclub,"GET");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();

        $list = array();
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){ 
                
                $lst = $json["response"]['list'];
                foreach($lst as $x){
                    $row = array();
                    $row['id'] = $x['clubId'];

                    $t = explode("-",$x['tglMulai']);
                    $row['tanggal_mulai'] = $t[2]."-".$t[1]."-".$t[0];

                    if($x['tglAkhir']!=null && $x['tglAkhir']!=""){
                        $t = explode("-",$x['tglAkhir']);
                        $row['tanggal_akhir'] = $t[2]."-".$t[1]."-".$t[0];                    
                    }else{
                        $row['tanggal_akhir'] = "";
                    }


                    $row['alamat'] = $x['alamat'];
                    $row['nama_club'] = $x['nama'];
                    $row['nama_ketua'] = $x['ketua_nama'];
                    $row['no_hp_ketua'] = $x['ketua_noHP'];
                    $list[$row['id']]=$row;
                }
                
                $finalresult = array(
                    "success"=>1,
                    "message" =>  $json["response"]['count']." data fetched",
                    "list"=>$list
                );                
            }else{
                $finalresult = array(
                    "success"=>0,
                    "message" => $code,
                    "list"=>$list
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "message" => $this->getError(),
                "list"=>$list
            );
        }
        return $finalresult;
        
    }

}