<?php 

class PCareAddTindakan extends PCare{

    private $kodetindakansk = 0;
    private $noKunjungan = "";
    private $kodetindakan = "";
    private $biaya = 0;
    private $keterangan = "";
    private $hasil = 0;

    public function setKodeTindakanSK($kode){
        $this->kodetindakansk=$kode;
        return $this;
    }

    public function setNoKunjungan($no){
        $this->noKunjungan=$no;
        return $this;
    }

    public function setKodeTindakan($kode){
        $this->kodetindakan=$kode;
        return $this;
    }

    public function setBiaya($biaya){
        $this->biaya=$biaya*1;
        return $this;
    }

    public function setKeterangan($keterangan){
        $this->keterangan=$keterangan;
        return $this;
    }

    public function setHasil($hasil){
        $this->hasil=$hasil;
        return $this;
    }
    
    public function getParameter(){
        $parameter = array(
            "kdTindakanSK"=>$this->kodetindakansk,
            "noKunjungan"=>$this->noKunjungan,
            "kdTindakan"=>$this->kodetindakan,
            "biaya"=>$this->biaya,
            "keterangan"=>$this->keterangan,
            "hasil"=>$this->hasil
        );
        return $parameter;
    }

    public function proceedDelete($kodesk,$nokunjungan){
        global $db;
        $this->execute("/tindakan/".$kodesk."/kunjungan/".$nokunjungan,"DELETE");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){   
                $finalresult = array(
                    "success"=>1,
                    "message" =>  $code
                );                
            }else{
                $finalresult = array(
                    "success"=>0,
                    "message" => $code
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "message" => $this->getError()
            );
        }
        return $finalresult;
    }

    public function proceedTindakan(){
        global $db;
        $methode = "POST";
        if($this->kodetindakansk!=0){
            $methode="PUT";
        }
        $this->execute("/tindakan",$methode,$this->getParameter());
        $result = $this->getResponse();
        $json = json_decode($result,true);
        $finalresult = array();
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="CREATED" || $code=="OK"){   
                $kodesk = $json["response"]['message'];
                $finalresult = array(
                    "success"=>1,
                    "kodesk"=>$kodesk,
                    "message" => $code
                );                
            }else{
                
                
                $msg = "";
                $rsp = $json["response"];
                foreach($rsp as $x=>$vl){
                    foreach($vl as $u=>$ctx){
                        $msg .= $ctx." ";
                    }
                }

                $finalresult = array(
                    "success"=>0,
                    "kodesk"=>0,
                    "message" => $msg
                );
            }
        }else{
            $finalresult = array(
                "success"=>0,
                "kodesk"=>0,
                "message" => $this->getError()
            );
        }
        return $finalresult;
    }


    public function proceedView($nokunjungan){
        $this->execute("/tindakan/kunjungan/".$nokunjungan,"GET");
        $result = $this->getResponse();
        $json = json_decode($result,true);
        if($json!=null){
            $code = $json["metaData"]['message'];
            if($code=="OK"){   
                return $json["response"]['list'];
            }else{
                return array();
            }
        }else{
           return array();
        }
    }
}