<?php 
class PCare{
    
    protected $consumer_id;  
    protected $consumer_secret;
    protected $ppk_pelayanan;
    protected $url_base;
    protected $port;
    protected $userkey;
    protected $pcare_username;   
    protected $pcare_password;   
    protected $pcare_code;
    protected $response;
    protected $error;
    protected $id_pcare;
    protected $name_pcare;
    protected $key;

    public function setPCareAuthorization($ppk=""){
        global $db;
        global $user;
        global $querylog;
        $authorization = null;
        $dbtable = new DBTable($db,"smis_rg_pcare_settings");
        
        //if($ppk==""){
        //    $authorization = $dbtable->select(array("df"=>"1"));
        //}else{
        //    $authorization = $dbtable->select(array("code_ppk"=>$ppk));
        //    if($authorization==null){
        //        $authorization = $dbtable->select(array("df"=>"1"));
        //    }
        //}

        require_once "registration/class/RegistrationResource.php";
        $ukerja = RegistrationResource::getUserUnitKerja();
        $querylog->addMessage("Mengambil Unit Kerja yang Lagi Login (".$ukerja.")");
        if($ukerja==""){
            $authorization = $dbtable->select(array("df"=>"1"));
            $querylog->addMessage("unit kerja yang lagi login kosong mana mengambil default dari smis_rg_pcare_settings ");
        }else{
            $querylog->addMessage("unit kerja tidak kosong (".$ukerja.") mengambil di smis_rg_faskes dengan kolom unitkerja ".$ukerja);
            $dbtablex = new DBTable($db,"smis_rg_faskes");
            $row = $dbtablex->select(array("unitkerja"=>$ukerja));
            if($row==null){
                $querylog->addMessage("smis_rg_faskes tidak menemukan yang unitkerja = (".$ukerja.") maka mengambil smis_rg_pcare_settings yang df=1");
                $authorization = $dbtable->select(array("df"=>"1"));
            }else{
                $querylog->addMessage("smis_rg_faskes berhasil menemukan yang unitkerja = (".$ukerja.") maka mengambil smis_rg_pcare_settings yang code_ppk=".$row->kode);
                $authorization = $dbtable->select(array("code_ppk"=>$row->kode));
            }
        }

        $this->consumer_id      = $authorization->cons_id;
        $this->consumer_secret  = $authorization->cons_secret;
        $this->ppk_pelayanan    = $authorization->code_ppk;
        $this->url_base         = $authorization->url_vclaim;
        $this->port             = $authorization->port;
        $this->userkey          = $authorization->userkey;

        $this->pcare_username   = $user->getUserPcare();//$authorization->username;
        $this->pcare_password   = $user->getPasswordPcare();//$authorization->passcode;
        
        $this->pcare_code       = "095";
        $this->id_pcare         = $authorization->id;
        $this->name_pcare       = $authorization->klinik;

        if($this->pcare_username=="" || $this->pcare_password==""){
            $dbtable = new DBTable($db,"smis_adm_user");
            $uname = $user->getNameOnly();
            $uname = str_replace("(","",$uname);
            $uname = str_replace(")","",$uname);
            $uname = trim($uname);     
            $one = $dbtable->select(array("realname"=>$uname));
            $querylog->addMessage("pcare_username dan pcare_password kosong maka mengambil maka mengambill dari smis_adm_user yang realname =>".$uname);
            if($one!=null){
                $querylog->addMessage(" berhasil mengambil dari smis_adm_user ");
                $this->pcare_username = $one->username_pcare;
                $this->pcare_password = $one->password_pcare;
            }
        }
    }

    public function setPCareID($id){
        global $db;
        global $user;
        $authorization = null;
        $dbtable = new DBTable($db,"smis_rg_pcare_settings");
        $authorization = $dbtable->select(array("id"=>$id));

        $this->consumer_id      = $authorization->cons_id;
        $this->consumer_secret  = $authorization->cons_secret;
        $this->ppk_pelayanan    = $authorization->code_ppk;
        $this->url_base         = $authorization->url_vclaim;
        $this->port             = $authorization->port;
        $this->userkey          = $authorization->userkey;

        $this->pcare_username   = $user->getUserPcare();//$authorization->username;
        $this->pcare_password   = $user->getPasswordPcare();//$authorization->passcode;

        //$this->pcare_username   = $authorization->username;
        //$this->pcare_password   = $authorization->passcode;
        $this->pcare_code       = "095";
        $this->id_pcare         = $authorization->id;
        $this->name_pcare       = $authorization->klinik;

        if($this->pcare_username=="" || $this->pcare_password==""){
            $dbtable = new DBTable($db,"smis_adm_user");
            $uname = $user->getNameOnly();
            $uname = str_replace("(","",$uname);
            $uname = str_replace(")","",$uname);
            $uname = trim($uname);     
            $one = $dbtable->select(array("realname"=>$uname));
            if($one!=null){
                $this->pcare_username = $one->username_pcare;
                $this->pcare_password = $one->password_pcare;
            }
        }
    }

    public function getID(){
        return $this->id_pcare;
    }

    public function getName(){
        return $this->name_pcare;
    }

    public function getPPKPelayanan(){
        return $this->ppk_pelayanan;
    }
    
    public function execute($add_url,$methode,$request=null){
        $this->do_curl($this->port,$this->url_base.$add_url,$methode,$request);
    }

    public function getResponse(){
        return $this->response;
    }

    public function getError(){
        return $this->error;
    }

    protected function do_curl($port,$url,$methode,$request){
        $pcare          = $this->generatePCareAuthorization();
        $generated      = $this->generateBPJSCode($this->consumer_id,$this->consumer_secret);
        $devrypt        = $this->consumer_id.$this->consumer_secret.$generated['timestamp'];
        global $querylog; 
        $querylog->addMessage(" MELAKUKAN DO CURL ");
        $querylog->addMessage("Url -> ".$url);
        $querylog->addMessage("Request : ".json_encode($request) );
        $querylog->addMessage("Consumer ID : ".$this->consumer_id );
        $querylog->addMessage("PPK Pelayanan : ".$this->ppk_pelayanan );
        $querylog->addMessage("Username : ".$this->pcare_username );
        $querylog->addMessage("Password : ".$this->pcare_password );
        $querylog->addMessage("x-signature : ".$generated['signature'] );
        $querylog->addMessage("x-timestamp : ".$generated['timestamp'] );
        $querylog->addMessage("x-authorization : ".$pcare );
        $querylog->addMessage("decryptkey : ".$devrypt);
        $querylog->addMessage("user_key : ".$this->userkey );
        

        $curl           = curl_init();
        $array_object   = array();
        $array_object[] = "accept: application/json";
        //$array_object[] = "content-type: application/json";
        $array_object[] = "X-cons-id: ".$this->consumer_id;
        $array_object[] = "X-signature: ".$generated['signature'];
        $array_object[] = "X-timestamp: ".$generated['timestamp'];       
        $array_object[] = "X-authorization: ".$pcare;
        $array_object[] = "user_key: ".$this->userkey;
        
        if($request==null){
            $request=array();
        }
        curl_setopt_array($curl, array(
          CURLOPT_PORT => $port,
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => $methode,
          CURLOPT_POSTFIELDS => json_encode($request),
          CURLOPT_HTTPHEADER =>$array_object,
        ));
        
        $this->response = curl_exec($curl);
        $this->error    = curl_error($curl);

        $querylog->addMessage("Raw Response : ". $this->response );
        $xres = json_decode($this->response,true);
        $querylog->addMessage("XRes : ".json_encode($xres) );
        if($xres!=null){
            if(isset($xres['response'])){
                require_once "registration/function/vclaim_decrypt.php";
                $r = stringDecrypt($devrypt,$xres['response']);
                $querylog->addMessage("Compressed-> : ".$r );
                $hasil = decompress($r);
                $querylog->addMessage("Decompress-> : ".$hasil );
                $x = json_decode($hasil,true);
                $xres['response'] = $x;
                $this->response = json_encode($xres);
            }
        }
        $querylog->addMessage("Response : ".json_encode($this->response)." - ".json_encode($this->error) );
        curl_close($curl);
    }

    protected function generateBPJSCode($consmer_id,$consumer_secret){
        $cur_zone           = date_default_timezone_get();
        date_default_timezone_set('UTC');
        $tStamp             = strval(time()-strtotime('1970-01-01 00:00:00'));
        $signature          = hash_hmac('sha256', $consmer_id."&".$tStamp, $consumer_secret, true);
        $encodedSignature   = base64_encode($signature);
        date_default_timezone_set($cur_zone);
        return array("timestamp"=>$tStamp,"signature"=>$encodedSignature);
    }

    protected function generatePCareAuthorization(){
        return "Basic ".base64_encode($this->pcare_username.":".$this->pcare_password.":".$this->pcare_code);
    }

}