<?php
require_once "rawat/class/template/LayananTemplate.php";
require_once 'hrd/library/class/responder/EmployeeResponder.php';

class TindakanPCare extends LayananTemplate {
	private $muitable;
	private $number;
	public function __construct($db, $polislug, $poliname, $nama_pasien, $nrm_pasien, $noreg_pasien,$carabayar,$titipan) {
		parent::__construct ($db, $polislug, $poliname, $nama_pasien, $nrm_pasien, $noreg_pasien,$carabayar,$titipan);
		$header			= array('Kd. Tindakan SK','Kd. Tindakan','Nama Tindakan',"Biaya","Keterangan","Hasil");
		$this->uitable 	= new Table($header, $this->getUiTableTitle("Tindakan"), NULL, true);
        $this->uitable	->setName("tindakan_pcare");
        $this->uitable  ->setFooterVisible(false);

		$array_mui		= array("Nama",'DTD','Kode');
		$this->muitable = new Table($array_mui);
		$this->muitable ->setModel(Table::$BOTH)
                        ->setName("mr_icd_tindakan")
                        ->setDelButtonEnable(false)
                        ->setPrintButtonEnable(false)
                        ->setReloadButtonEnable(false);
		$this->number	= array("I"=>"","II"=>"_dua","III"=>"_tiga","IV"=>"_empat","V"=>"_lima","VI"=>"_enam","VII"=>"_tujuh","VIII"=>"_delapan","IX"=>"_sembilan","X"=>"_sepuluh");
	}
	
	public function superCommand($super_command) {
        global $db;
        $uitable = new Table(array("No.","Tindakan","Max Tarif"));
        $uitable ->setName("tarif_pcare");
        $uitable ->setModel(Table::$SELECT);
        $adapter = new SimpleAdapter();
        $adapter ->setUseNumber(true,"No.","back.");
        $adapter ->add("Tindakan","nama_tindakan");
        $adapter ->add("Max Tarif","max_tarif","money Rp.");        
        $service = new ServiceResponder($db,$uitable,$adapter,"get_tindakan_pcare","registration");
        $super   = new SuperCommand ();
        $super   ->addResponder("tarif_pcare",$service,null);

        $init = $super->initialize();
		if ($init != null) {
			echo $init;
			return;
		}		
	}
	
	public function command($command) {
		$adapter = new SimpleAdapter ();
		$adapter ->add("Kd. Tindakan SK","pcare_kode_tindakan_sk")
				 ->add("Kd. Tindakan","pcare_kode_tindakan")
				 ->add("Nama Tindakan","nama_tindakan")
				 ->add("Biaya","harga","money Rp.")
				 ->add("Hasil","pcare_hasil")
				 ->add("Keterangan","pcare_keterangan");
				
		$this->getDBTable("smis_rwt_tindakan_dokter_");        
        require_once "rawat/class/responder/TindakanPCareResponder.php";
        $this->dbres = new TindakanPCareResponder($this->dbtable, $this->uitable, $adapter, $this->polislug);
		if ($this->dbres->is("save")) {
            self::getProvitShareByService($this->db,$this->dbres, $this->polislug ,$this->carabayar, "smis-pv-tindakan-dokter");
		}        
        if($this->dbres->isSave() || $this->dbres->isDel()){
            $this->dbres->setAccounting("get_accounting_tindakan_dokter","TDK","tindakan_dokter","waktu","nama_tindakan","harga");
        }        
		$data = $this->dbres->command($_POST ['command']);
		echo json_encode($data);
	}
	
	public function phpPreload() {
        global $db;
        $serv = new ServiceConsumer($db,"get_pcare_nokunjungan",array("noreg_pasien"=>$this->noreg),"medical_record");
        $serv ->execute();
        $ctx = $serv->getContent();

        if($ctx['no_kunjungan']==""){
            echo "Data pelayanan belum diinput pada pasien ini";
            return;
        }

		$this->uitable	->addModal("id","hidden","","")
						->addModal("nama_pasien","hidden","", $this->nama_pasien)
						->addModal("noreg_pasien","hidden","", $this->noreg)
						->addModal("nrm_pasien","hidden","", $this->nrm)
                        ->addModal("waktu","hidden","", date("Y-m-d H:i"))
                        ->addModal("pcare_no_kunjungan","hidden","",$ctx['no_kunjungan'])                        
                        ->addModal("pcare_kode_tindakan_sk","text","Kd. Tindakan SK","0","y",null,true)
                        ->addModal("pcare_kode_tindakan","text","Kd. Tindakan","","n",null,true)
                        ->addModal("nama_tindakan","chooser-tindakan_pcare-tarif_pcare-Tarif Tindakan PCare","Tindakan","" ,"n",null,true,null,true)
						->addModal("pcare_max_tarif","money","Max Tarif","","y",null,true)
                        ->addModal("harga","money","Biaya","","n")
                        ->addModal("pcare_hasil","text","Hasil","")
                        ->addModal("pcare_keterangan","textarea","Keterangan","")
                        ->addModal("nama_dokter","text","Nama Dokter",$ctx['tenaga_medis'],"y",null,true );
						
		$modal 			= $this->uitable->getModal ();
        $modal			->setTitle($this->poliname);
        $modal ->setComponentSize(Modal::$MEDIUM);

		echo $this		->uitable->getHtml ();
		echo $modal		->getHtml ();
		echo addJS  ("framework/bootstrap/js/bootstrap-datepicker.js");
		echo addJS  ("framework/smis/js/table_action.js");
		echo addJS  ("framework/bootstrap/js/bootstrap-datetimepicker.js");
		echo addCSS ("framework/bootstrap/css/datepicker.css");
		echo addCSS ("framework/bootstrap/css/bootstrap-datetimepicker.css");
		echo addJS  ("rawat/resource/js/tindakan_pcare.js" ,false);
		
		/*Parsing ke Javascript*/
		$carabayar 	= new Hidden("tpc_carabayar","",$this->carabayar);
		$poliname	= new Hidden("tpc_poliname","",$this->poliname);
		$polislug	= new Hidden("tpc_polislug","",$this->polislug);
		echo $carabayar ->getHtml();
		echo $poliname  ->getHtml();
		echo $polislug  ->getHtml();
	}
}
