<?php 
require_once "rawat/class/template/LayananTemplate.php";
require_once 'rawat/class/service_consumer/OksigenService.php';
require_once 'rawat/class/adapter/OksigenManualAdapter.php';
require_once 'rawat/class/responder/OksigenManualResponder.php';

class OksigenManualTemplate extends LayananTemplate {
	public function __construct($db, $polislug, $poliname, $nama_pasien, $nrm_pasien, $noreg_pasien,$carabayar,$titipan) {
		parent::__construct ($db, $polislug, $poliname, $nama_pasien, $nrm_pasien, $noreg_pasien,$carabayar,$titipan);
		$this->uitable = new Table ( array ('Waktu',"Harga (H)","Liter (L)",'Biaya Lain (B)','Total (H*L+B)'), $this->getUiTableTitle("Oksigen Manual"), NULL, true );
		$this->uitable->setName ( "oksigen_manual" );
	}
    
	public function command($command) {
		$column = array ('id','nama_pasien','nrm_pasien','noreg_pasien','jumlah_liter',	'biaya_lain');
		$this->getDBTable("smis_rwt_oksigen_manual_");
        $this->dbtable->setColumn($column);
		$this->dbres = new OksigenManualResponder ( $this->dbtable, $this->uitable, new OksigenManualAdapter (), $this->polislug );
        if($this->dbres->isSave() || $this->dbres->isDel()){
            $this->dbres->setAccounting("get_accounting_oksigen_manual","O2M","oksigen_manual","waktu","nrm_pasien","harga");
        }
        $data = $this->dbres->command ( $_POST ['command'] );		
        echo json_encode ( $data );
	}

	/* when it's star build */
	public function phpPreload() {
		//$this->uitable->setModal ( $mcolumn, $mtype, $mname, $mvalue, null, $disabled );
		$this->uitable->addModal("id", "hidden", "", "");
		$this->uitable->addModal("nama_pasien", "hidden", "", $this->nama_pasien);
		$this->uitable->addModal("nrm_pasien", "hidden", "", $this->nrm);
		$this->uitable->addModal("noreg_pasien", "hidden", "", $this->noreg);
		$this->uitable->addModal("jumlah_liter", "text", "Jumlah (Liter)", "","n",null,false,null,true,"biaya_lain");
		$this->uitable->addModal("biaya_lain", "money", "Biaya Manometer", "","y",null,false,null,false,"save");
		
		$modal = $this->uitable->getModal ();
		$modal->setTitle ( "Oksigen Manual" );
        $carabayar=new Hidden("omn_carabayar","",$this->carabayar);
		$poliname=new Hidden("omn_poliname","",$this->poliname);
		$polislug=new Hidden("omn_polislug","",$this->polislug);
        echo $carabayar->getHtml();
		echo $poliname->getHtml();
		echo $polislug->getHtml();
		echo $this->uitable->getHtml ();
		echo $modal->getHtml ();
		echo addJS ( "framework/smis/js/table_action.js" );
        echo addJS ( "rawat/resource/js/oksigen_manual.js",false );
	}
}
?>