<?php 

require_once ("smis-base/smis-include-service-consumer.php");
class BedKamar extends ModulTemplate {
	private $poliname;
	private $polislug;
	private $uitable;
	private $dbres;
	private $dbtable;
	private $db;
	public function __construct($db, $polislug, $poliname) {
		parent::__construct ();
		$this->polislug = $polislug;
		$this->poliname = $poliname;
		$this->db = $db;
		$header=array ('Nama','Terpakai','Keterangan',"Pasien","NRM","No Reg");
		$this->uitable = new Table ( $header, "Bed Kamar " . $poliname, NULL, true );
		$btn = new Button ( "", "", "Kosongkan" );
		$btn->setClass ( "btn-success" );
		$btn->setIsButton ( Button::$ICONIC );
		$btn->setIcon ( "icon-white icon-trash" );
		$this->uitable->addContentButton ( "kosongkan", $btn );
		
		$btn = new Button ( "", "", "Booking" );
		$btn->setClass ( "btn-success" );
		$btn->setIsButton ( Button::$ICONIC );
		$btn->setIcon ( "fa fa-book" );
		$this->uitable->addContentButton ( "booking", $btn );
		
		$btn = new Button ( "", "", "Un Booking" );
		$btn->setClass ( "btn-danger" );
		$btn->setIsButton ( Button::$ICONIC );
		$btn->setIcon ( "fa fa-book" );
		$this->uitable->addContentButton ( "unbooking", $btn );
		
		$this->uitable->setMaxContentButton(10,"");
		
		$this->uitable->setName ( "bed_kamar" );
	}
	public function command($command) {
		$adapter = new SimpleAdapter ();
		$adapter->add ( "Nama", "nama" );
		$adapter->add ( "Pasien", "nama_pasien" );
		$adapter->add ( "NRM", "nrm_pasien", "digit8" );
		$adapter->add ( "No Reg", "noreg_pasien","digit8" );
		$adapter->add ( "Terpakai", "terpakai", "trivial_1_Terpakai_Kosong" );
		$adapter->add ( "Keterangan", "keterangan" );
		$this->dbtable = new DBTable ( $this->db, "smis_rwt_bed_kamar_" . $this->polislug );
		$this->dbtable->setOrder ( "nama ASC" );
		$this->dbres = new DBResponder ( $this->dbtable, $this->uitable, $adapter );
		$data = $this->dbres->command ( $_POST ['command'] );
		echo json_encode ( $data );
		return;
	}
	public function jsLoader() {
		echo addJS ( "framework/smis/js/table_action.js" );
	}
	public function phpPreload() {
		$pakai = array (
				array (
						"name" => "Kosong",
						"value" => "0",
						"default" => "1"
				),
				array (
						"name" => "Terpakai",
						"value" => "1"
				)
		);
		$mcolumn = array (
				'id',
				'nama',
		);
		$mname = array (
				"",
				"Nama",

		);
		$mtype = array (
				"hidden",
				"text"
		);
		$mvalue = array (
				"",
				""
		);
		
		$this->uitable->setModal ( $mcolumn, $mtype, $mname, $mvalue );
		$modal = $this->uitable->getModal ();
		$modal->setTitle ( "Bed Kamar " . $this->poliname );

		echo $this->uitable->getHtml ();
		echo $modal->getHtml ();
	}
	public function jsPreLoad() {
		?>
				<script type="text/javascript">
				var bed_kamar;
				$(document).ready(function(){
					$('[data-toggle="popover"]').popover({trigger: 'hover','placement': 'top'});
					var column=new Array('id','nama');
					bed_kamar=new TableAction("bed_kamar","<?php echo $this->polislug;?>","bed_kamar",column);
					bed_kamar.setPrototipe("<?php echo $this->poliname ?>","<?php echo $this->polislug ?>","rawat");
					bed_kamar.kosongkan=function(id){
						var self=this;						
						bootbox.confirm("Anda Yakin Mengosongkan Bed ini. Bed tidak seharusnya dikosongkan dengan cara ini. cukup memulangkan pasien saja. ?", function(result) {
							if(result){
								var a=self.getRegulerData();
								a['command']="save";
								a['id']=id;
								a['nama_pasien']="";
								a['terpakai']="0";
								a['nrm_pasien']="";
								a['noreg_pasien']="";								
								showLoading();
								$.ajax({url:"",data:a,type:'post',success:function(res){
									var json=getContent(res);
									if(json==null) return;
									self.view();
									self.clear();
									dismissLoading();
								}});
							}
						});
					};
					
					bed_kamar.unbooking=function(id){
						var self=this;
						bootbox.confirm("Anda yakin mau menghilangkan Booking ?", function(result) {
							if(result){
								var a=self.getRegulerData();
								a['command']="save";
								a['id']=id;
								a['keterangan']="";							
								showLoading();
								$.ajax({url:"",data:a,type:'post',success:function(res){
									var json=getContent(res);
									if(json==null) return;
									self.view();
									self.clear();
									dismissLoading();
								}});
							}							
						});						
					};
					
					bed_kamar.booking=function(id){
						var self=this;
						bootbox.prompt("Nama Pasien yang Booking ?", function(result) {                
						  if (result !== null) {                                  								
							var a=self.getRegulerData();
							a['command']="save";
							a['id']=id;
							a['keterangan']="di Booking Oleh "+result;
							showLoading();
							$.ajax({url:"",data:a,type:'post',success:function(res){
								var json=getContent(res);
								if(json==null) return;
								self.view();
								self.clear();
								dismissLoading();
							}});							  
						  } 
						});
					};
					bed_kamar.view();
				});
			</script>
		<?php
	}
}


?>