<?php 
require_once "rawat/class/responder/TindakanDokterResponder.php";
class TindakanPCareResponder extends TindakanDokterResponder{

    public function edit(){
		$id		= $_POST['id'];
		$row	= $this->dbtable->select(array("pcare_kode_tindakan_sk"=>$id),false);
		return $row;
	}
    
    public function view(){
        global $db;
        $serv = new ServiceConsumer($db,"view_tindakan_pcare",NULL,"registration");
        $serv ->addData("pcare_no_kunjungan",$_POST['no_kunjungan']);
        $serv ->execute();
        $list = $serv->getContent();

        $data = array();
        foreach($list as $x){
            $data[] = array(
                "harga" => $x['biaya'],
                "pcare_keterangan" => $x[''],
                "pcare_kode_tindakan" => $x['kdTindakan'],
                "pcare_no_kunjungan" => $x['noKunjungan'],
                "pcare_kode_tindakan_sk" => $x['kdTindakanSK'],
                "pcare_hasil" => $x['hasil'],
                "nama_tindakan" => $x['nmTindakan'],
                "id" => $x['kdTindakanSK']
            );
        }
	
		$page				 = 1;
		$max_page			 = 1;
		$this->adapter->setNumber($page*1000);
		$uidata				 = $this->adapter->getContent($data);
		$this->uitable->setContent($uidata);
		$list				 = $this->uitable->getBodyContent();
		$pagination			 = $this->uitable->getPagination($page,3,$max_page);		
		$json['list']		 = $list;
        
        $json['debug']		 = $this->debug;
		
		$json['pagination']	 = $pagination->getHtml();
		$json['number']		 = $page;
		$json['number_p']	 = 1;
		return $json;
	}

    public function command($command){
		$this->response_pack = new ResponsePackage();	
		if($command=='save' && $this->getAddCapability()){
			$content		 = $this->save();
			$this->response_pack->setContent($content);
			$this->response_pack->setStatus(ResponsePackage::$STATUS_OK);
		}else if($command=="del" && $this->getDeleteCapability()){
			$content		 = $this->delete();
			$this->response_pack->setContent($content);
			$this->response_pack->setStatus(ResponsePackage::$STATUS_OK);	
		}else{
			return parent::command($command);
		}
		return $this->response_pack->getPackage();
    }

    public function delete(){
        global $db;
        $item = $this->getDBTable()->select(array("pcare_kode_tindakan_sk"=>$_POST['id']));
        $_POST['id'] = $item->id;
        
        $service = new ServiceConsumer($db,"del_tindakan_pcare",array(),"registration");
        $service ->addData("pcare_kode_tindakan_sk",$item->pcare_kode_tindakan_sk);
        $service ->addData("pcare_no_kunjungan",$item->pcare_no_kunjungan);

        $service ->execute();
        $response = $service ->getContent();
        $data = array();
        if($response['success']==1){
            $data = parent::delete();
        }else{
            $msg = $response['message'];
            $this->response_pack->setAlertVisible(true);
            $this->response_pack->setAlertContent("Delete Fail", $msg, ResponsePackage::$TIPE_DANGER);
		    $data['success']    = 0;
        }
		return $data;
	}
    
    public function save(){
        global $db;
        $service = new ServiceConsumer($db,"add_tindakan_pcare",array(),"registration");
        $service ->addData("harga",$_POST['harga']);
        $service ->addData("pcare_keterangan",$_POST['pcare_keterangan']);
        $service ->addData("pcare_kode_tindakan",$_POST['pcare_kode_tindakan']);
        $service ->addData("pcare_kode_tindakan_sk",$_POST['pcare_kode_tindakan_sk']);
        $service ->addData("pcare_no_kunjungan",$_POST['pcare_no_kunjungan']);
        $service ->addData("pcare_hasil",$_POST['pcare_hasil']);
        $service ->execute();
        $response = $service ->getContent();
        $data = array();
        if($response['success']==1){
            $_POST['pcare_kode_tindakan_sk'] = $response['kodesk'];
            $data = parent::save();
        }else{
            $msg = $response['message'];
            $this->response_pack->setAlertVisible(true);
            $this->response_pack->setAlertContent("Saving Fail", $msg, ResponsePackage::$TIPE_DANGER);

            $data['id']			= 0;
		    $data['success']    = 0;
        }
		return $data;
    }

}