<?php
	require_once("registration/class/pcare/PCare.php");

	class RiwayatPelayananPCare extends PCare {
		
		public function getRiwayat($nobpjs){
			global $db;
            $req = array(
                "param"=> $nobpjs
            );
			$this->url_base = getSettings($db,"reg-bpjs-icare-api-url-base","https://apijkn-dev.bpjs-kesehatan.go.id/ihs_dev/");
			$url  = $this->url_base."/api/pcare/validate";
			
			$this->do_curl($this->port,$url,"POST",$req);  
			if ($this->error) {
			   return "cURL Error #:" . $this->error;
			 } else {
				global $querylog;
				$querylog->addMessage("MENTAHAN ".$this->response);
				 $data=json_decode($this->response,true);
				 if($data==null ){
					$querylog->addMessage("GAGAL DECODE ".$this->response);
					 return null;
				 }else if( $data['metaData']['code']!="200" ){
					 $querylog->addMessage("CODE TIDAK 200 ".$this->response);
					 return $data['metaData']['message'];
				 }else{
				   require_once "registration/function/vclaim_decrypt.php";
				   $rep = array();
				   if(is_string($data['response'])){
						$querylog->addMessage("TRY DECRIPT ".$data['response']);
						$devrypt        = $this->consumer_id.$this->consumer_secret.$this->timestamp;
					   $hasilcompress = stringDecrypt($devrypt, $data['response']);
					   $querylog->addMessage("HASILI COMPRESS :  ".$hasilcompress);
					   $hasil = decompress($hasilcompress);
					   global $querylog;
					   $querylog->addMessage("HASIL DECOMPRESS : ". $hasil);
					   $repx = json_decode($hasil,true);
					   $querylog->addMessage("HASIL JSON DECODE : ". json_encode($repx));
					   $rep = $repx['url'];
					   $querylog->addMessage("HASIL EXRRACT URL : ".  $rep );
					   return $rep;
				   }else if($data['response']==null){
						$querylog->addMessage("RESPONSE NULL ".$this->response);
						return $data['metaData']['message'];
				   }else{
						$querylog->addMessage("ELSE ".$this->response);
					   $rep = $data['response']['url'];
				   }
				   return $rep;
				 }
			 }
   
		}

		public $timestamp;
		protected function do_curl($port,$url,$methode,$request){
			global $querylog;
			$querylog->addMessage($url);
			$querylog->addMessage($methode);
			$querylog->addMessage($request);
	
			
			$generated=$this->generateBPJSCode($this->consumer_id,$this->consumer_secret);
			$this->key = $this->consumer_id.$this->consumer_secret.$generated['timestamp'];
	
			$array_object=array();
			$array_object[]="Content-Type: application/json";
			$array_object[]="X-cons-id: ".$this->consumer_id;
			$array_object[]="X-signature: ".$generated['signature'];
			$array_object[]="X-timestamp: ".$generated['timestamp'];			
			$array_object[]="user_key: ".$this->userkey;
			$pcare=$this->generatePCareAuthorization($this->pcare_username,$this->pcare_password,$this->pcare_code);
			$array_object[]="X-Authorization: ".$pcare;
			$this->timestamp = $generated['timestamp'];


		/*
			curl_setopt_array($curl, array(
			  CURLOPT_URL => $url,
			  CURLOPT_RETURNTRANSFER => true,
			  CURLOPT_ENCODING => "",
			  CURLOPT_MAXREDIRS => 10,
			  CURLOPT_TIMEOUT => 30,
			  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			  CURLOPT_CUSTOMREQUEST => $methode,
			  CURLOPT_POSTFIELDS => json_encode($request),
			  CURLOPT_HTTPHEADER =>$array_object,
			));*/

			$curl = curl_init();
		curl_setopt_array($curl, [
			CURLOPT_URL => "https://apijkn.bpjs-kesehatan.go.id/wsihs/api/pcare/validate",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => json_encode($request),
			CURLOPT_HTTPHEADER => [
			"Content-Type: application/json",
			"X-Authorization: ".$pcare,
			"X-cons-id: ".$this->consumer_id,
			"X-signature: ".$generated['signature'],
			"X-timestamp: ".$generated['timestamp'],
			"user_key: ".$this->userkey
			],
		]);
		   
			$this->response= curl_exec($curl);
			$this->error = curl_error($curl);
			$querylog->addMessage("HEADER");
			$header =  "</br>content-type: application/json";
			$header .= "</br>x-cons-id: ".$this->consumer_id;
			$header .= "</br>x-signature: ".$generated['signature'];
			$header .= "</br>x-timestamp: ".$generated['timestamp'];
			$header .= "</br>x-authorization: ".$pcare;
			$header .= "</br>user_key: ".$this->userkey;
			$querylog->addMessage($header);
			$querylog->addMessage("RESPONSE XXX: ".$this->response );
			$querylog->addMessage("ERROR : ".$this->error);
			curl_close($curl);
		}
		
	}
?>