<?php 

class TagihanDokterAdapter extends ArrayAdapter {
	private $content;
    protected $polislug;
    protected $db;
	public function __construct($db,$polislug="") {
		parent::__construct ();
        $this->polislug=$polislug;
        $this->db=$db;
	}
	
	public function adapt($d) {		
		$a                  = array();
		$a ['id']           = $d->id."_td";
		$a ['waktu']        = self::format ( "date d-M-Y", $d->waktu );
		$a ['nama']         = $d->nama_tindakan." (" . $d->nama_dokter . ") ";
		$a ['biaya']        = $d->harga;
		$a ['keterangan']   = "Dokter (" . $d->nama_dokter . ") : ".ArrayAdapter::format("only-money Rp.", $d->harga);
		$a ['jumlah']       = 1;
		$a ['satuan']       = $d->harga;
		$a ['start']        = $d->waktu;
		$a ['end']          = $d->waktu;
        $a ['debet']        = getSettings($this->db,"smis-rs-acc-d-tindakan-dokter-".$this->polislug."-".$d->carabayar,"");
		$a ['kredit']       = getSettings($this->db,"smis-rs-acc-k-tindakan-dokter-".$this->polislug."-".$d->carabayar,"");
		$this->content[]    = $a;

		if($d->harga_perawat>0){
			$a                  = array();
			$a ['id']           = $d->id."_atd";
			$a ['waktu']        = self::format ( "date d-M-Y", $d->waktu );
			$a ['nama']         = "Assisten ".$d->nama_tindakan;
			$a ['biaya']        = $d->harga_perawat;
			$a ['keterangan']   = "Assisten (".$d->nama_asisten." ) : ".ArrayAdapter::format("only-money Rp.", $d->harga_perawat);
			$a ['jumlah']       = 1;
			$a ['satuan']       = $d->harga_perawat;
			$a ['start']        = $d->waktu;
			$a ['end']          = $d->waktu;
            $a ['debet']        = getSettings($this->db,"smis-rs-acc-d-perawat-tindakan-dokter-".$this->polislug."-".$d->carabayar,"");
            $a ['kredit']       = getSettings($this->db,"smis-rs-acc-k-perawat-tindakan-dokter-".$this->polislug."-".$d->carabayar,"");
			$this->content[]    = $a;
		}

		if($d->operator>0){
			$a                  = array();
			$a ['id']           = $d->id."_btd";
			$a ['waktu']        = self::format ( "date d-M-Y", $d->waktu );
			$a ['nama']         = $d->nama_tindakan;
			$a ['biaya']        = $d->operator;
			$a ['keterangan']   = "Bagi Dokter (".$d->nama_dokter." ) : ".ArrayAdapter::format("only-money Rp.", $d->operator);
			$a ['jumlah']       = 1;
			$a ['satuan']       = $d->operator;
			$a ['start']        = $d->waktu;
			$a ['end']          = $d->waktu;
			$a ['akunting_only'] 	= 1;
			$this->content[]    	= $a;
		}

		if($d->bagi_rs>0){
			$a                  = array();
			$a ['id']           = $d->id."_brs";
			$a ['waktu']        = self::format ( "date d-M-Y", $d->waktu );
			$a ['nama']         = $d->nama_tindakan;
			$a ['biaya']        = $d->bagi_rs;
			$a ['keterangan']   = "Bagi RS (".$d->nama_dokter." ) : ".ArrayAdapter::format("only-money Rp.", $d->bagi_rs);
			$a ['jumlah']       = 1;
			$a ['satuan']       = $d->bagi_rs;
			$a ['start']        = $d->waktu;
			$a ['end']          = $d->waktu;
			$a ['akunting_only'] 	= 1;
			$this->content[]    	= $a;
		}
		
	}
	
	public function getContent($data){
		foreach($data as $d){
			$this->adapt($d);
		}
		return $this->content;
	}
	
}


?>