<?php 
loadLibrary("smis-libs-function-medical");
require_once "smis-base/smis-include-service-consumer.php";
class AntrianAdapter extends ArrayAdapter {
	private $jumlah_pasien=0;
    private $jumlah_bed=0;
    private $register_data;
	public function __construct($jumlah_pasien){
		$this->jumlah_pasien=$jumlah_pasien;
        loadLibrary("smis-libs-function-time");
		parent::__construct();
	}
	
	public function getDokumenStatus($id,$dokumen){
		$content=get_dokumen_status($dokumen);
		$selection=new Select("","",$content);
		$selection->setAction("antrian.save_document('".$id."',this.value)");
		return $selection->getHtml();
	}
	
	public function getJumlahBed(){
		return $this->jumlah_bed;
	}
	
	public function setJumlahBed($jml){
		$this->jumlah_bed=$jml;
	}
	
	public function getContent($set){
        $lnoreg = array();
        foreach($set as $u){
            $lnoreg[] = $u->no_register;
        }
        global $db;
        $serv = new ServiceConsumer($db,"get_bulk_register_data",NULL,"registration");
        $serv ->addData("noreg",json_encode($lnoreg));
        $serv ->execute();
        $this->register_data = $serv ->getContent();

        $result=parent::getContent($set);
        global $db;
        if(getSettings($db,"smis-rs-urjip-".$_POST['prototype_slug'],"URJ")!="URJ"){
            $total=array();
            $total['Asal']="<strong>Jumlah Pasien Aktif</strong>";
            $total['Kunjungan']=$this->jumlah_pasien." Orang";
            $total['Umur']="<strong>Jumlah Bed</strong>";
            $total['Cara Bayar']=$this->jumlah_bed." Bed";
            if($this->jumlah_bed<$this->jumlah_pasien){
                $total['Alamat']="<i class='fa fa-warning fa-3x' ></i> ";
                $total['Dokumen']="Jumlah Pasien Sudah Melebihi Kapasitas !!";
            }		
            $result[]=$total;    
        }
		return $result;
	}
	
	public function adapt($d) {
        $this->number ++;
		$detail 			= json_decode($d->detail,true);
		$l                  = array ();
		$l['id']            = $d->id;
		$l['No. Urut']      = $this->number.". ";
		$l['Tanggal Masuk'] = self::format("date d-M-Y H:i", $d->waktu);;
		$l['No. RM']        = self::format('digit6', $d->nrm_pasien);
        $l['No. BPJS']      = $d->no_bpjs;    
        $l["No. Reg"]       = self::format('digit6',$d->no_register);    
        $l['Umur']          = $d->umur;
        $l['Jenis Kelamin'] = $d->jk == "0" ? "Laki-laki" : "Perempuan";
        $l['Cara Bayar']    = strtoupper($d->carabayar).(isset($this->register_data[$d->no_register]) && $this->register_data[$d->no_register]['nama_asuransi']!=""?" - ".$this->register_data[$d->no_register]['nama_asuransi']:"");
        $l['Nama Pasien']   = $d->nama_pasien;
        $l['Status']        = $d->selesai=="0"?"Belum Dilayani":"Sudah Dilayani";
        $l['Jenis Kunjungan']  = (isset($this->register_data[$d->no_register]) && $this->register_data[$d->no_register]['jenis_kunjungan']!=""?$this->register_data[$d->no_register]['jenis_kunjungan']:"");
        /*
		$l['Asal']          = self::format("unslug", $d->asal);
		$l['Golongan']      = $d->golongan_umur;
		$l['Dokumen']       = $this->getDokumenStatus($d->id,$d->dokumen);
		
		$l['NRM']           = self::format('digit6', $d->nrm_pasien);
        $l['Titipan']       = self::format('trivial_1_<i class="fa fa-check">_', $d->titipan);
		$compare            = date_compare($d->waktu, date("Y-m-d"));
		$l["Waktu"]         = self::format("date d-M-Y H:i", $d->waktu);
		$l["No. Profile"]   = $detail['no_profile'];
		if ($compare == - 1) {
			$l["Waktu"]     = "<font class='label label-important'>".$l["Waktu"]."</font>";
		} else if ($compare == 1) {
			$l["Waktu"]     = "<font class='label label-success'>".$l["Waktu"]."</font>";
		} else {
			$l["Waktu"]     = "<font class='label label-info'>".$l["Waktu"]."</font>";
		}
		$l["No. Register"]  = self::format('digit6',$d->no_register);
        $l["No. Bed"]       = $d->bed_kamar;
        */
       
		return $l;
	}
}
?>