<?php
require_once 'smis-framework/smis/template/ModulTemplate.php';
require_once ("smis-base/smis-include-service-consumer.php");
require_once ("smis-libs-hrd/DKResponder.php");

require_once "smis-libs-hrd/EmployeeResponder.php";
require_once 'radiology/class/responder/RadiologyResponder.php';
require_once 'radiology/class/RuanganService.php';
require_once 'smis-libs-manajemen/ProvitSharingService.php';
require_once 'radiology/class/TarifRadiology.php';
require_once 'radiology/resource/RadiologyResource.php';
require_once 'radiology/class/table/RadiologyTable.php';

/**
 * 
 * this class is used for creating Radiology Logic System
 * including the Radiology Bussiness Process
 * Clearing The Summernote and etc.
 * 
 * @author goblooge
 * @since 28 Oct 2014
 * @version 1.0.1
 * @license Propietary
 * @copyright Nurul Huda <goblooge@gmail.com>
 */
class RadiologyTemplate extends ModulTemplate {
	protected $db;
	protected $mode;
	protected $polislug;
	protected $page;
	protected $protoslug;
	protected $protoname;
	protected $protoimplement;
	protected $action;
	protected $dbtable;
	protected $uitable;
	protected $noreg_pasien;
	protected $nama_pasien;
	protected $nrm_pasien;
	protected $jk;
	protected $list_pesan;
	protected $list_hasil;
	protected $all_component;
	protected $carabayar;
	protected $umur;
	protected $alamat;
	protected $kelas;
	protected $resource;
	protected $uri;
	protected $is_stand_alone;
	public static $MODE_DAFTAR = "pendaftaran";
	public static $MODE_PERIKSA = "pemeriksaan";
	public static $MODE_ARCHIVE = "arsip_terbaca";
	public static $MODE_UNREAD = "arsip_tidak_terbaca";
	public function __construct($db, $mode, $polislug = "all", $noreg = "", $nrm = "", $nama = "", $jk = "", $page = "radiology", $action = "pemeriksaan", $protoslug = "", $protoname = "", $protoimplement = "",$kelas="rawat_jalan") {
		$this->db = $db;
		$this->mode = $mode;
		$this->noreg_pasien = $noreg;
		$this->nama_pasien = $nama;
		$this->nrm_pasien = $nrm;
		$this->jk = $jk;
		$this->carabayar = "Number Register Not Active";
		$this->polislug = $polislug;
		$this->dbtable = new DBTable($db, "smis_rad_pesanan");
		$this->is_stand_alone=getSettings($db, "radiology-sistem-model", "Stand Alone")=="Stand Alone";
		$this->page = $page;
		$this->protoslug = $protoslug;
		$this->protoimplement = $protoimplement;
		$this->protoname = $protoname;
		$this->action = $action;
		$this->kelas = $kelas;
		$this->alamat = "";
		$this->uri=0;
		$this->initComponent ();
		if ($noreg != "") {
			$data_post = array ("command" => "edit","id" => $noreg );
			$service = new ServiceConsumer($this->db, "get_registered", $data_post);
			$service->execute ();
			$data = $service->getContent ();
			if($data !=NULL){
				$this->carabayar = $data ['carabayar'];
				$this->uri=$data['uri'];
				$this->umur = $data ['umur'];
				$this->alamat = $data['alamat_pasien'];
				if($this->jk=="-1")
					$this->jk=$data['kelamin'];
			}
		}
		if ($polislug != "all") {
			$this->dbtable->addCustomKriteria("ruangan", "='" . $polislug . "'");
		}
		if ($noreg != "") {
			$this->dbtable->addCustomKriteria("noreg_pasien", "='" . $noreg . "'");
		}
		$header=array ("No.",'Tanggal','Pasien',"NRM","No. Reg",'Kelas',"Biaya","Ruangan","No. Rad", "Lampiran");
		$this->uitable = new RadiologyTable($header, ArrayAdapter::format("unslug", $this->mode) . " RADIOLOGY " . ($this->polislug == "all" ? "" : strtoupper($this->protoname)), NULL, true);
		$this->uitable->setName($action);
		$this->uitable->setSystemModel($this->is_stand_alone);
		$this->uitable->setCode($this->mode,$this->dbtable);
	}
	public function initComponent() {
		$this->resource= new RadiologyResource ();
		$this->all_component = &$this->resource->list_layanan;
		$this->list_pesan = &$this->resource->list_name;
		$this->list_hasil = &$this->resource->list_name;
		$this->list_default_pria = &$this->resource->list_default_pria;
		$this->list_default_wanita = &$this->resource->list_default_wanita;
	}
	public function command($command) {
		$adapter = new SimpleAdapter ();
        $adapter->setUseNumber(true,"No.","back.");
		$adapter->add("Tanggal", "tanggal", "date d M Y");
		$adapter->add("Pasien", "nama_pasien");
		$adapter->add("NRM", "nrm_pasien", "digit8");
		$adapter->add("No. Reg", "noreg_pasien", "digit8");
		$adapter->add("Biaya", "total_biaya", "money Rp.");
		$adapter->add ("Lampiran", "file", "files-image-show");
		$adapter->add("Kelas", "kelas");
		$adapter->add("Ruangan", "ruangan", "unslug");
		$adapter->add("No. Rad", "no_lab");
		$adapter->add("selesai", "selesai");
		if ($_POST['command'] == "list") {
			//custom view to accomodate regular checkup fee + additional checkup fee:
			$filter = "1";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (tanggal LIKE '" . $_POST['kriteria'] . "' OR nama_pasien LIKE '%" . $_POST['kriteria'] . "%' OR nrm_pasien LIKE '%" . $_POST['kriteria'] . "%' OR noreg_pasien LIKE '%" . $_POST['kriteria'] . "%' OR no_lab LIKE '%" . $_POST['kriteria'] . "%')";
			}
			$mode_filter = "";
			if ($this->mode == RadiologyTemplate::$MODE_DAFTAR || $this->mode == RadiologyTemplate::$MODE_PERIKSA) {
				$mode_filter = "AND  (selesai = '0' OR selesai = -2) ";
			} else if ($this->mode == RadiologyTemplate::$MODE_ARCHIVE) {
				$mode_filter = "AND selesai = '1'";
			} else if ($this->mode == RadiologyTemplate::$MODE_UNREAD) {
				$mode_filter = "AND selesai = '-1'";
			}
			
			if($this->noreg_pasien!="" && $this->noreg_pasien!="0"){
				$filter .= " AND noreg_pasien='".$this->noreg_pasien."' ";
			}
			
			$query_value = "
				SELECT *, (biaya + biaya_lain) AS 'total_biaya'
				FROM (
					SELECT a.*, SUM(CASE WHEN b.prop = 'del' OR b.jumlah IS NULL THEN 0 ELSE b.jumlah END * CASE WHEN b.prop = 'del' OR b.harga_layanan IS NULL THEN 0 ELSE b.harga_layanan END) AS 'biaya_lain'
					FROM smis_rad_pesanan a LEFT JOIN smis_rad_dpesanan_lain b ON a.id = b.id_pesanan
					WHERE a.prop NOT LIKE 'del' " . $mode_filter . "
					GROUP BY a.id
				) v
				WHERE " . $filter . "
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					SELECT a.*, SUM(CASE WHEN b.prop = 'del' OR b.jumlah IS NULL THEN 0 ELSE b.jumlah END * CASE WHEN b.prop = 'del' OR b.harga_layanan IS NULL THEN 0 ELSE b.harga_layanan END) AS 'biaya_lain'
					FROM smis_rad_pesanan a LEFT JOIN smis_rad_dpesanan_lain b ON a.id = b.id_pesanan
					WHERE a.prop NOT LIKE 'del' " . $mode_filter . "
					GROUP BY a.id
				) v
				WHERE " . $filter . "
			";
			$this->dbtable->setPreferredQuery(true, $query_value, $query_count);
			
		}
        if($command=="list"){
            $this->dbtable->setColumn(array("id","tanggal","nama_pasien","noreg_pasien","nrm_pasien","kelas","total_biaya","ruangan","no_lab","file","selesai"));
        }
        $dbres = new RadiologyResponder($this->dbtable, $this->uitable, $adapter);
		if ($dbres->is("save") && isset($_POST ['kelas']) && $_POST ['kelas']!="") {
			if(getSettings($this->db,"radiology-activate-provit-share","0")=="1"){
                $provit = new ProvitSharingService($this->db, $this->polislug, "smis-pv-radiology",$this->carabayar);
                $provit->execute ();
                $ps = $provit->getContent ();
                $dbres->addColumnFixValue("pembagian", $ps);
            }
            
            //if( !isset($_POST['selesai']) ){
                $harga = new TarifRadiology($this->db, $_POST ['kelas']);
                $harga->execute ();
                $harga_radiology = $harga->getContent ();
                $dbres->addColumnFixValue("harga", $harga_radiology);                
            //}
		}
		$dbres->setJsonColumn(array ("hasil","periksa"));
		if ($command == "save" && isset($_POST ['no_lab']) && ($_POST ['no_lab'] == '' || $_POST ['no_lab'] == '0')) {
			if ($_POST ['id'] == "" || $_POST ['id'] == "0") {
				$nomor = $this->dbtable->getNextID () * 1 ;
				$dbres->addColumnFixValue("no_lab", "RAD-" . $_POST ['noreg_pasien'] . "/" . to_romawi(date("m")) . "/" . date("y") . "/" . $nomor);
			} else {
				$dbres->addColumnFixValue("no_lab", "RAD-" . $_POST ['noreg_pasien'] . "/" . to_romawi(date("m")) . "/" . date("y") . "/" . $_POST ['id']);
			}
		}
        
		$data = $dbres->command($command);
		echo json_encode($data);
		return;
	}
	
	public function setPemeriksaanPreload(){
		if($this->mode==self::$MODE_PERIKSA){
			if(getSettings($this->db,"radiology-ui-pemeriksaan-add-tindakan","1")=="0"){
				$this->uitable->setAddButtonEnable(false);
			}
		}
	}
	
	public function phpPreLoad() {
		$this->setPemeriksaanPreload();
		$service = new RuanganService($this->db);
		$service->execute ();
		$ruangan = $service->getContent ();
		
		$nama_konsultan = getSettings($this->db, "radiology-konsultan-nama", "");
		$id_konsultan = getSettings($this->db, "radiology-konsultan-id", "");		
		require_once 'smis-base/smis-include-service-consumer.php';
		$service = new ServiceConsumer($this->db, "get_kelas");
		$service->execute ();
		$kelas = $service->getContent ();
		$option_kelas = new OptionBuilder ();
		foreach($kelas as $k) {
			$nama = $k ['nama'];
			$slug = $k ['slug'];
			$option_kelas->add($nama, $slug, $slug == $this->kelas ? "1" : "0");
		}
		
		$jkselect=new OptionBuilder();
		$jkselect->add("L","0",$this->jk=="0")->add("P","1",$this->jk=="1");
		
		$this->uitable->addModal("id", "hidden", "", "");
		$this->uitable->addModal("tanggal", "date", "Tanggal", date("Y-m-d"));
		$this->uitable->addModal("no_lab", "text", "No. Radiologi", "", "y", null, false);
		$this->uitable->addModal("noreg_pasien", "chooser-" . $this->action . "-rad_pasien-Pilih Pasien", "No Reg", $this->noreg_pasien, "n", null, true);
		$this->uitable->addModal("nama_pasien", "text", "Pasien", $this->nama_pasien, "n", null, true);
		$this->uitable->addModal("nrm_pasien", "text", "NRM", $this->nrm_pasien, "n", null, true);
		$this->uitable->addModal("kelas", "select", "Kelas", $option_kelas->getContent (), "n", null, false);
		$this->uitable->addModal("id_dokter", "hidden", "", "", "y", null, true);
		$this->uitable->addModal("nama_dokter", "chooser-" . $this->action . "-rad_dokter", "Pengirim", "", "n", null, true);
		$this->uitable->addModal("id_konsultan", "hidden", "", $id_konsultan, "y", null, true);
		$this->uitable->addModal("nama_konsultan", "chooser-" . $this->action . "-rad_konsultan", "Konsultan", $nama_konsultan, "y", null, true);
		$this->uitable->addModal("nama_petugas", "chooser-" . $this->action . "-rad_petugas", "Petugas", "", "y", null, true);
		$this->uitable->addModal("id_petugas", "hidden", "", "", "y", null, true);
		$this->uitable->addModal("carabayar", "text", "Jenis Pasien", $this->carabayar, "y", null, true);
		$this->uitable->addModal ("file", "files-image-upload", "Lampiran", "", "y", null, true);
		
		if ($this->polislug == "all" || $this->is_stand_alone){
			$this->uitable->addModal("ruangan", "select", "Asal Ruangan", $ruangan);
		}else{
			$this->uitable->addModal("ruangan", "text", "Asal Ruangan", $this->polislug, "n", null, true);
		}
		$this->uitable->addModal("id_konsultan", "text", "NIP Konsultan", $id_konsultan, "n", null, true);
		$this->uitable->addModal("umur", "text", "Umur", $this->umur, "y", null, false);
		
		$this->uitable->addModal("froll", "text", "F Roll", "", "y", "numeric");
		$this->uitable->addModal("f1824", "text", "F 18x24", "", "y", "numeric");
		$this->uitable->addModal("f2430", "text", "F 24x30", "", "y", "numeric");
		$this->uitable->addModal("f3040", "text", "F 30x40", "", "y", "numeric");
		$this->uitable->addModal("f3535", "text", "F 35x35", "", "y", "numeric");
		$this->uitable->addModal("f3543", "text", "F 35x43", "", "y", "numeric");
		$this->uitable->addModal("sdq4335", "text", "D-SDQ 43x35", "", "y", "numeric");
		$this->uitable->addModal("dhf3543", "text", "DHF 35x43", "", "y", "numeric");
		$this->uitable->addModal("dhf2636", "text", "DHF 26x36", "", "y", "numeric");
		$this->uitable->addModal("dhf2025", "text", "DHF 20x25", "", "y", "numeric");
		$this->uitable->addModal("dvb3543", "text", "DVB 35x43", "", "y", "numeric");
		$this->uitable->addModal("dvb3528", "text", "DVB 35x28", "", "y", "numeric");
		$this->uitable->addModal("dvb2025", "text", "DVB 20x25", "", "y", "numeric");
		
		if(getSettings($this->db,"radiology-show-reject","0")=="1"){
			$this->uitable->addModal("frollr", "text", "RF Roll", "", "y", "numeric");	
			$this->uitable->addModal("f1824r", "text", "RF 18x24", "", "y", "numeric");
			$this->uitable->addModal("f2430r", "text", "RF 24x30", "", "y", "numeric");
			$this->uitable->addModal("f3040r", "text", "RF 30x40", "", "y", "numeric");
			$this->uitable->addModal("f3535r", "text", "RF 35x35", "", "y", "numeric");
			$this->uitable->addModal("f3543r", "text", "RF 35x43", "", "y", "numeric");			
		}
		
		$this->uitable->addModal("fdental", "text", "F Dental", "", "y", "numeric");
		$this->uitable->addModal("biaya_konsul", "money", "Biaya Konsul", "", "y", null);
		
		$modal = $this->uitable->getModal ();
		$modal->setTitle("Pesanan");
		
		$btn = new Button("", "", "Print");
		$btn->setIsButton(Button::$ICONIC_TEXT);
		$btn->setIcon("fa fa-print");
		$btn->setAction("rad_print()");
		$btn->setClass("btn-primary");
		$modal->addFooter($btn);
		
		$btn = new Button("", "", "Tag");
		$btn->setIsButton(Button::$ICONIC_TEXT);
		$btn->setIcon("fa fa-tag");
		$btn->setAction("tag_print()");
		$btn->setClass("btn-primary");
		$modal->addFooter($btn);

		$tabulator = new Tabulator("pesan", "pesanan", Tabulator::$POTRAIT);
		
        require_once 'radiology/resource/modal_pesanan.php';
		$psn = new RadiologyModalPesanan($this->all_component);
		$tabulator->add("rad_perika", "Pemeriksaan", $psn, Tabulator::$TYPE_COMPONENT," fa fa-stethoscope");		
		
        require_once 'radiology/resource/modal_hasil.php';
		$hsl = new RadiologyModalHasil($this->resource);
		$tabulator->add("rad_hasil", "Hasil", $hsl, Tabulator::$TYPE_COMPONENT, " fa fa-address-book",$this->action);		
		
        require_once 'radiology/resource/modal_lain.php';
		$lain = new RadiologyModalLain();
		$tabulator->add("rad_lain", "Lain-Lain", $lain, Tabulator::$TYPE_COMPONENT," fa fa-list");
		
        if(getSettings($this->db,"radiology-show-diagnosa","0")=="1" && $this->mode!=self::$MODE_DAFTAR){
            $tabulator->add("rad_diagnosa", "Diagnosa", "<div id='page_diagnosa_radiology'></div>", Tabulator::$TYPE_HTML,"fa fa-user-md","diagnosa_radiology()");
        }
        
        $modal->addHTML($tabulator->getHtml ());
		$modal->setClass(Modal::$FULL_MODEL);
		
		// modal layanan lain:
		$layanan_lain_modal = new Modal("layanan_lain_add_form", "smis-form-container", "layanan_lain");
		$layanan_lain_modal->setTitle("Layanan Lain");
		$id_hidden = new Hidden("layanan_lain_id", "layanan_lain_id", "");
		$layanan_lain_modal->addElement("", $id_hidden);
		$nama_layanan_text = new Text("layanan_lain_nama", "layanan_lain_nama", "");
		$nama_layanan_text->addAtribute("autofocus");
		$layanan_lain_modal->addElement("Nama", $nama_layanan_text);
		$harga_layanan_text = new Text("layanan_lain_harga", "layanan_lain_harga", "");
		$harga_layanan_text->setTypical("money");
		$harga_layanan_text->setAtribute(" data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\" " );
		$layanan_lain_modal->addElement("Harga Satuan", $harga_layanan_text);
		$jumlah_text = new Text("layanan_lain_jumlah", "layanan_lain_jumlah", "1");
		$layanan_lain_modal->addElement("Jumlah", $jumlah_text);
		$subtotal_text = new Text("layanan_lain_subtotal", "layanan_lain_subtotal", "");
		$subtotal_text->setTypical("money");
		$subtotal_text->setAtribute("data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\" disabled='disabled' ");
		$layanan_lain_modal->addElement("Subtotal", $subtotal_text);
		$button = new Button("", "", "Simpan");
		$button->setClass("btn-success");
		$button->setIcon("fa fa-floppy-o");
		$button->setIsButton(Button::$ICONIC);
		$button->setAtribute("id='layanan_lain_save_btn'");
		$layanan_lain_modal->addFooter($button);
		
		echo $this->jsSetup("RAD_MODE","",$this->mode);
		echo $this->jsSetup("RAD_NOREG","",$this->noreg_pasien);
		echo $this->jsSetup("RAD_NAMA","",$this->nama_pasien);
		echo $this->jsSetup("RAD_NRM","",$this->nrm_pasien);
		echo $this->jsSetup("RAD_POLISLUG","",$this->polislug);
		echo $this->jsSetup("RAD_PAGE","",$this->page);
		echo $this->jsSetup("RAD_PREFIX","",$this->action);
		echo $this->jsSetup("RAD_PROTOSLUG","",$this->protoslug);
		echo $this->jsSetup("RAD_PROTONAME","",$this->protoname);
		echo $this->jsSetup("RAD_PROTOIMPLEMENT","",$this->protoimplement);
		echo $this->jsSetup("RAD_JK","",$this->jk);
		echo $this->jsSetup("RAD_LIST_PESAN","",json_encode($this->list_pesan));
		echo $this->jsSetup("RAD_LIST_HASIL","",json_encode($this->list_hasil));
		echo $this->jsSetup("RAD_EDIT_HASIL","",getSettings($this->db,"radiology-ui-pemeriksaan-edit-tindakan","0"));
		echo $this->jsSetup("RAD_EDIT_LAYANAN","",getSettings($this->db,"radiology-ui-pemeriksaan-edit-hasil","0"));
		
		
		require_once 'radiology/resource/print_header.php';
		require_once 'radiology/resource/print_footer.php';
		echo $this->uitable->getHtml ();
		echo $modal->getHtml ();
		echo $layanan_lain_modal->getHtml();
		
		echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
		echo addJS ( "framework/bootstrap/js/bootstrap-datetimepicker.js" );
		echo addJS("framework/smis/js/table_action.js");		
		echo addJS ( "radiology/resource/js/radiology_function.js",false);
		echo addJS ( "radiology/resource/js/layanan_lain.js",false);
		echo addJS ( "radiology/resource/js/radiology_action.js",false);	
		echo addJS ( "radiology/resource/js/radiology.js",false); 
		echo '<script type="text/javascript">var '.$this->action.'=RAD_ACTION; </script>';
		echo addJS ( "radiology/resource/js/radiology_supercommand.js",false); 
		echo addJS ( "radiology/resource/js/radiology_typeahead.js",false); 
		echo addJS ( "radiology/resource/js/radiology_diagnosa.js",false); 
		loadLibrary("smis-libs-function-javascript");
		
		echo addCSS("framework/bootstrap/css/datepicker.css");
		echo addCSS ( "framework/bootstrap/css/bootstrap-datetimepicker.css" );
		
		echo addCSS("radiology/resource/css/radiology.css",false);
		echo "<style type='text/css'>";
		$margin_right=getSettings($this->db, "radiology-print-margin-right", "0");
		$margin_left=getSettings($this->db, "radiology-print-margin-left", "0");
		echo "#printing_area > div{margin-left:".$margin_left."px !important; margin-right:".$margin_right."px !important; }";
		echo "</style>";
	}
	
	private function jsSetup($id,$name,$value){
		$hidden=new Hidden($id,$name,$value);
		return $hidden->getHtml();
	}
	
	public function superCommand($super_command) {
		$header=array (	'Nama','Jabatan',"NIP");
		$dktable = new Table($header, "", NULL, true);
		$dktable->setName("rad_dokter");
		$dktable->setModel(Table::$SELECT);
		$kktable = new Table ($header, "", NULL, true);
		$kktable->setName("rad_konsultan");
		$kktable->setModel(Table::$SELECT);
		$pettable = new Table ($header, "", NULL, true);
		$pettable->setName("rad_petugas");
		$pettable->setModel(Table::$SELECT);
		
		$dkadapter = new SimpleAdapter ();
		$dkadapter->add("Jabatan", "nama_jabatan");
		$dkadapter->add("Nama", "nama");
		$dkadapter->add("NIP", "nip");
		$dkresponder = new EmployeeResponder($this->db, $dktable, $dkadapter, "");
		$kkresponder = new DKResponder($this->db, $kktable, $dkadapter, "employee");
		$petresponder = new EmployeeResponder($this->db, $pettable, $dkadapter, "rad");
		
		/* PASIEN */
		$phead=array ('Nama','NRM',"No Reg");
		$ptable = new Table($phead, "", NULL, true);
		$ptable->setName("rad_pasien");
		$ptable->setModel(Table::$SELECT);
		$padapter = new SimpleAdapter ();
		$padapter->add("Nama", "nama_pasien");
		$padapter->add("NRM", "nrm", "digit8");
		$padapter->add("No Reg", "id");
		$presponder = new ServiceResponder($this->db, $ptable, $padapter, "get_registered");
		
		$super = new SuperCommand ();
		$super->addResponder("rad_petugas", $petresponder);
		$super->addResponder("rad_dokter", $dkresponder);
		$super->addResponder("rad_konsultan", $kkresponder);
		$super->addResponder("rad_pasien", $presponder);
		$init = $super->initialize ();
		if ($init != null) {
			echo $init;
			return;
		}
	}
}


?>
