<?php
	require_once("smis-base/smis-include-duplicate.php");
	global $db;
	
	$table = new Table(
		array("No.", "ID-Data", "Kode", "Nama", "Jenis", "BPJS", "Formularium", "Alat Kesehatan", "Paten", "Generik", "Narkotika", "Psikotropika", "Prekursor Farmasi", "Satuan", "Konversi", "Sat. Konversi"),
		"",
		null,
		true
	);
	$table->setName("obat_alkes");
	
	$joa_table = new Table(
		array("No.", "Kode", "Nama Jenis Obat dan Alkes"),
		"",
		null,
		true
	);
	$joa_table->setName("jenis_obat_alkes");
	$joa_table->setModel(Table::$SELECT);
	$joa_adapter = new SimpleAdapter(true, "No.");
	$joa_adapter->add("Kode", "kode");
	$joa_adapter->add("Nama Jenis Obat dan Alkes", "nama");
	$joa_dbtable = new DBTable($db, "smis_pr_jenis_barang");
	$joa_dbtable->addCustomKriteria(" medis ", " = '1' ");
	$joa_dbtable->setOrder(" id DESC ");
	$joa_dbresponder = new DBResponder(
		$joa_dbtable,
		$joa_table,
		$joa_adapter
	);
	$super_command = new SuperCommand();
	$super_command->addResponder("jenis_obat_alkes", $joa_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_list_dpho") {
			require_once("registration/class/pcare/PCareObat.php");
			$response_package = new ResponsePackage();
            $number           = 0;
            $max              = 500;     
            $criteria         = $_POST['criteria'];
            $pcare            = new PCareObat();
            $pcare->setPCareAuthorization();
            $data             = $pcare->getObat($criteria, $number, $max);
            $total            = $data['response']['count'];
            $code             = $data['metaData']['code'];
            $message          = $data['metaData']['message'];
            $data             = $data['response']['list'];
            $list             = "";
            $nomor            = 1 + $max * $number;
            foreach ($data as $d) {
                $list         .=    "<tr>" .
                                        "<td>" . $nomor . "</td>" .
                                        "<td>" . $d['kdObat'] . "</td>" .
                                        "<td>" . $d['nmObat'] . "</td>" .
                                        "<td>" .
                                        	"<div class='btn-group noprint'>" .
                                        		"<a href='#'' onclick='dpho.select(\"" . ($nomor - 1) . "\")' data-content=\"Pilih\" data-toggle=\"popover\" id='dpho_select' class='input btn btn-info'>" .
                                        			"<i class='fa fa-check'></i>" . 
                                        		"</a>" . 
                                        	"</div>" .
                                        "</td>" .
                                    "</tr>";
                $nomor++;
            }
            $content = array(
                'list'          => $list
            );
            $response_package->setContent($content);
            if ($code == 200)
                $response_package->setStatus(ResponsePackage::$STATUS_OK);
            else {
                $response_package->setStatus(ResponsePackage::$STATUS_FAIL);
                $response_package->setAlertContent("Proses Pengambilan Data Gagal : " . $code, $message, ResponsePackage::$TIPE_DANGER);
                $response_package->setAlertVisible(true);
            }
            echo json_encode($response_package->getPackage());
			return;
		}
		$_POST['medis'] = "1";
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("ID-Data", "id", "digit6");
		$adapter->add("Kode", "kode");
		$adapter->add("Nama", "nama");
		$adapter->add("Jenis", "nama_jenis_barang");
		$adapter->add("BPJS", "bpjs", "trivial_1_&#10003_&#10005");
		$adapter->add("Formularium", "formularium", "trivial_1_&#10003_&#10005");
		$adapter->add("Alat Kesehatan", "alkes", "trivial_1_&#10003_&#10005");
		$adapter->add("Paten", "berlogo", "trivial_1_&#10003_&#10005");
		$adapter->add("Generik", "generik", "trivial_1_&#10003_&#10005");
		$adapter->add("Berlogo", "berlogo", "trivial_1_&#10003_&#10005");
		$adapter->add("Narkotika", "narkotika", "trivial_1_&#10003_&#10005");
		$adapter->add("Psikotropika", "okt", "trivial_1_&#10003_&#10005");
		$adapter->add("Prekursor Farmasi", "prekursor", "trivial_1_&#10003_&#10005");
		$adapter->add("Satuan", "satuan");
		$adapter->add("Konversi", "konversi", "number");
		$adapter->add("Sat. Konversi", "satuan_konversi");
		$dbtable = new DBTable($db, "smis_pr_barang");
		if ($_POST['command'] == "get_last_code") {
			$row = $dbtable->get_row("
				SELECT MAX(kode) AS 'kode_obat'
				FROM smis_pr_barang
				WHERE medis = '1' AND inventaris = '0'
			");
			$data['kode_obat'] = $row->kode_obat;
			echo json_encode($data);
			return;
		} else if ($_POST['command'] == "get_margin_jual") {
			$params = array(
				'id_obat' => $_POST['id_obat'],
			);
			$service_consumer = new ServiceConsumer(
				$db,
				"get_margin_jual_per_obat_pusat",
				$params,
				"gudang_farmasi"
			);
			$service_consumer->setMode(ServiceConsumer::$CLEAN_BOTH);
			$content = $service_consumer->execute()->getContent();
			$margin_jual = 100;
			if ($content[0] != null)
				$margin_jual = $content[0];
			$data['margin_jual'] = $margin_jual;
			echo json_encode($data);
			return;
		}
		$dbtable->addCustomKriteria(" medis ", " = '1' ");
		$dbtable->addCustomKriteria(" inventaris ", " = '0' ");
		if (isset($_POST['filter_bpjs'])) {
			$dbtable->addCustomKriteria(" bpjs ", " LIKE '" . $_POST['filter_bpjs'] . "' ");
		}
		$dbtable->setOrder(" id DESC ");
		$dbresponder = new DuplicateResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		if ($_POST['command'] == "save") {
			$params = array(
				'id_obat' 			=> $data['content']['id'],
				'kode_obat'			=> $_POST['kode'],
				'nama_obat'			=> $_POST['nama'],
				'nama_jenis_obat'	=> $_POST['nama_jenis_barang'],
				'margin_jual'		=> $_POST['margin_jual']
			);
			$service_consumer = new ServiceConsumer(
				$db,
				"push_margin_jual_per_obat_pusat",
				$params,
				"gudang_farmasi"
			);
			$service_consumer->execute();
			$service_consumer = new ServiceConsumer(
				$db,
				"push_margin_jual_per_obat",
				$params
			);
			$service_consumer->execute();
		}
		echo json_encode($data);
		return;
	}

	$form = new Form("", "", "Perencanaan : Daftar Obat dan Alkes");
	$bpjs_option = new OptionBuilder();
	$bpjs_option->add("Semua", "%%", "1");
	$bpjs_option->add("Ya", "1");
	$bpjs_option->add("Bukan", "0");
	$bpjs_select = new Select("filter_bpjs", "filter_bpjs", $bpjs_option->getContent());
	$form->addElement("Jenis Obat BPJS", $bpjs_select);
	
	$modal = new Modal("obat_alkes_add_form", "smis_form_container", "obat_alkes");
	$modal->setTitle("Data Obat dan Alkes");
	$id_hidden = new Hidden("obat_alkes_id", "obat_alkes_id", "");
	$modal->addElement("", $id_hidden);
	$nama_text = new Text("obat_alkes_nama", "obat_alkes_nama", "");
	$modal->addElement("Nama", $nama_text);
	$id_jenis_hidden = new Hidden("obat_alkes_id_jenis_barang", "obat_alkes_id_jenis_barang", "");
	$modal->addElement("", $id_jenis_hidden);
	$jenis_text = new Text("obat_alkes_nama_jenis_barang", "obat_alkes_nama_jenis_barang", "");
	$jenis_text->setAtribute("disabled='disabled'");
	$jenis_text->setClass("smis-one-option-input");
	$jenis_button = new Button("", "", "Pilih");
	$jenis_button->setAtribute("id='jenis_obat_alkes_btn'");
	$jenis_button->setClass("btn-info");
	$jenis_button->setIsButton(Button::$ICONIC);
	$jenis_button->setIcon("icon-white ".Button::$icon_list_alt);
	$jenis_button->setAction("jenis_obat_alkes.chooser('jenis_obat_alkes', 'jenis_obat_alkes_button', 'jenis_obat_alkes', jenis_obat_alkes, 'Jenis Obat')");
	$jenis_input_group = new InputGroup("");
	$jenis_input_group->addComponent($jenis_text);
	$jenis_input_group->addComponent($jenis_button);
	$modal->addElement("Jenis Obat", $jenis_input_group);
	$kode_jenis_text = new Text("obat_alkes_kode_jenis_barang", "obat_alkes_kode_jenis_barang", "");
	$kode_jenis_text->setAtribute("disabled='disabled'");
	$modal->addElement(" ", $kode_jenis_text);
	$kode_text = new Text("obat_alkes_kode", "obat_alkes_kode", "");
	$kode_text->setAtribute("disabled='disabled'");
	$modal->addElement("Kode", $kode_text);
	$kode_dpho_text = new Text("obat_alkes_kode_dpho", "obat_alkes_kode_dpho", "");
	$kode_dpho_text->setAtribute("disabled='disabled'");
	$kode_dpho_text->setClass("smis-one-option-input");
	$kode_dpho_button = new Button("", "", "Pilih");
	$kode_dpho_button->setAtribute("id='kode_dpho_btn'");
	$kode_dpho_button->setClass("btn-info");
	$kode_dpho_button->setIsButton(Button::$ICONIC);
	$kode_dpho_button->setIcon("icon-white ".Button::$icon_list_alt);
	$kode_dpho_button->setAction("dpho.showModal()");
	$kode_dpho_input_group = new InputGroup("");
	$kode_dpho_input_group->addComponent($kode_dpho_text);
	$kode_dpho_input_group->addComponent($kode_dpho_button);
	$modal->addElement("Kode DPHO", $kode_dpho_input_group);
	$nama_dpho_text = new Text("obat_alkes_nama_dpho", "obat_alkes_nama_dpho", "");
	$nama_dpho_text->setAtribute("disabled='disabled'");
	$modal->addElement("Nama DPHO", $nama_dpho_text);
	$bpjs_checkbox = new CheckBox("obat_alkes_bpjs", "", false);
	$modal->addElement("BPJS", $bpjs_checkbox);
	$formularium_checkbox = new CheckBox("obat_alkes_formularium", "", false);
	$modal->addElement("Formularium", $formularium_checkbox);
	$alkes_checkbox = new CheckBox("obat_alkes_alkes", "", false);
	$modal->addElement("Alat Kesehatan", $alkes_checkbox);
	$berlogo_checkbox = new CheckBox("obat_alkes_berlogo", "", false);
	$modal->addElement("Paten", $berlogo_checkbox);
	$generik_checkbox = new CheckBox("obat_alkes_generik", "", false);
	$modal->addElement("Generik", $generik_checkbox);
	$berlogo_checkbox = new CheckBox("obat_alkes_berlogo", "", false);
	$modal->addElement("Berlogo", $berlogo_checkbox);
	$narkotika_checkbox = new CheckBox("obat_alkes_narkotika", "", false);
	$modal->addElement("Narkotika", $narkotika_checkbox);
	$okt_checkbox = new CheckBox("obat_alkes_okt", "", false);
	$modal->addElement("Psikotropika", $okt_checkbox);
	$prekursor_checkbox = new CheckBox("obat_alkes_prekursor", "", false);
	$modal->addElement("Prekursor F.", $prekursor_checkbox);
	$satuan_text = new Text("obat_alkes_satuan", "obat_alkes_satuan", "");
	$modal->addElement("Satuan", $satuan_text);
	$konversi_text = new Text("obat_alkes_konversi", "obat_alkes_konversi", "1");
	$modal->addElement("Konversi", $konversi_text);
	$satuan_konversi_text = new Text("obat_alkes_satuan_konversi", "obat_alkes_satuan_konversi", "");
	$modal->addElement("Sat. Konversi", $satuan_konversi_text);
	$margin_jual_text = new Text("obat_alkes_margin_jual", "obat_alkes_margin_jual", "");
	$modal->addElement("Margin Jual", $margin_jual_text);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setAction("obat_alkes.save()");
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setIsButton(Button::$ICONIC);
	$modal->addFooter($save_button);

	$dpho_modal = new Modal("dpho_modal", "smis_form_container", "dpho_modal");
	$dpho_modal->setTitle("DPHO");
	$search_text = new Text("dpho_search", "dpho_search", "");
    $dpho_modal->addElement("Kode / Nama", $search_text);
    $search_button = new Button("", "", "Tampilkan");
    $search_button->setClass("btn-inverse");
    $search_button->setIsButton(Button::$ICONIC_TEXT);
    $search_button->setIcon("icon-white icon-search");
    $search_button->setAction("dpho.search()");
    $dpho_modal->addElement("", $search_button);
    $dpho_table = new Table(
        array("No.", "Kode DPHO", "Nama DPHO", ""),
        "",
        null,
        true        
    );
    $dpho_table->setName("dpho");
    $dpho_table->setAction(false);
    $dpho_table->setFooterVisible(false);
    $dpho_modal->addBody("dpho_table", $dpho_table);

	echo $dpho_modal->getHtml();
	echo $modal->getHtml();
	echo $form->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("perencanaan/js/jenis_obat_alkes_action.js", false);
	echo addJS("perencanaan/js/obat_alkes_action.js", false);
	echo addJS("perencanaan/js/obat_alkes.js", false);
?>
<style type="text/css">
	#smis_container > div.form-container > form > div > label {
		width: 125px !important;
	}
</style>